/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.ServiceConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@Immutable
@ThreadSafe
public final class S3Configuration
implements ServiceConfiguration,
ToCopyableBuilder<Builder, S3Configuration> {
    private static final boolean DEFAULT_PATH_STYLE_ACCESS_ENABLED = false;
    private static final boolean DEFAULT_ACCELERATE_MODE_ENABLED = false;
    private static final boolean DEFAULT_DUALSTACK_ENABLED = false;
    private static final boolean DEFAULT_CHECKSUM_VALIDATION_ENABLED = true;
    private static final boolean DEFAULT_CHUNKED_ENCODING_ENABLED = true;
    private final boolean pathStyleAccessEnabled;
    private final boolean accelerateModeEnabled;
    private final boolean dualstackEnabled;
    private final boolean checksumValidationEnabled;
    private final boolean chunkedEncodingEnabled;

    private S3Configuration(DefaultS3ServiceConfigurationBuilder builder) {
        this.dualstackEnabled = this.resolveBoolean(builder.dualstackEnabled, false);
        this.accelerateModeEnabled = this.resolveBoolean(builder.accelerateModeEnabled, false);
        this.pathStyleAccessEnabled = this.resolveBoolean(builder.pathStyleAccessEnabled, false);
        this.checksumValidationEnabled = this.resolveBoolean(builder.checksumValidationEnabled, true);
        if (this.accelerateModeEnabled && this.pathStyleAccessEnabled) {
            throw new IllegalArgumentException("Accelerate mode cannot be used with path style addressing");
        }
        this.chunkedEncodingEnabled = this.resolveBoolean(builder.chunkedEncodingEnabled, true);
    }

    public static Builder builder() {
        return new DefaultS3ServiceConfigurationBuilder();
    }

    public boolean pathStyleAccessEnabled() {
        return this.pathStyleAccessEnabled;
    }

    public boolean accelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public boolean dualstackEnabled() {
        return this.dualstackEnabled;
    }

    public boolean checksumValidationEnabled() {
        return this.checksumValidationEnabled;
    }

    public boolean chunkedEncodingEnabled() {
        return this.chunkedEncodingEnabled;
    }

    private boolean resolveBoolean(Boolean customerSuppliedValue, boolean defaultValue) {
        return customerSuppliedValue == null ? defaultValue : customerSuppliedValue;
    }

    public Builder toBuilder() {
        return S3Configuration.builder().dualstackEnabled(this.dualstackEnabled).accelerateModeEnabled(this.accelerateModeEnabled).pathStyleAccessEnabled(this.pathStyleAccessEnabled);
    }

    private static final class DefaultS3ServiceConfigurationBuilder
    implements Builder {
        private Boolean dualstackEnabled;
        private Boolean accelerateModeEnabled;
        private Boolean pathStyleAccessEnabled;
        private Boolean checksumValidationEnabled;
        private Boolean chunkedEncodingEnabled;

        private DefaultS3ServiceConfigurationBuilder() {
        }

        @Override
        public Builder dualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled = dualstackEnabled;
            return this;
        }

        public void setDualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled(dualstackEnabled);
        }

        @Override
        public Builder accelerateModeEnabled(Boolean accelerateModeEnabled) {
            this.accelerateModeEnabled = accelerateModeEnabled;
            return this;
        }

        public void setAccelerateModeEnabled(Boolean accelerateModeEnabled) {
            this.accelerateModeEnabled(accelerateModeEnabled);
        }

        @Override
        public Builder pathStyleAccessEnabled(Boolean pathStyleAccessEnabled) {
            this.pathStyleAccessEnabled = pathStyleAccessEnabled;
            return this;
        }

        public void setPathStyleAccessEnabled(Boolean pathStyleAccessEnabled) {
            this.pathStyleAccessEnabled(pathStyleAccessEnabled);
        }

        @Override
        public Builder checksumValidationEnabled(Boolean checksumValidationEnabled) {
            this.checksumValidationEnabled = checksumValidationEnabled;
            return this;
        }

        public void setChecksumValidationEnabled(Boolean checksumValidationEnabled) {
            this.checksumValidationEnabled(checksumValidationEnabled);
        }

        @Override
        public Builder chunkedEncodingEnabled(Boolean chunkedEncodingEnabled) {
            this.chunkedEncodingEnabled = chunkedEncodingEnabled;
            return this;
        }

        public void setChunkedEncodingEnabled(Boolean chunkedEncodingEnabled) {
            this.chunkedEncodingEnabled(chunkedEncodingEnabled);
        }

        public S3Configuration build() {
            return new S3Configuration(this);
        }
    }

    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, S3Configuration> {
        public Builder dualstackEnabled(Boolean var1);

        public Builder accelerateModeEnabled(Boolean var1);

        public Builder pathStyleAccessEnabled(Boolean var1);

        public Builder checksumValidationEnabled(Boolean var1);

        public Builder chunkedEncodingEnabled(Boolean var1);
    }
}

