/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.response;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpHeaderBlock;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.crt.internal.CrtUtils;
import software.amazon.awssdk.http.crt.internal.response.ResponseHandlerHelper;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.async.SimplePublisher;

@SdkInternalApi
public final class CrtResponseAdapter
implements HttpStreamResponseHandler {
    private static final Logger log = Logger.loggerFor(CrtResponseAdapter.class);
    private final HttpClientConnection connection;
    private final CompletableFuture<Void> completionFuture;
    private final SdkAsyncHttpResponseHandler responseHandler;
    private final SimplePublisher<ByteBuffer> responsePublisher;
    private final SdkHttpResponse.Builder responseBuilder;
    private final ResponseHandlerHelper responseHandlerHelper;

    private CrtResponseAdapter(HttpClientConnection connection, CompletableFuture<Void> completionFuture, SdkAsyncHttpResponseHandler responseHandler) {
        this(connection, completionFuture, responseHandler, (SimplePublisher<ByteBuffer>)new SimplePublisher());
    }

    @SdkTestInternalApi
    public CrtResponseAdapter(HttpClientConnection connection, CompletableFuture<Void> completionFuture, SdkAsyncHttpResponseHandler responseHandler, SimplePublisher<ByteBuffer> simplePublisher) {
        this.connection = (HttpClientConnection)Validate.paramNotNull((Object)connection, (String)"connection");
        this.completionFuture = (CompletableFuture)Validate.paramNotNull(completionFuture, (String)"completionFuture");
        this.responseHandler = (SdkAsyncHttpResponseHandler)Validate.paramNotNull((Object)responseHandler, (String)"responseHandler");
        this.responseBuilder = SdkHttpResponse.builder();
        this.responseHandlerHelper = new ResponseHandlerHelper(this.responseBuilder, connection);
        this.responsePublisher = simplePublisher;
    }

    public static HttpStreamResponseHandler toCrtResponseHandler(HttpClientConnection crtConn, CompletableFuture<Void> requestFuture, SdkAsyncHttpResponseHandler responseHandler) {
        return new CrtResponseAdapter(crtConn, requestFuture, responseHandler);
    }

    public void onResponseHeaders(HttpStream stream, int responseStatusCode, int blockType, HttpHeader[] nextHeaders) {
        this.responseHandlerHelper.onResponseHeaders(stream, responseStatusCode, blockType, nextHeaders);
    }

    public void onResponseHeadersDone(HttpStream stream, int headerType) {
        if (headerType == HttpHeaderBlock.MAIN.getValue()) {
            this.responseHandler.onHeaders((SdkHttpResponse)this.responseBuilder.build());
            this.responseHandler.onStream(this.responsePublisher);
        }
    }

    public int onResponseBody(HttpStream stream, byte[] bodyBytesIn) {
        CompletableFuture writeFuture = this.responsePublisher.send((Object)ByteBuffer.wrap(bodyBytesIn));
        if (writeFuture.isDone() && !writeFuture.isCompletedExceptionally()) {
            return bodyBytesIn.length;
        }
        writeFuture.whenComplete((result, failure) -> {
            if (failure != null) {
                this.handlePublisherError(stream, (Throwable)failure);
                return;
            }
            this.responseHandlerHelper.incrementWindow(stream, bodyBytesIn.length);
        });
        return 0;
    }

    public void onResponseComplete(HttpStream stream, int errorCode) {
        if (errorCode == 0) {
            this.onSuccessfulResponseComplete(stream);
        } else {
            this.onFailedResponseComplete(stream, new HttpException(errorCode));
        }
    }

    private void onSuccessfulResponseComplete(HttpStream stream) {
        this.responsePublisher.complete().whenComplete((result, failure) -> {
            if (failure != null) {
                this.handlePublisherError(stream, (Throwable)failure);
                return;
            }
            this.completionFuture.complete(null);
        });
        this.responseHandlerHelper.cleanUpConnectionBasedOnStatusCode(stream);
    }

    private void handlePublisherError(HttpStream stream, Throwable failure) {
        this.failResponseHandlerAndFuture(stream, failure);
        this.responseHandlerHelper.closeConnection(stream);
    }

    private void onFailedResponseComplete(HttpStream stream, HttpException error) {
        log.debug(() -> "HTTP response encountered an error.", (Throwable)error);
        Throwable toThrow = CrtUtils.wrapWithIoExceptionIfRetryable(error);
        this.responsePublisher.error(toThrow);
        this.failResponseHandlerAndFuture(stream, toThrow);
        this.responseHandlerHelper.closeConnection(stream);
    }

    private void failResponseHandlerAndFuture(HttpStream stream, Throwable error) {
        this.callResponseHandlerOnError(error);
        this.completionFuture.completeExceptionally(error);
    }

    private void callResponseHandlerOnError(Throwable error) {
        try {
            this.responseHandler.onError(error);
        }
        catch (RuntimeException e) {
            log.warn(() -> "Exception raised from SdkAsyncHttpResponseHandler#onError.", (Throwable)e);
        }
    }
}

