/*
 * Decompiled with CFR 0.152.
 */
package com.softmotions.weboot;

import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import com.softmotions.commons.ServicesConfiguration;
import com.softmotions.weboot.WBConfiguration;
import com.softmotions.weboot.WBServletInitializerModule;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WBServletModule<C extends WBConfiguration>
extends ServletModule {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private C cfg;

    public C getConfiguration() {
        return this.cfg;
    }

    protected void configureServlets() {
        this.log.info("Configuring WB modules and servlets");
        ServletContext sc = this.getServletContext();
        if (sc == null) {
            return;
        }
        this.cfg = (WBConfiguration)((Object)sc.getAttribute("com.softmotions.weboot.CFG"));
        if (this.cfg == null) {
            throw new RuntimeException("Application configuration is not registered in the servlet context, key: com.softmotions.weboot.CFG");
        }
        this.bind(WBConfiguration.class).toInstance(this.cfg);
        this.bind(ServicesConfiguration.class).toInstance(this.cfg);
        ClassLoader cl = (ClassLoader)ObjectUtils.firstNonNull((Object[])new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()});
        List mconfigs = this.cfg.xcfg().configurationsAt("modules.module");
        for (HierarchicalConfiguration mcfg : mconfigs) {
            String mclassName = mcfg.getString(".");
            if (StringUtils.isBlank((CharSequence)mclassName)) continue;
            try {
                Class<?> mclass = cl.loadClass(mclassName);
                if (!Module.class.isAssignableFrom(mclass)) {
                    this.log.warn("Module class: {} is not Guice module, skipped", (Object)mclassName);
                    continue;
                }
                this.log.info("Installing '{}' Guice module", (Object)mclassName);
                Object minst = null;
                for (Constructor<?> c : mclass.getConstructors()) {
                    Class<?>[] ptypes = c.getParameterTypes();
                    if (ptypes.length != 1 || !ptypes[0].isAssignableFrom(this.cfg.getClass())) continue;
                    try {
                        minst = c.newInstance(this.cfg);
                    }
                    catch (InvocationTargetException e) {
                        this.log.error("", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                if (minst == null) {
                    minst = mclass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                this.install(minst);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to activate Guice module: " + mclassName, e);
            }
        }
        this.init(this.cfg);
    }

    protected void install(Module module) {
        super.install(module);
        if (module instanceof WBServletInitializerModule) {
            ((WBServletInitializerModule)module).initServlets(this);
        }
    }

    protected abstract void init(C var1);

    public ServletContext getWBServletContext() {
        return this.getServletContext();
    }

    public void serve(String pattern, Class<? extends HttpServlet> servletClass) {
        this.log.info("Serving {} with {}", (Object)pattern, servletClass);
        this.serve(pattern, new String[0]).with(servletClass);
    }

    public void serve(String pattern, Class<? extends HttpServlet> servletClass, Map<String, String> params) {
        this.log.info("Serving {} with {}", (Object)pattern, servletClass);
        this.serve(pattern, new String[0]).with(servletClass, params);
    }

    public void serveAndBind(String pattern, Class<? extends HttpServlet> servletClass, Map<String, String> params) {
        this.log.info("Serving {} with {}", (Object)pattern, servletClass);
        this.bind(servletClass).in(Singleton.class);
        this.serve(pattern, new String[0]).with(servletClass, params);
    }

    public void filter(String pattern, Class<? extends Filter> filterClass) {
        this.log.info("Filter {} with {}", (Object)pattern, filterClass);
        this.filter(pattern, new String[0]).through(filterClass);
    }

    public void filter(String pattern, Class<? extends Filter> filterClass, Map<String, String> params) {
        this.log.info("Filter {} with {}", (Object)pattern, filterClass);
        this.filter(pattern, new String[0]).through(filterClass, params);
    }

    public void filterAndBind(String pattern, Class<? extends Filter> filterClass, Map<String, String> params) {
        this.log.info("Filter {} with {}", (Object)pattern, filterClass);
        this.bind(filterClass).in(Singleton.class);
        this.filter(pattern, new String[0]).through(filterClass, params);
    }
}

