/*
 * Decompiled with CFR 0.152.
 */
package com.softmotions.weboot;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceServletContextListener;
import com.samaxes.filter.CacheFilter;
import com.samaxes.filter.NoCacheFilter;
import com.samaxes.filter.util.CacheConfigParameter;
import com.softmotions.commons.JVMResources;
import com.softmotions.commons.cont.ArrayUtils;
import com.softmotions.commons.cont.Pair;
import com.softmotions.commons.lifecycle.LifeCycleModule;
import com.softmotions.commons.lifecycle.LifeCycleService;
import com.softmotions.web.DirResourcesFilter;
import com.softmotions.web.JarResourcesFilter;
import com.softmotions.weboot.WBConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRegistration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WBServletListener
extends GuiceServletContextListener
implements LifeCycleService {
    private static final Logger log = LoggerFactory.getLogger(WBServletListener.class);
    public static final String WEBOOT_CFG_CLASS_INITPARAM = "WEBOOT_CFG_CLASS";
    public static final String WEBOOT_CFG_LOCATION_INITPARAM = "WEBOOT_CFG_LOCATION";
    public static final String WEBOOT_APP_ID = "WEBOOT_APP_ID";
    public static final String WEBOOT_CFG_SCTX_KEY = "com.softmotions.weboot.CFG";
    protected Injector injector;

    @Deprecated
    protected String getLogo() {
        return null;
    }

    protected String getLogo(WBConfiguration cfg) {
        return null;
    }

    private Pair<String, String> getEnvInitParam(ServletContext sctx, String pname) {
        String ret;
        String appId = sctx.getInitParameter(WEBOOT_APP_ID);
        appId = StringUtils.isBlank((CharSequence)appId) ? null : appId.toUpperCase();
        StringBuilder keys = new StringBuilder();
        while (true) {
            String key;
            String string = key = appId != null ? appId + "_" + pname : pname;
            if (keys.length() > 0) {
                keys.append(", ");
            }
            keys.append(key);
            ret = sctx.getInitParameter(key);
            if (ret == null) {
                ret = System.getProperty(key);
            }
            if (ret == null) {
                ret = System.getenv(key);
            }
            if (ret != null || appId == null) break;
            appId = null;
        }
        return new Pair((Object)ret, (Object)keys.toString());
    }

    public void contextInitialized(ServletContextEvent evt) {
        try {
            FilterRegistration sreg;
            WBConfiguration cfg;
            ServletContext sctx = evt.getServletContext();
            Pair<String, String> ret = this.getEnvInitParam(sctx, WEBOOT_CFG_CLASS_INITPARAM);
            if (ret.getOne() == null) {
                throw new RuntimeException("Failed to find WEBOOT configuration class implementation in [servlet context, system property, system env] under the keys: " + (String)ret.getTwo());
            }
            String cfgClassName = (String)ret.getOne();
            log.info("Using WEBOOT configuration class: {}", (Object)cfgClassName);
            ClassLoader cl = (ClassLoader)ObjectUtils.firstNonNull((Object[])new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()});
            try {
                Class<?> cfgClass = cl.loadClass(cfgClassName);
                if (!WBConfiguration.class.isAssignableFrom(cfgClass)) {
                    throw new RuntimeException("Configuration implementation must extend the: " + WBConfiguration.class + " class");
                }
                cfg = (WBConfiguration)((Object)cfgClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to load/instantiate WEBOOT configuration class: " + cfgClassName, e);
            }
            sctx.setAttribute(WEBOOT_CFG_SCTX_KEY, (Object)cfg);
            ret = this.getEnvInitParam(sctx, WEBOOT_CFG_LOCATION_INITPARAM);
            if (ret.getOne() == null) {
                throw new RuntimeException("Failed to find WEBOOT configuration location in [servlet context, system property, system env] under the KEYS: " + (String)ret.getTwo());
            }
            String cfgLocation = ((String)ret.getOne()).trim();
            cfg.load(cfgLocation, sctx);
            super.contextInitialized(evt);
            for (Map.Entry e : sctx.getFilterRegistrations().entrySet()) {
                sreg = (FilterRegistration)e.getValue();
                for (String m : sreg.getUrlPatternMappings()) {
                    log.info("{} => {} ({})", new Object[]{m, sreg.getName(), sreg.getClassName()});
                }
            }
            for (Map.Entry e : sctx.getServletRegistrations().entrySet()) {
                sreg = (ServletRegistration)e.getValue();
                for (String m : sreg.getMappings()) {
                    log.info("{} => {} ({})", new Object[]{m, sreg.getName(), sreg.getClassName()});
                }
            }
            String logo = this.getLogo();
            if (logo == null) {
                logo = this.getLogo(cfg);
                if (logo != null) {
                    log.info(logo);
                }
            } else {
                log.info(this.getLogo(cfg), new Object[]{cfg.getEnvironmentType(), cfg.getAppVersion(), Runtime.getRuntime().maxMemory()});
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent evt) {
        super.contextDestroyed(evt);
        this.injector = null;
    }

    public Injector getInjector() {
        if (this.injector != null) {
            return this.injector;
        }
        ArrayList<Object> modules = new ArrayList<Object>();
        modules.add(new LifeCycleModule());
        modules.addAll(this.getStartupModules());
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, modules);
        JVMResources.set((String)"com.softmotions.weboot.WBServletListener.Injector", (Object)this.injector);
        return this.injector;
    }

    public void start() {
        ((LifeCycleService)this.getInjector().getInstance(LifeCycleService.class)).start();
    }

    public void stop() {
        if (this.injector != null) {
            ((LifeCycleService)this.injector.getInstance(LifeCycleService.class)).stop();
        }
    }

    public boolean isStarted() {
        return ((LifeCycleService)this.getInjector().getInstance(LifeCycleService.class)).isStarted();
    }

    protected void initCacheHeadersFilters(WBConfiguration env, ServletContext sctx) {
        HierarchicalConfiguration xcfg = env.xcfg();
        List cgroups = xcfg.configurationsAt("cache-headers-groups.cache-group");
        for (HierarchicalConfiguration cfg : cgroups) {
            String name = cfg.getString("name", "");
            String[] patterns = cfg.getStringArray("patterns");
            String prefix = env.getAppPrefix();
            for (int i = 0; i < patterns.length; ++i) {
                String p = patterns[i].trim();
                if (p.charAt(0) != '/') continue;
                patterns[i] = prefix + p;
            }
            if (patterns.length <= 0) continue;
            this.initCacheHeadersFilter(sctx, name, patterns, cfg);
        }
    }

    protected void initCacheHeadersFilter(ServletContext sctx, String name, String[] patterns, HierarchicalConfiguration cfg) {
        if (!cfg.getBoolean("nocache", false)) {
            Object fname = name = "WBCacheFilter" + (String)name;
            FilterRegistration.Dynamic reg = sctx.addFilter((String)fname, CacheFilter.class);
            for (int i = 1; reg == null && i < 100; ++i) {
                fname = (String)name + i;
                reg = sctx.addFilter((String)fname, CacheFilter.class);
            }
            if (reg == null) {
                return;
            }
            reg.setInitParameter(CacheConfigParameter.EXPIRATION.getName(), String.valueOf(cfg.getLong(CacheConfigParameter.EXPIRATION.getName(), 3600L)));
            String val = cfg.getString(CacheConfigParameter.VARY.getName());
            if (!StringUtils.isBlank((CharSequence)val)) {
                reg.setInitParameter(CacheConfigParameter.VARY.getName(), val.trim());
            }
            if (!StringUtils.isBlank((CharSequence)(val = cfg.getString(CacheConfigParameter.MUST_REVALIDATE.getName())))) {
                reg.setInitParameter(CacheConfigParameter.MUST_REVALIDATE.getName(), val.trim());
            }
            if (!StringUtils.isBlank((CharSequence)(val = cfg.getString(CacheConfigParameter.PRIVATE.getName())))) {
                reg.setInitParameter(CacheConfigParameter.PRIVATE.getName(), val.trim());
            }
            log.info("Cache filter: {} for patterns: {}", fname, Arrays.asList(patterns));
            reg.addMappingForUrlPatterns(null, false, patterns);
        } else {
            Object fname = name = "WBNoCacheFilter" + (String)name;
            FilterRegistration.Dynamic reg = sctx.addFilter((String)fname, NoCacheFilter.class);
            for (int i = 1; reg == null && i < 100; ++i) {
                fname = (String)name + i;
                reg = sctx.addFilter((String)fname, NoCacheFilter.class);
            }
            if (reg == null) {
                return;
            }
            log.info("NoCache filter: {} for patterns: {}", fname, Arrays.asList(patterns));
            reg.addMappingForUrlPatterns(null, false, patterns);
        }
    }

    protected void initJarResources(WBConfiguration env, ServletContext sctx) {
        FilterRegistration.Dynamic fr = sctx.addFilter("jarResourcesFilter", JarResourcesFilter.class);
        fr.addMappingForUrlPatterns(null, false, new String[]{env.getAppPrefix() + "/*"});
        List rlist = env.xcfg().configurationsAt("jar-web-resources.resource");
        for (HierarchicalConfiguration rcfg : rlist) {
            String pp = rcfg.getString("path-prefix");
            String[] opts = rcfg.getStringArray("options");
            if (pp == null || opts.length == 0) continue;
            fr.setInitParameter(pp, ArrayUtils.stringJoin((Object)opts, (String)","));
        }
        fr.setInitParameter("strip-prefix", env.getAppPrefix());
    }

    protected void initDirResources(WBConfiguration env, ServletContext sctx) {
        List rlist = env.xcfg().configurationsAt("dir-web-resources.resource");
        int c = 0;
        for (HierarchicalConfiguration rcfg : rlist) {
            String dir = StringUtils.trimToNull((String)rcfg.getString("dir"));
            Object mount = StringUtils.trimToNull((String)rcfg.getString("mount"));
            if (StringUtils.isBlank((CharSequence)dir) || StringUtils.isBlank((CharSequence)mount)) continue;
            File rootFile = new File(dir);
            if (!rootFile.isDirectory()) {
                log.error("Content of directory: '{}' is not accessible", (Object)rootFile.getAbsolutePath());
                continue;
            }
            if (!((String)mount).endsWith("/")) {
                mount = (String)mount + "/";
            }
            if (((String)mount).length() > 1 && ((String)mount).charAt(0) != '/') {
                mount = "/" + (String)mount;
            }
            mount = env.getAppPrefix() + (String)mount + "*";
            log.info("Serving directory: '{}' as {}", (Object)rootFile.getAbsolutePath(), mount);
            FilterRegistration.Dynamic fr = sctx.addFilter("dirResourcesFilter" + c++, DirResourcesFilter.class);
            fr.addMappingForUrlPatterns(null, false, new String[]{mount});
            fr.setInitParameter("rootDir", rootFile.getAbsolutePath());
            fr.setInitParameter("stripPrefix", ((String)mount).substring(0, ((String)mount).length() - 2));
        }
    }

    protected abstract Collection<Module> getStartupModules();
}

