/*
 * Decompiled with CFR 0.152.
 */
package com.softmotions.weboot;

import com.softmotions.commons.ServicesConfiguration;
import com.softmotions.commons.lifecycle.Dispose;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;

public abstract class WBConfiguration
extends ServicesConfiguration {
    private final Properties coreProps;
    private String appPrefix;
    private String appRoot;
    private String environmentType;
    private String dbEnvironment;
    protected ServletContext servletContext;

    protected WBConfiguration() {
        String cpr = this.getCorePropsLocationResource();
        this.coreProps = new Properties();
        if (cpr != null) {
            try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(cpr);){
                if (is == null) {
                    throw new RuntimeException("Jar resource not found: " + cpr);
                }
                this.coreProps.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void load(String location, ServletContext sctx) {
        this.servletContext = sctx;
        this.load(location);
        this.normalizePrefix("site-files-root");
        this.normalizePrefix("app-prefix");
        this.appPrefix = this.xcfg.getString("app-prefix", "");
        this.appRoot = sctx.getContextPath() + this.appPrefix;
        this.environmentType = this.xcfg.getString("environment", "production");
        this.dbEnvironment = this.xcfg.getString("db-environment", "production");
    }

    protected String getCorePropsLocationResource() {
        return null;
    }

    public void load(String location, HierarchicalConfiguration<ImmutableNode> xcfg, ServletContext sctx) {
        this.servletContext = sctx;
        this.load(location, xcfg);
    }

    public String getAppVersion() {
        return this.coreProps.getProperty("project.version");
    }

    public Properties getCoreProperties() {
        return this.coreProps;
    }

    @Nonnull
    public String getApplicationName() {
        return this.xcfg().getString("app-name", "App");
    }

    @Nullable
    public String getLogoutRedirect() {
        String ret = this.xcfg().getString("logout-redirect", null);
        if (StringUtils.isBlank((CharSequence)ret)) {
            return this.xcfg.getString("site.root", null);
        }
        return ret;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Nonnull
    public String getAppPrefix() {
        return this.appPrefix;
    }

    @Nonnull
    public String getAppRoot() {
        return this.appRoot;
    }

    public String getEnvironmentType() {
        return this.environmentType;
    }

    public String getDBEnvironmentType() {
        return this.dbEnvironment;
    }

    public boolean isTesting() {
        return "test".equals(this.getEnvironmentType());
    }

    public boolean isProduction() {
        return this.getEnvironmentType() == null || "production".equals(this.getEnvironmentType());
    }

    public boolean isDevelopment() {
        return "dev".equals(this.getEnvironmentType());
    }

    protected String substituteConfigKey(String key) {
        String s = super.substituteConfigKey(key);
        if (s == null && "webapp".equals(key) && (s = this.getServletContext().getRealPath("/")) != null && s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Nonnull
    public String getAbsoluteLink(HttpServletRequest req, String link) {
        boolean preferRequestUrl = this.xcfg().getBoolean("site.preferRequestUrl", true);
        link = preferRequestUrl ? req.getScheme() + "://" + req.getServerName() + (String)(req.getServerPort() != 80 && req.getServerPort() != 443 ? ":" + req.getServerPort() : "") + (String)link : this.xcfg().getString("site.root") + (String)link;
        return link;
    }

    private void normalizePrefix(String property) {
        Object val = this.xcfg().getString(property, null);
        if (StringUtils.isBlank((CharSequence)val) || "/".equals(val)) {
            val = "";
        } else {
            if (!((String)(val = ((String)val).trim())).startsWith("/")) {
                val = "/" + (String)val;
            }
            if (((String)val).endsWith("/")) {
                val = ((String)val).substring(0, ((String)val).length() - 1);
            }
        }
        this.xcfg().setProperty(property, val);
    }

    @Dispose(order=1)
    public void dispose() {
        super.dispose();
    }
}

