/*
 * Decompiled with CFR 0.152.
 */
package com.softmotions.weboot.testing.tomcat;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.commons.io.FileUtils;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatRunner {
    private static final Logger log = LoggerFactory.getLogger(TomcatRunner.class);
    private Tomcat tomcat;
    private Builder builder;
    private boolean cleanupTmpOnExit;
    private Context context;

    private void doConfigure(Builder b) throws Exception {
        File baseDirFile;
        this.builder = b;
        this.tomcat = new Tomcat();
        if (b.tmpDir == null) {
            Path tempDir = Files.createTempDirectory("tomcat-runner", new FileAttribute[0]);
            b.withTmpDir(tempDir.toString());
            this.cleanupTmpOnExit = b.cleanupTmpOnExit;
        }
        if (!(baseDirFile = new File(b.tmpDir)).isDirectory()) {
            baseDirFile.mkdirs();
        }
        if (!baseDirFile.isDirectory()) {
            throw new Exception("Failed to create base directory: " + baseDirFile);
        }
        log.info("Using basedir: {}", (Object)baseDirFile);
        this.tomcat.setBaseDir(baseDirFile.toString());
        this.tomcat.setPort(b.getPort());
        Connector connector = this.tomcat.getConnector();
        connector.setURIEncoding("UTF-8");
        if (b.resourcesBase == null) {
            return;
        }
        log.info("Context path: '{}'", (Object)b.contextPath);
        this.context = this.tomcat.addWebapp(b.contextPath, new File(b.resourcesBase).getAbsolutePath());
        StandardJarScanner jarScanner = (StandardJarScanner)this.context.getJarScanner();
        jarScanner.setScanClassPath(b.scanClassPath);
        jarScanner.setScanBootstrapClassPath(b.scanBootstrapClassPath);
        jarScanner.setScanAllDirectories(b.scanAllDirectories);
        jarScanner.setScanManifest(b.scanManifest);
        if (b.jarScanFilter != null) {
            jarScanner.setJarScanFilter((jarScanType, jarName) -> b.jarScanFilter.test(jarName));
        }
        if (b.contextResources != null && !b.contextResources.isEmpty()) {
            this.tomcat.enableNaming();
            NamingResourcesImpl namingResources = this.context.getNamingResources();
            b.contextResources.forEach(arg_0 -> ((NamingResourcesImpl)namingResources).addResource(arg_0));
        }
        if (b.realm != null) {
            log.info("Use context realm: {}", (Object)b.realm);
            this.context.setRealm(b.realm);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void start() throws Exception {
        this.tomcat.start();
        log.info("Tomcat server started");
    }

    public void shutdown() throws Exception {
        try {
            this.tomcat.stop();
            this.tomcat.destroy();
            log.info("Tomcat server stopped");
        }
        finally {
            this.context = null;
            if (this.cleanupTmpOnExit) {
                log.info("Delete basedir: {}", (Object)this.builder.tmpDir);
                FileUtils.deleteDirectory((File)new File(this.builder.tmpDir));
            }
        }
    }

    public <T> T getContextEventListener(Class<T> type) {
        if (this.context != null) {
            for (Object el : this.context.getApplicationLifecycleListeners()) {
                if (!type.isAssignableFrom(el.getClass())) continue;
                return (T)el;
            }
        }
        throw new RuntimeException("Unable to find ContextEventListener of type: " + type);
    }

    public Builder usedBuilder() {
        return this.builder;
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    static {
        TomcatURLStreamHandlerFactory.register();
    }

    public static class Builder {
        private int port = 8282;
        private String contextPath = "";
        private String resourcesBase;
        private String tmpDir;
        private boolean cleanupTmpOnExit = true;
        private Map<String, String> initPararams;
        private List<ContextResource> contextResources;
        private Realm realm;
        private boolean scanClassPath;
        private boolean scanBootstrapClassPath;
        private boolean scanAllDirectories = true;
        private boolean scanManifest = true;
        private Predicate<String> jarScanFilter;

        public Builder withInitParameter(String name, String value) {
            if (this.initPararams == null) {
                this.initPararams = new HashMap<String, String>();
            }
            this.initPararams.put(name, value);
            return this;
        }

        public Builder withContextResource(String name, String auth, String type, String scope, Map<String, String> properties) {
            if (this.contextResources == null) {
                this.contextResources = new ArrayList<ContextResource>();
            }
            ContextResource cr = new ContextResource();
            cr.setName(name);
            if (auth != null) {
                cr.setAuth(auth);
            }
            if (type != null) {
                cr.setType(type);
            }
            if (scope != null) {
                cr.setScope(scope);
            }
            if (properties != null && !properties.isEmpty()) {
                for (Map.Entry<String, String> e : properties.entrySet()) {
                    cr.setProperty(e.getKey(), (Object)e.getValue());
                }
            }
            this.contextResources.add(cr);
            return this;
        }

        public Builder withRealm(Realm reaml) {
            this.realm = reaml;
            return this;
        }

        public Builder withTmpDir(String tmpDir) {
            this.tmpDir = tmpDir;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder withResourcesBase(String resourcesBase) {
            this.resourcesBase = resourcesBase;
            return this;
        }

        public Builder withoutCleanupTmpOnExit() {
            this.cleanupTmpOnExit = false;
            return this;
        }

        public Builder setScanClassPath(boolean scanClassPath) {
            this.scanClassPath = scanClassPath;
            return this;
        }

        public Builder setScanBootstrapClassPath(boolean scanBootstrapClassPath) {
            this.scanBootstrapClassPath = scanBootstrapClassPath;
            return this;
        }

        public Builder setScanAllDirectories(boolean scanAllDirectories) {
            this.scanAllDirectories = scanAllDirectories;
            return this;
        }

        public Builder setScanManifest(boolean scanManifest) {
            this.scanManifest = scanManifest;
            return this;
        }

        public Builder setJarScanFilter(Predicate<String> jarScanFilter) {
            this.jarScanFilter = jarScanFilter;
            return this;
        }

        public TomcatRunner build() throws Exception {
            TomcatRunner runner = new TomcatRunner();
            runner.doConfigure(this);
            return runner;
        }

        public int getPort() {
            return this.port;
        }

        public String getTmpDir() {
            return this.tmpDir;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getResourcesBase() {
            return this.resourcesBase;
        }

        public Map<String, String> getInitPararams() {
            return this.initPararams;
        }
    }
}

