/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junitparams.internal.Utils;
import junitparams.internal.annotation.FrameworkMethodAnnotations;
import junitparams.internal.parameters.ParametersReader;
import junitparams.naming.MacroSubstitutionNamingStrategy;
import junitparams.naming.TestCaseNamingStrategy;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class TestMethod {
    private FrameworkMethod frameworkMethod;
    FrameworkMethodAnnotations frameworkMethodAnnotations;
    private Class<?> testClass;
    private ParametersReader parametersReader;
    private Object[] cachedParameters;
    private TestCaseNamingStrategy namingStrategy;

    public TestMethod(FrameworkMethod method, TestClass testClass) {
        this.frameworkMethod = method;
        this.testClass = testClass.getJavaClass();
        this.frameworkMethodAnnotations = new FrameworkMethodAnnotations(method);
        this.parametersReader = new ParametersReader(this.testClass(), this.frameworkMethod);
        this.namingStrategy = new MacroSubstitutionNamingStrategy(this);
    }

    public String name() {
        return this.frameworkMethod.getName();
    }

    public static List<TestMethod> listFrom(List<FrameworkMethod> annotatedMethods, TestClass testClass) {
        ArrayList<TestMethod> methods = new ArrayList<TestMethod>();
        for (FrameworkMethod frameworkMethod : annotatedMethods) {
            methods.add(new TestMethod(frameworkMethod, testClass));
        }
        return methods;
    }

    public int hashCode() {
        return this.frameworkMethod.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TestMethod && this.hasTheSameNameAsFrameworkMethod((TestMethod)obj) && this.hasTheSameParameterTypesAsFrameworkMethod((TestMethod)obj);
    }

    private boolean hasTheSameNameAsFrameworkMethod(TestMethod testMethod) {
        return this.frameworkMethod.getName().equals(testMethod.frameworkMethod.getName());
    }

    private boolean hasTheSameParameterTypesAsFrameworkMethod(TestMethod testMethod) {
        Object[] frameworkMethodParameterTypes = this.frameworkMethod.getMethod().getParameterTypes();
        Object[] testMethodParameterTypes = testMethod.frameworkMethod.getMethod().getParameterTypes();
        return Arrays.equals(frameworkMethodParameterTypes, testMethodParameterTypes);
    }

    Class<?> testClass() {
        return this.testClass;
    }

    public boolean isIgnored() {
        return this.hasIgnoredAnnotation() || this.hasNoParameters();
    }

    private boolean hasIgnoredAnnotation() {
        return this.frameworkMethodAnnotations.hasAnnotation(Ignore.class);
    }

    private boolean hasNoParameters() {
        return this.isParameterised() && this.parametersSets().length == 0;
    }

    public boolean isNotIgnored() {
        return !this.isIgnored();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.frameworkMethodAnnotations.getAnnotation(annotationType);
    }

    Description describe() {
        if (this.isNotIgnored() && !this.describeFlat()) {
            Description parametrised = Description.createSuiteDescription((String)this.name(), (Annotation[])new Annotation[0]);
            Object[] params = this.parametersSets();
            for (int i = 0; i < params.length; ++i) {
                Object paramSet = params[i];
                String name = this.namingStrategy.getTestCaseName(i, paramSet);
                String uniqueMethodId = Utils.uniqueMethodId(i, paramSet, this.name());
                parametrised.addChild(Description.createTestDescription((String)this.testClass().getName(), (String)name, (Serializable)((Object)uniqueMethodId)));
            }
            return parametrised;
        }
        return Description.createTestDescription(this.testClass(), (String)this.name(), (Annotation[])this.frameworkMethodAnnotations.allAnnotations());
    }

    private boolean describeFlat() {
        return System.getProperty("JUnitParams.flat") != null;
    }

    public Object[] parametersSets() {
        if (this.cachedParameters == null) {
            this.cachedParameters = this.parametersReader.read();
        }
        return this.cachedParameters;
    }

    void warnIfNoParamsGiven() {
        if (this.isNotIgnored() && this.isParameterised() && this.parametersSets().length == 0) {
            System.err.println("Method " + this.name() + " gets empty list of parameters, so it's being ignored!");
        }
    }

    public FrameworkMethod frameworkMethod() {
        return this.frameworkMethod;
    }

    boolean isParameterised() {
        return this.frameworkMethodAnnotations.isParametrised();
    }
}

