/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import zmq.ZError;
import zmq.io.net.Address;

public class TcpUtils {
    private TcpUtils() {
    }

    public static void tuneTcpSocket(SocketChannel channel) throws IOException {
        TcpUtils.setOption(channel, socket -> socket.setTcpNoDelay(true));
    }

    public static boolean setTcpReceiveBuffer(Channel channel, int rcvbuf) {
        TcpUtils.setOption(channel, socket -> socket.setReceiveBufferSize(rcvbuf), socket -> socket.setReceiveBufferSize(rcvbuf));
        return true;
    }

    public static boolean setTcpSendBuffer(Channel channel, int sndbuf) {
        TcpUtils.setOption(channel, socket -> socket.setSendBufferSize(sndbuf));
        return true;
    }

    public static boolean setIpTypeOfService(Channel channel, int tos) {
        TcpUtils.setOption(channel, socket -> socket.setTrafficClass(tos));
        return true;
    }

    public static boolean setReuseAddress(Channel channel, boolean reuse) {
        TcpUtils.setOption(channel, socket -> socket.setReuseAddress(reuse), socket -> socket.setReuseAddress(reuse));
        return true;
    }

    public static void tuneTcpKeepalives(SocketChannel channel, int tcpKeepAlive, int tcpKeepAliveCnt, int tcpKeepAliveIdle, int tcpKeepAliveIntvl) {
        TcpUtils.setOption(channel, socket -> socket.setKeepAlive(tcpKeepAlive == 1));
    }

    private static void setOption(Channel channel, OptionSetter<Socket> setter) {
        TcpUtils.setOption(channel, setter, s -> {});
    }

    private static void setOption(Channel channel, OptionSetter<Socket> setter, OptionSetter<ServerSocket> serverSetter) {
        try {
            if (channel instanceof ServerSocketChannel) {
                serverSetter.setOption(((ServerSocketChannel)channel).socket());
            } else if (channel instanceof SocketChannel) {
                setter.setOption(((SocketChannel)channel).socket());
            }
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    public static void unblockSocket(SelectableChannel ... channels) throws IOException {
        for (SelectableChannel ch : channels) {
            ch.configureBlocking(false);
        }
    }

    public static void enableIpv4Mapping(SelectableChannel channel) {
    }

    public static Address getPeerIpAddress(SocketChannel channel) {
        SocketAddress address = channel.socket().getRemoteSocketAddress();
        return new Address(address);
    }

    private static interface OptionSetter<S> {
        public void setOption(S var1) throws IOException;
    }
}

