/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Locale;
import zmq.Options;
import zmq.SocketBase;
import zmq.ZError;
import zmq.io.IOObject;
import zmq.io.IOThread;
import zmq.io.SessionBase;
import zmq.io.StreamEngine;
import zmq.io.net.Address;
import zmq.io.net.Listener;
import zmq.io.net.StandardProtocolFamily;
import zmq.io.net.tcp.TcpAddress;
import zmq.io.net.tcp.TcpUtils;
import zmq.poll.Poller;
import zmq.socket.Sockets;

public class TcpListener
extends Listener {
    private static final boolean isWindows;
    private TcpAddress address;
    private ServerSocketChannel fd;
    private Poller.Handle handle;
    private String endpoint;
    private final IOObject ioObject;

    public TcpListener(IOThread ioThread, SocketBase socket, Options options) {
        super(ioThread, socket, options);
        this.ioObject = new IOObject(ioThread, this);
        this.fd = null;
    }

    @Override
    public void destroy() {
        assert (this.fd == null);
        assert (this.handle == null);
        this.ioObject.unplug();
    }

    @Override
    protected void processPlug() {
        this.ioObject.plug();
        this.handle = this.ioObject.addFd(this.fd);
        this.ioObject.setPollAccept(this.handle);
    }

    @Override
    protected void processTerm(int linger) {
        this.ioObject.removeHandle(this.handle);
        this.handle = null;
        this.close();
        super.processTerm(linger);
    }

    @Override
    public void acceptEvent() {
        SocketChannel channel;
        try {
            channel = this.accept();
            if (channel == null) {
                this.socket.eventAcceptFailed(this.endpoint, 49);
                return;
            }
            TcpUtils.tuneTcpSocket(channel);
            TcpUtils.tuneTcpKeepalives(channel, this.options.tcpKeepAlive, this.options.tcpKeepAliveCnt, this.options.tcpKeepAliveIdle, this.options.tcpKeepAliveIntvl);
        }
        catch (IOException e) {
            this.socket.eventAcceptFailed(this.endpoint, ZError.exccode(e));
            return;
        }
        StreamEngine engine = null;
        try {
            engine = new StreamEngine(channel, this.options, this.endpoint);
        }
        catch (ZError.InstantiationException e) {
            this.socket.eventAcceptFailed(this.endpoint, 22);
            return;
        }
        IOThread ioThread = this.chooseIoThread(this.options.affinity);
        assert (ioThread != null);
        SessionBase session = Sockets.createSession(ioThread, false, this.socket, this.options, null);
        assert (session != null);
        session.incSeqnum();
        this.launchChild(session);
        this.sendAttach(session, engine, false);
        this.socket.eventAccepted(this.endpoint, channel);
    }

    private void close() {
        assert (this.fd != null);
        try {
            this.fd.close();
            this.socket.eventClosed(this.endpoint, this.fd);
        }
        catch (IOException e) {
            this.socket.eventCloseFailed(this.endpoint, ZError.exccode(e));
        }
        this.fd = null;
    }

    @Override
    public String getAddress() {
        return this.address(this.address);
    }

    protected String address(Address.IZAddress address) {
        int port = this.fd.socket().getLocalPort();
        return address.toString(port);
    }

    @Override
    public boolean setAddress(String addr) {
        this.address = new TcpAddress(addr, this.options.ipv6);
        return this.setAddress();
    }

    protected boolean setAddress(InetSocketAddress addr) {
        this.address = new TcpAddress(addr);
        return this.setAddress();
    }

    private boolean setAddress() {
        this.endpoint = this.address.toString();
        try {
            this.fd = this.options.selectorChooser == null ? ServerSocketChannel.open() : this.options.selectorChooser.choose(this.address, this.options).openServerSocketChannel();
            if (this.address.family() == StandardProtocolFamily.INET6) {
                TcpUtils.enableIpv4Mapping(this.fd);
            }
            TcpUtils.unblockSocket(this.fd);
            if (this.options.sndbuf != 0) {
                TcpUtils.setTcpSendBuffer(this.fd, this.options.sndbuf);
            }
            if (this.options.rcvbuf != 0) {
                TcpUtils.setTcpReceiveBuffer(this.fd, this.options.rcvbuf);
            }
            if (!isWindows) {
                TcpUtils.setReuseAddress(this.fd, true);
            }
            this.fd.socket().bind(this.address.address(), this.options.backlog);
            this.endpoint = this.getAddress();
        }
        catch (IOException e) {
            this.close();
            this.errno.set(48);
            return false;
        }
        this.socket.eventListening(this.endpoint, this.fd);
        return true;
    }

    private SocketChannel accept() throws IOException {
        assert (this.fd != null);
        SocketChannel sock = this.fd.accept();
        if (!this.options.tcpAcceptFilters.isEmpty()) {
            boolean matched = false;
            for (TcpAddress.TcpAddressMask am : this.options.tcpAcceptFilters) {
                if (!am.matchAddress(this.address.address())) continue;
                matched = true;
                break;
            }
            if (!matched) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        if (this.options.tos != 0) {
            TcpUtils.setIpTypeOfService(sock, this.options.tos);
        }
        if (this.options.sndbuf != 0) {
            TcpUtils.setTcpSendBuffer(sock, this.options.sndbuf);
        }
        if (this.options.rcvbuf != 0) {
            TcpUtils.setTcpReceiveBuffer(sock, this.options.rcvbuf);
        }
        if (!isWindows) {
            TcpUtils.setReuseAddress(sock, true);
        }
        return sock;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.options.socketId + "]";
    }

    static {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        isWindows = os.contains("win");
    }
}

