/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.transactions.metadata.ImmutableMetaLedgerEntryType;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaAccountRootObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaAmmObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaBridgeObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaCheckObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaDepositPreAuthObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaDidObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaEscrowObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaNfTokenOfferObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaNfTokenPageObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaOfferObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaPayChannelObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaRippleStateObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaSignerListObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaTicketObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaUnknownObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaXChainOwnedClaimIdObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaXChainOwnedCreateAccountClaimIdObject;

@JsonSerialize(as=ImmutableMetaLedgerEntryType.class)
@JsonDeserialize(as=ImmutableMetaLedgerEntryType.class)
@Value.Immutable
public interface MetaLedgerEntryType {
    public static final MetaLedgerEntryType ACCOUNT_ROOT = MetaLedgerEntryType.of("AccountRoot");
    public static final MetaLedgerEntryType AMENDMENTS = MetaLedgerEntryType.of("Amendments");
    public static final MetaLedgerEntryType CHECK = MetaLedgerEntryType.of("Check");
    public static final MetaLedgerEntryType DEPOSIT_PRE_AUTH = MetaLedgerEntryType.of("DepositPreauth");
    public static final MetaLedgerEntryType DIRECTORY_NODE = MetaLedgerEntryType.of("DirectoryNode");
    public static final MetaLedgerEntryType ESCROW = MetaLedgerEntryType.of("Escrow");
    public static final MetaLedgerEntryType FEE_SETTINGS = MetaLedgerEntryType.of("FeeSettings");
    public static final MetaLedgerEntryType LEDGER_HASHES = MetaLedgerEntryType.of("LedgerHashes");
    public static final MetaLedgerEntryType NEGATIVE_UNL = MetaLedgerEntryType.of("NegativeUNL");
    public static final MetaLedgerEntryType NFTOKEN_OFFER = MetaLedgerEntryType.of("NFTokenOffer");
    public static final MetaLedgerEntryType OFFER = MetaLedgerEntryType.of("Offer");
    public static final MetaLedgerEntryType PAY_CHANNEL = MetaLedgerEntryType.of("PayChannel");
    public static final MetaLedgerEntryType RIPPLE_STATE = MetaLedgerEntryType.of("RippleState");
    public static final MetaLedgerEntryType SIGNER_LIST = MetaLedgerEntryType.of("SignerList");
    public static final MetaLedgerEntryType TICKET = MetaLedgerEntryType.of("Ticket");
    public static final MetaLedgerEntryType NFTOKEN_PAGE = MetaLedgerEntryType.of("NFTokenPage");
    public static final MetaLedgerEntryType AMM = MetaLedgerEntryType.of("AMM");
    @Beta
    public static final MetaLedgerEntryType BRIDGE = MetaLedgerEntryType.of("Bridge");
    @Beta
    public static final MetaLedgerEntryType XCHAIN_OWNED_CREATE_ACCOUNT_CLAIM_ID = MetaLedgerEntryType.of("XChainOwnedCreateAccountClaimID");
    @Beta
    public static final MetaLedgerEntryType XCHAIN_OWNED_CLAIM_ID = MetaLedgerEntryType.of("XChainOwnedClaimID");
    @Beta
    public static final MetaLedgerEntryType DID = MetaLedgerEntryType.of("DID");

    public static MetaLedgerEntryType of(String value) {
        return ImmutableMetaLedgerEntryType.builder().value(value).build();
    }

    @JsonIgnore
    @Value.Derived
    default public Class<? extends MetaLedgerObject> ledgerObjectType() {
        switch (this.value()) {
            case "AccountRoot": {
                return MetaAccountRootObject.class;
            }
            case "Check": {
                return MetaCheckObject.class;
            }
            case "DepositPreauth": {
                return MetaDepositPreAuthObject.class;
            }
            case "Escrow": {
                return MetaEscrowObject.class;
            }
            case "NFTokenOffer": {
                return MetaNfTokenOfferObject.class;
            }
            case "Offer": {
                return MetaOfferObject.class;
            }
            case "PayChannel": {
                return MetaPayChannelObject.class;
            }
            case "RippleState": {
                return MetaRippleStateObject.class;
            }
            case "SignerList": {
                return MetaSignerListObject.class;
            }
            case "Ticket": {
                return MetaTicketObject.class;
            }
            case "NFTokenPage": {
                return MetaNfTokenPageObject.class;
            }
            case "AMM": {
                return MetaAmmObject.class;
            }
            case "Bridge": {
                return MetaBridgeObject.class;
            }
            case "XChainOwnedClaimID": {
                return MetaXChainOwnedClaimIdObject.class;
            }
            case "XChainOwnedCreateAccountClaimID": {
                return MetaXChainOwnedCreateAccountClaimIdObject.class;
            }
            case "DID": {
                return MetaDidObject.class;
            }
        }
        return MetaUnknownObject.class;
    }

    public String value();
}

