/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.ripple.cryptoconditions.Condition;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.metadata.ImmutableMetaEscrowObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerObject;

@JsonSerialize(as=ImmutableMetaEscrowObject.class)
@JsonDeserialize(as=ImmutableMetaEscrowObject.class)
@Value.Immutable
public interface MetaEscrowObject
extends MetaLedgerObject {
    @JsonProperty(value="Account")
    public Optional<Address> account();

    @JsonProperty(value="Destination")
    public Optional<Address> destination();

    @JsonProperty(value="Amount")
    public Optional<XrpCurrencyAmount> amount();

    @JsonProperty(value="Condition")
    public Optional<Condition> condition();

    @JsonProperty(value="CancelAfter")
    public Optional<UnsignedLong> cancelAfter();

    @JsonProperty(value="FinishAfter")
    public Optional<UnsignedLong> finishAfter();

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags flags() {
        return Flags.UNSET;
    }

    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag();

    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag();

    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode();

    @JsonProperty(value="DestinationNode")
    public Optional<String> destinationNode();

    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence();
}

