/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.ImmutableMetaCheckObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerObject;

@JsonSerialize(as=ImmutableMetaCheckObject.class)
@JsonDeserialize(as=ImmutableMetaCheckObject.class)
@Value.Immutable
public interface MetaCheckObject
extends MetaLedgerObject {
    @JsonProperty(value="Account")
    public Optional<Address> account();

    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag();

    @JsonProperty(value="Destination")
    public Optional<Address> destination();

    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag();

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags flags() {
        return Flags.UNSET;
    }

    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode();

    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTxnId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence();

    @JsonProperty(value="SendMax")
    public Optional<CurrencyAmount> sendMax();

    @JsonProperty(value="Sequence")
    public Optional<UnsignedInteger> sequence();

    @JsonProperty(value="DestinationNode")
    public Optional<String> destinationNode();

    @JsonProperty(value="Expiration")
    public Optional<UnsignedInteger> expiration();

    @JsonProperty(value="InvoiceID")
    public Optional<Hash256> invoiceId();
}

