/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import com.google.common.primitives.UnsignedInteger;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;
import org.xrpl.xrpl4j.model.transactions.metadata.ImmutableMetaAuctionSlot;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaAuthAccount;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaAuthAccountWrapper;

@JsonSerialize(as=ImmutableMetaAuctionSlot.class)
@JsonDeserialize(as=ImmutableMetaAuctionSlot.class)
@Value.Immutable
@Beta
public interface MetaAuctionSlot {
    @JsonProperty(value="Account")
    public Optional<Address> account();

    @JsonProperty(value="AuthAccounts")
    public List<MetaAuthAccountWrapper> authAccounts();

    @JsonIgnore
    @Value.Derived
    default public List<Address> authAccountsAddresses() {
        return this.authAccounts().stream().map(MetaAuthAccountWrapper::authAccount).map(MetaAuthAccount::account).collect(Collectors.toList());
    }

    @JsonProperty(value="DiscountedFee")
    public Optional<TradingFee> discountedFee();

    @JsonProperty(value="Price")
    public Optional<IssuedCurrencyAmount> price();

    @JsonProperty(value="Expiration")
    public Optional<UnsignedInteger> expiration();
}

