/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.Issue;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;
import org.xrpl.xrpl4j.model.transactions.metadata.ImmutableMetaAmmObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaAuctionSlot;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaVoteEntry;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaVoteEntryWrapper;

@JsonSerialize(as=ImmutableMetaAmmObject.class)
@JsonDeserialize(as=ImmutableMetaAmmObject.class)
@Value.Immutable
@Beta
public interface MetaAmmObject
extends MetaLedgerObject {
    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags flags() {
        return Flags.UNSET;
    }

    @JsonProperty(value="Asset")
    public Optional<Issue> asset();

    @JsonProperty(value="Asset2")
    public Optional<Issue> asset2();

    @JsonProperty(value="Account")
    public Optional<Address> account();

    @JsonProperty(value="AuctionSlot")
    public Optional<MetaAuctionSlot> auctionSlot();

    @JsonProperty(value="LPTokenBalance")
    public Optional<IssuedCurrencyAmount> lpTokenBalance();

    @JsonProperty(value="TradingFee")
    public Optional<TradingFee> tradingFee();

    @JsonProperty(value="VoteSlots")
    public List<MetaVoteEntryWrapper> voteSlots();

    @JsonIgnore
    @Value.Derived
    default public List<MetaVoteEntry> voteSlotsUnwrapped() {
        return this.voteSlots().stream().map(MetaVoteEntryWrapper::voteEntry).collect(Collectors.toList());
    }
}

