/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.AffectedNode;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerEntryType;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerObject;
import org.xrpl.xrpl4j.model.transactions.metadata.ModifiedNode;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ModifiedNode", generator="Immutables")
@Immutable
public final class ImmutableModifiedNode<T extends MetaLedgerObject>
implements ModifiedNode<T> {
    private final MetaLedgerEntryType ledgerEntryType;
    private final Hash256 ledgerIndex;
    @Nullable
    private final T finalFields;
    @Nullable
    private final T previousFields;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final LedgerIndex previousTransactionsLedgerSequence;

    private ImmutableModifiedNode(MetaLedgerEntryType ledgerEntryType, Hash256 ledgerIndex, @Nullable T finalFields, @Nullable T previousFields, @Nullable Hash256 previousTransactionId, @Nullable LedgerIndex previousTransactionsLedgerSequence) {
        this.ledgerEntryType = ledgerEntryType;
        this.ledgerIndex = ledgerIndex;
        this.finalFields = finalFields;
        this.previousFields = previousFields;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionsLedgerSequence = previousTransactionsLedgerSequence;
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public MetaLedgerEntryType ledgerEntryType() {
        return this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="LedgerIndex")
    public Hash256 ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="FinalFields")
    public Optional<T> finalFields() {
        return Optional.ofNullable(this.finalFields);
    }

    @Override
    @JsonProperty(value="PreviousFields")
    public Optional<T> previousFields() {
        return Optional.ofNullable(this.previousFields);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionsLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionsLedgerSequence);
    }

    public final ImmutableModifiedNode<T> withLedgerEntryType(MetaLedgerEntryType value) {
        if (this.ledgerEntryType == value) {
            return this;
        }
        MetaLedgerEntryType newValue = Objects.requireNonNull(value, "ledgerEntryType");
        return new ImmutableModifiedNode<T>(newValue, this.ledgerIndex, this.finalFields, this.previousFields, this.previousTransactionId, this.previousTransactionsLedgerSequence);
    }

    public final ImmutableModifiedNode<T> withLedgerIndex(Hash256 value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "ledgerIndex");
        return new ImmutableModifiedNode<T>(this.ledgerEntryType, newValue, this.finalFields, this.previousFields, this.previousTransactionId, this.previousTransactionsLedgerSequence);
    }

    public final ImmutableModifiedNode<T> withFinalFields(T value) {
        MetaLedgerObject newValue = (MetaLedgerObject)Objects.requireNonNull(value, "finalFields");
        if (this.finalFields == newValue) {
            return this;
        }
        return new ImmutableModifiedNode<MetaLedgerObject>(this.ledgerEntryType, this.ledgerIndex, newValue, (MetaLedgerObject)this.previousFields, this.previousTransactionId, this.previousTransactionsLedgerSequence);
    }

    public final ImmutableModifiedNode<T> withFinalFields(Optional<? extends T> optional) {
        MetaLedgerObject value = optional.orElse(null);
        if (this.finalFields == value) {
            return this;
        }
        return new ImmutableModifiedNode<MetaLedgerObject>(this.ledgerEntryType, this.ledgerIndex, value, (MetaLedgerObject)this.previousFields, this.previousTransactionId, this.previousTransactionsLedgerSequence);
    }

    public final ImmutableModifiedNode<T> withPreviousFields(T value) {
        MetaLedgerObject newValue = (MetaLedgerObject)Objects.requireNonNull(value, "previousFields");
        if (this.previousFields == newValue) {
            return this;
        }
        return new ImmutableModifiedNode<MetaLedgerObject>(this.ledgerEntryType, this.ledgerIndex, (MetaLedgerObject)this.finalFields, newValue, this.previousTransactionId, this.previousTransactionsLedgerSequence);
    }

    public final ImmutableModifiedNode<T> withPreviousFields(Optional<? extends T> optional) {
        MetaLedgerObject value = optional.orElse(null);
        if (this.previousFields == value) {
            return this;
        }
        return new ImmutableModifiedNode<MetaLedgerObject>(this.ledgerEntryType, this.ledgerIndex, (MetaLedgerObject)this.finalFields, value, this.previousTransactionId, this.previousTransactionsLedgerSequence);
    }

    public final ImmutableModifiedNode<T> withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableModifiedNode<T>(this.ledgerEntryType, this.ledgerIndex, this.finalFields, this.previousFields, newValue, this.previousTransactionsLedgerSequence);
    }

    public final ImmutableModifiedNode<T> withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableModifiedNode<T>(this.ledgerEntryType, this.ledgerIndex, this.finalFields, this.previousFields, value, this.previousTransactionsLedgerSequence);
    }

    public final ImmutableModifiedNode<T> withPreviousTransactionsLedgerSequence(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "previousTransactionsLedgerSequence");
        if (this.previousTransactionsLedgerSequence == newValue) {
            return this;
        }
        return new ImmutableModifiedNode<T>(this.ledgerEntryType, this.ledgerIndex, this.finalFields, this.previousFields, this.previousTransactionId, newValue);
    }

    public final ImmutableModifiedNode<T> withPreviousTransactionsLedgerSequence(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.previousTransactionsLedgerSequence == value) {
            return this;
        }
        return new ImmutableModifiedNode<T>(this.ledgerEntryType, this.ledgerIndex, this.finalFields, this.previousFields, this.previousTransactionId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModifiedNode && this.equalTo(0, (ImmutableModifiedNode)another);
    }

    private boolean equalTo(int synthetic, ImmutableModifiedNode<?> another) {
        return this.ledgerEntryType.equals(another.ledgerEntryType) && this.ledgerIndex.equals(another.ledgerIndex) && Objects.equals(this.finalFields, another.finalFields) && Objects.equals(this.previousFields, another.previousFields) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionsLedgerSequence, another.previousTransactionsLedgerSequence);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.ledgerIndex.hashCode();
        h += (h << 5) + Objects.hashCode(this.finalFields);
        h += (h << 5) + Objects.hashCode(this.previousFields);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionsLedgerSequence);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiedNode").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("ledgerIndex", (Object)this.ledgerIndex).add("finalFields", this.finalFields).add("previousFields", this.previousFields).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionsLedgerSequence", (Object)this.previousTransactionsLedgerSequence).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends MetaLedgerObject> ImmutableModifiedNode<T> fromJson(Json<T> json) {
        Builder builder = ImmutableModifiedNode.builder();
        if (json.ledgerEntryType != null) {
            builder.ledgerEntryType(json.ledgerEntryType);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.finalFields != null) {
            builder.finalFields(json.finalFields);
        }
        if (json.previousFields != null) {
            builder.previousFields(json.previousFields);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionsLedgerSequence != null) {
            builder.previousTransactionsLedgerSequence(json.previousTransactionsLedgerSequence);
        }
        return builder.build();
    }

    public static <T extends MetaLedgerObject> ImmutableModifiedNode<T> copyOf(ModifiedNode<T> instance) {
        if (instance instanceof ImmutableModifiedNode) {
            return (ImmutableModifiedNode)instance;
        }
        return ImmutableModifiedNode.builder().from(instance).build();
    }

    public static <T extends MetaLedgerObject> Builder<T> builder() {
        return new Builder();
    }

    /* synthetic */ ImmutableModifiedNode(MetaLedgerEntryType x0, Hash256 x1, MetaLedgerObject x2, MetaLedgerObject x3, Hash256 x4, LedgerIndex x5, 1 x6) {
        this(x0, x1, x2, x3, x4, x5);
    }

    @Generated(from="ModifiedNode", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends MetaLedgerObject> {
        private static final long INIT_BIT_LEDGER_ENTRY_TYPE = 1L;
        private static final long INIT_BIT_LEDGER_INDEX = 2L;
        private long initBits = 3L;
        @Nullable
        private MetaLedgerEntryType ledgerEntryType;
        @Nullable
        private Hash256 ledgerIndex;
        @Nullable
        private T finalFields;
        @Nullable
        private T previousFields;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private LedgerIndex previousTransactionsLedgerSequence;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(ModifiedNode<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(AffectedNode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AffectedNode instance;
            long bits = 0L;
            if (object instanceof ModifiedNode) {
                Optional<LedgerIndex> previousTransactionsLedgerSequenceOptional;
                Optional previousFieldsOptional;
                Optional<Hash256> previousTransactionIdOptional;
                Optional finalFieldsOptional;
                instance = (ModifiedNode)object;
                if ((bits & 1L) == 0L) {
                    this.ledgerEntryType(instance.ledgerEntryType());
                    bits |= 1L;
                }
                if ((finalFieldsOptional = instance.finalFields()).isPresent()) {
                    this.finalFields(finalFieldsOptional);
                }
                if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                    this.previousTransactionId(previousTransactionIdOptional);
                }
                if ((previousFieldsOptional = instance.previousFields()).isPresent()) {
                    this.previousFields(previousFieldsOptional);
                }
                if ((previousTransactionsLedgerSequenceOptional = instance.previousTransactionsLedgerSequence()).isPresent()) {
                    this.previousTransactionsLedgerSequence(previousTransactionsLedgerSequenceOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.ledgerIndex(instance.ledgerIndex());
                    bits |= 2L;
                }
            }
            if (object instanceof AffectedNode) {
                instance = (AffectedNode)object;
                if ((bits & 1L) == 0L) {
                    this.ledgerEntryType(instance.ledgerEntryType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.ledgerIndex(instance.ledgerIndex());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="LedgerEntryType")
        @CanIgnoreReturnValue
        public final Builder<T> ledgerEntryType(MetaLedgerEntryType ledgerEntryType) {
            this.ledgerEntryType = Objects.requireNonNull(ledgerEntryType, "ledgerEntryType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="LedgerIndex")
        @CanIgnoreReturnValue
        public final Builder<T> ledgerIndex(Hash256 ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> finalFields(T finalFields) {
            this.finalFields = (MetaLedgerObject)Objects.requireNonNull(finalFields, "finalFields");
            return this;
        }

        @JsonProperty(value="FinalFields")
        @CanIgnoreReturnValue
        public final Builder<T> finalFields(Optional<? extends T> finalFields) {
            this.finalFields = finalFields.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> previousFields(T previousFields) {
            this.previousFields = (MetaLedgerObject)Objects.requireNonNull(previousFields, "previousFields");
            return this;
        }

        @JsonProperty(value="PreviousFields")
        @CanIgnoreReturnValue
        public final Builder<T> previousFields(Optional<? extends T> previousFields) {
            this.previousFields = previousFields.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder<T> previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> previousTransactionsLedgerSequence(LedgerIndex previousTransactionsLedgerSequence) {
            this.previousTransactionsLedgerSequence = Objects.requireNonNull(previousTransactionsLedgerSequence, "previousTransactionsLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder<T> previousTransactionsLedgerSequence(Optional<? extends LedgerIndex> previousTransactionsLedgerSequence) {
            this.previousTransactionsLedgerSequence = previousTransactionsLedgerSequence.orElse(null);
            return this;
        }

        public ImmutableModifiedNode<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModifiedNode(this.ledgerEntryType, this.ledgerIndex, (MetaLedgerObject)this.finalFields, (MetaLedgerObject)this.previousFields, this.previousTransactionId, this.previousTransactionsLedgerSequence, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ledgerEntryType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ledgerIndex");
            }
            return "Cannot build ModifiedNode, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ModifiedNode", generator="Immutables")
    static final class Json<T extends MetaLedgerObject>
    implements ModifiedNode<T> {
        @Nullable
        MetaLedgerEntryType ledgerEntryType;
        @Nullable
        Hash256 ledgerIndex;
        @Nullable
        Optional<T> finalFields = Optional.empty();
        @Nullable
        Optional<T> previousFields = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<LedgerIndex> previousTransactionsLedgerSequence = Optional.empty();

        Json() {
        }

        @JsonProperty(value="LedgerEntryType")
        public void setLedgerEntryType(MetaLedgerEntryType ledgerEntryType) {
            this.ledgerEntryType = ledgerEntryType;
        }

        @JsonProperty(value="LedgerIndex")
        public void setLedgerIndex(Hash256 ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="FinalFields")
        public void setFinalFields(Optional<T> finalFields) {
            this.finalFields = finalFields;
        }

        @JsonProperty(value="PreviousFields")
        public void setPreviousFields(Optional<T> previousFields) {
            this.previousFields = previousFields;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionsLedgerSequence(Optional<LedgerIndex> previousTransactionsLedgerSequence) {
            this.previousTransactionsLedgerSequence = previousTransactionsLedgerSequence;
        }

        @Override
        public MetaLedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<T> finalFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<T> previousFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> previousTransactionsLedgerSequence() {
            throw new UnsupportedOperationException();
        }
    }
}

