/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;
import org.xrpl.xrpl4j.model.transactions.XChainCount;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaXChainCreateAccountAttestation;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaXChainOwnedCreateAccountClaimIdObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaXChainOwnedCreateAccountClaimIdObject", generator="Immutables")
@Immutable
public final class ImmutableMetaXChainOwnedCreateAccountClaimIdObject
implements MetaXChainOwnedCreateAccountClaimIdObject {
    private final transient Flags flags;
    @Nullable
    private final Address account;
    @Nullable
    private final XChainBridge xChainBridge;
    private final ImmutableList<MetaXChainCreateAccountAttestation> xChainCreateAccountAttestations;
    @Nullable
    private final XChainCount xChainAccountCreateCount;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final UnsignedInteger previousTransactionLedgerSequence;

    private ImmutableMetaXChainOwnedCreateAccountClaimIdObject(@Nullable Address account, @Nullable XChainBridge xChainBridge, ImmutableList<MetaXChainCreateAccountAttestation> xChainCreateAccountAttestations, @Nullable XChainCount xChainAccountCreateCount, @Nullable String ownerNode, @Nullable Hash256 previousTransactionId, @Nullable UnsignedInteger previousTransactionLedgerSequence) {
        this.account = account;
        this.xChainBridge = xChainBridge;
        this.xChainCreateAccountAttestations = xChainCreateAccountAttestations;
        this.xChainAccountCreateCount = xChainAccountCreateCount;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.flags = Objects.requireNonNull(MetaXChainOwnedCreateAccountClaimIdObject.super.flags(), "flags");
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="XChainBridge")
    public Optional<XChainBridge> xChainBridge() {
        return Optional.ofNullable(this.xChainBridge);
    }

    @JsonProperty(value="XChainCreateAccountAttestations")
    public ImmutableList<MetaXChainCreateAccountAttestation> xChainCreateAccountAttestations() {
        return this.xChainCreateAccountAttestations;
    }

    @Override
    @JsonProperty(value="XChainAccountCreateCount")
    public Optional<XChainCount> xChainAccountCreateCount() {
        return Optional.ofNullable(this.xChainAccountCreateCount);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<UnsignedInteger> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(newValue, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(value, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withXChainBridge(XChainBridge value) {
        XChainBridge newValue = Objects.requireNonNull(value, "xChainBridge");
        if (this.xChainBridge == newValue) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, newValue, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withXChainBridge(Optional<? extends XChainBridge> optional) {
        XChainBridge value = optional.orElse(null);
        if (this.xChainBridge == value) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, value, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withXChainCreateAccountAttestations(MetaXChainCreateAccountAttestation ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, (ImmutableList<MetaXChainCreateAccountAttestation>)newValue, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withXChainCreateAccountAttestations(Iterable<? extends MetaXChainCreateAccountAttestation> elements) {
        if (this.xChainCreateAccountAttestations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, (ImmutableList<MetaXChainCreateAccountAttestation>)newValue, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withXChainAccountCreateCount(XChainCount value) {
        XChainCount newValue = Objects.requireNonNull(value, "xChainAccountCreateCount");
        if (this.xChainAccountCreateCount == newValue) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withXChainAccountCreateCount(Optional<? extends XChainCount> optional) {
        XChainCount value = optional.orElse(null);
        if (this.xChainAccountCreateCount == value) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, value, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, value, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, newValue, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, value, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (Objects.equals(this.previousTransactionLedgerSequence, newValue)) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, newValue);
    }

    public final ImmutableMetaXChainOwnedCreateAccountClaimIdObject withPreviousTransactionLedgerSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.previousTransactionLedgerSequence, value)) {
            return this;
        }
        return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaXChainOwnedCreateAccountClaimIdObject && this.equalTo(0, (ImmutableMetaXChainOwnedCreateAccountClaimIdObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaXChainOwnedCreateAccountClaimIdObject another) {
        return this.flags.equals(another.flags) && Objects.equals(this.account, another.account) && Objects.equals(this.xChainBridge, another.xChainBridge) && this.xChainCreateAccountAttestations.equals(another.xChainCreateAccountAttestations) && Objects.equals(this.xChainAccountCreateCount, another.xChainAccountCreateCount) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.xChainBridge);
        h += (h << 5) + this.xChainCreateAccountAttestations.hashCode();
        h += (h << 5) + Objects.hashCode(this.xChainAccountCreateCount);
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaXChainOwnedCreateAccountClaimIdObject").omitNullValues().add("flags", (Object)this.flags).add("account", (Object)this.account).add("xChainBridge", (Object)this.xChainBridge).add("xChainCreateAccountAttestations", this.xChainCreateAccountAttestations).add("xChainAccountCreateCount", (Object)this.xChainAccountCreateCount).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaXChainOwnedCreateAccountClaimIdObject fromJson(Json json) {
        Builder builder = ImmutableMetaXChainOwnedCreateAccountClaimIdObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.xChainBridge != null) {
            builder.xChainBridge(json.xChainBridge);
        }
        if (json.xChainCreateAccountAttestations != null) {
            builder.addAllXChainCreateAccountAttestations(json.xChainCreateAccountAttestations);
        }
        if (json.xChainAccountCreateCount != null) {
            builder.xChainAccountCreateCount(json.xChainAccountCreateCount);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        return builder.build();
    }

    public static ImmutableMetaXChainOwnedCreateAccountClaimIdObject copyOf(MetaXChainOwnedCreateAccountClaimIdObject instance) {
        if (instance instanceof ImmutableMetaXChainOwnedCreateAccountClaimIdObject) {
            return (ImmutableMetaXChainOwnedCreateAccountClaimIdObject)instance;
        }
        return ImmutableMetaXChainOwnedCreateAccountClaimIdObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaXChainOwnedCreateAccountClaimIdObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private XChainBridge xChainBridge;
        private ImmutableList.Builder<MetaXChainCreateAccountAttestation> xChainCreateAccountAttestations = ImmutableList.builder();
        @Nullable
        private XChainCount xChainAccountCreateCount;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaXChainOwnedCreateAccountClaimIdObject instance) {
            Optional<UnsignedInteger> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<String> ownerNodeOptional;
            Optional<XChainBridge> xChainBridgeOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((xChainBridgeOptional = instance.xChainBridge()).isPresent()) {
                this.xChainBridge(xChainBridgeOptional);
            }
            this.addAllXChainCreateAccountAttestations(instance.xChainCreateAccountAttestations());
            Optional<XChainCount> xChainAccountCreateCountOptional = instance.xChainAccountCreateCount();
            if (xChainAccountCreateCountOptional.isPresent()) {
                this.xChainAccountCreateCount(xChainAccountCreateCountOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = Objects.requireNonNull(xChainBridge, "xChainBridge");
            return this;
        }

        @JsonProperty(value="XChainBridge")
        @CanIgnoreReturnValue
        public final Builder xChainBridge(Optional<? extends XChainBridge> xChainBridge) {
            this.xChainBridge = xChainBridge.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXChainCreateAccountAttestations(MetaXChainCreateAccountAttestation element) {
            this.xChainCreateAccountAttestations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXChainCreateAccountAttestations(MetaXChainCreateAccountAttestation ... elements) {
            this.xChainCreateAccountAttestations.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="XChainCreateAccountAttestations")
        @CanIgnoreReturnValue
        public final Builder xChainCreateAccountAttestations(Iterable<? extends MetaXChainCreateAccountAttestation> elements) {
            this.xChainCreateAccountAttestations = ImmutableList.builder();
            return this.addAllXChainCreateAccountAttestations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllXChainCreateAccountAttestations(Iterable<? extends MetaXChainCreateAccountAttestation> elements) {
            this.xChainCreateAccountAttestations.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xChainAccountCreateCount(XChainCount xChainAccountCreateCount) {
            this.xChainAccountCreateCount = Objects.requireNonNull(xChainAccountCreateCount, "xChainAccountCreateCount");
            return this;
        }

        @JsonProperty(value="XChainAccountCreateCount")
        @CanIgnoreReturnValue
        public final Builder xChainAccountCreateCount(Optional<? extends XChainCount> xChainAccountCreateCount) {
            this.xChainAccountCreateCount = xChainAccountCreateCount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends UnsignedInteger> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        public ImmutableMetaXChainOwnedCreateAccountClaimIdObject build() {
            return new ImmutableMetaXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations.build(), this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaXChainOwnedCreateAccountClaimIdObject", generator="Immutables")
    static final class Json
    implements MetaXChainOwnedCreateAccountClaimIdObject {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<XChainBridge> xChainBridge = Optional.empty();
        @Nullable
        List<MetaXChainCreateAccountAttestation> xChainCreateAccountAttestations = ImmutableList.of();
        @Nullable
        Optional<XChainCount> xChainAccountCreateCount = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> previousTransactionLedgerSequence = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="XChainBridge")
        public void setXChainBridge(Optional<XChainBridge> xChainBridge) {
            this.xChainBridge = xChainBridge;
        }

        @JsonProperty(value="XChainCreateAccountAttestations")
        public void setXChainCreateAccountAttestations(List<MetaXChainCreateAccountAttestation> xChainCreateAccountAttestations) {
            this.xChainCreateAccountAttestations = xChainCreateAccountAttestations;
        }

        @JsonProperty(value="XChainAccountCreateCount")
        public void setXChainAccountCreateCount(Optional<XChainCount> xChainAccountCreateCount) {
            this.xChainAccountCreateCount = xChainAccountCreateCount;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<UnsignedInteger> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XChainBridge> xChainBridge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MetaXChainCreateAccountAttestation> xChainCreateAccountAttestations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XChainCount> xChainAccountCreateCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }
    }
}

