/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;
import org.xrpl.xrpl4j.model.transactions.XChainClaimId;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaXChainClaimAttestation;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaXChainOwnedClaimIdObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaXChainOwnedClaimIdObject", generator="Immutables")
@Immutable
public final class ImmutableMetaXChainOwnedClaimIdObject
implements MetaXChainOwnedClaimIdObject {
    private final transient Flags flags;
    @Nullable
    private final Address account;
    @Nullable
    private final XChainBridge xChainBridge;
    @Nullable
    private final XChainClaimId xChainClaimId;
    @Nullable
    private final Address otherChainSource;
    private final ImmutableList<MetaXChainClaimAttestation> xChainClaimAttestations;
    @Nullable
    private final XrpCurrencyAmount signatureReward;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final UnsignedInteger previousTransactionLedgerSequence;

    private ImmutableMetaXChainOwnedClaimIdObject(@Nullable Address account, @Nullable XChainBridge xChainBridge, @Nullable XChainClaimId xChainClaimId, @Nullable Address otherChainSource, ImmutableList<MetaXChainClaimAttestation> xChainClaimAttestations, @Nullable XrpCurrencyAmount signatureReward, @Nullable String ownerNode, @Nullable Hash256 previousTransactionId, @Nullable UnsignedInteger previousTransactionLedgerSequence) {
        this.account = account;
        this.xChainBridge = xChainBridge;
        this.xChainClaimId = xChainClaimId;
        this.otherChainSource = otherChainSource;
        this.xChainClaimAttestations = xChainClaimAttestations;
        this.signatureReward = signatureReward;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.flags = Objects.requireNonNull(MetaXChainOwnedClaimIdObject.super.flags(), "flags");
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="XChainBridge")
    public Optional<XChainBridge> xChainBridge() {
        return Optional.ofNullable(this.xChainBridge);
    }

    @Override
    @JsonProperty(value="XChainClaimID")
    public Optional<XChainClaimId> xChainClaimId() {
        return Optional.ofNullable(this.xChainClaimId);
    }

    @Override
    @JsonProperty(value="OtherChainSource")
    public Optional<Address> otherChainSource() {
        return Optional.ofNullable(this.otherChainSource);
    }

    @JsonProperty(value="XChainClaimAttestations")
    public ImmutableList<MetaXChainClaimAttestation> xChainClaimAttestations() {
        return this.xChainClaimAttestations;
    }

    @Override
    @JsonProperty(value="SignatureReward")
    public Optional<XrpCurrencyAmount> signatureReward() {
        return Optional.ofNullable(this.signatureReward);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<UnsignedInteger> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(newValue, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(value, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withXChainBridge(XChainBridge value) {
        XChainBridge newValue = Objects.requireNonNull(value, "xChainBridge");
        if (this.xChainBridge == newValue) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, newValue, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withXChainBridge(Optional<? extends XChainBridge> optional) {
        XChainBridge value = optional.orElse(null);
        if (this.xChainBridge == value) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, value, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withXChainClaimId(XChainClaimId value) {
        XChainClaimId newValue = Objects.requireNonNull(value, "xChainClaimId");
        if (this.xChainClaimId == newValue) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, newValue, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withXChainClaimId(Optional<? extends XChainClaimId> optional) {
        XChainClaimId value = optional.orElse(null);
        if (this.xChainClaimId == value) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, value, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withOtherChainSource(Address value) {
        Address newValue = Objects.requireNonNull(value, "otherChainSource");
        if (this.otherChainSource == newValue) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, newValue, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withOtherChainSource(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.otherChainSource == value) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, value, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withXChainClaimAttestations(MetaXChainClaimAttestation ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, (ImmutableList<MetaXChainClaimAttestation>)newValue, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withXChainClaimAttestations(Iterable<? extends MetaXChainClaimAttestation> elements) {
        if (this.xChainClaimAttestations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, (ImmutableList<MetaXChainClaimAttestation>)newValue, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withSignatureReward(XrpCurrencyAmount value) {
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "signatureReward");
        if (this.signatureReward == newValue) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withSignatureReward(Optional<? extends XrpCurrencyAmount> optional) {
        XrpCurrencyAmount value = optional.orElse(null);
        if (this.signatureReward == value) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, value, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, value, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, newValue, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, value, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (Objects.equals(this.previousTransactionLedgerSequence, newValue)) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, newValue);
    }

    public final ImmutableMetaXChainOwnedClaimIdObject withPreviousTransactionLedgerSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.previousTransactionLedgerSequence, value)) {
            return this;
        }
        return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaXChainOwnedClaimIdObject && this.equalTo(0, (ImmutableMetaXChainOwnedClaimIdObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaXChainOwnedClaimIdObject another) {
        return this.flags.equals(another.flags) && Objects.equals(this.account, another.account) && Objects.equals(this.xChainBridge, another.xChainBridge) && Objects.equals(this.xChainClaimId, another.xChainClaimId) && Objects.equals(this.otherChainSource, another.otherChainSource) && this.xChainClaimAttestations.equals(another.xChainClaimAttestations) && Objects.equals(this.signatureReward, another.signatureReward) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.xChainBridge);
        h += (h << 5) + Objects.hashCode(this.xChainClaimId);
        h += (h << 5) + Objects.hashCode(this.otherChainSource);
        h += (h << 5) + this.xChainClaimAttestations.hashCode();
        h += (h << 5) + Objects.hashCode(this.signatureReward);
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaXChainOwnedClaimIdObject").omitNullValues().add("flags", (Object)this.flags).add("account", (Object)this.account).add("xChainBridge", (Object)this.xChainBridge).add("xChainClaimId", (Object)this.xChainClaimId).add("otherChainSource", (Object)this.otherChainSource).add("xChainClaimAttestations", this.xChainClaimAttestations).add("signatureReward", (Object)this.signatureReward).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaXChainOwnedClaimIdObject fromJson(Json json) {
        Builder builder = ImmutableMetaXChainOwnedClaimIdObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.xChainBridge != null) {
            builder.xChainBridge(json.xChainBridge);
        }
        if (json.xChainClaimId != null) {
            builder.xChainClaimId(json.xChainClaimId);
        }
        if (json.otherChainSource != null) {
            builder.otherChainSource(json.otherChainSource);
        }
        if (json.xChainClaimAttestations != null) {
            builder.addAllXChainClaimAttestations(json.xChainClaimAttestations);
        }
        if (json.signatureReward != null) {
            builder.signatureReward(json.signatureReward);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        return builder.build();
    }

    public static ImmutableMetaXChainOwnedClaimIdObject copyOf(MetaXChainOwnedClaimIdObject instance) {
        if (instance instanceof ImmutableMetaXChainOwnedClaimIdObject) {
            return (ImmutableMetaXChainOwnedClaimIdObject)instance;
        }
        return ImmutableMetaXChainOwnedClaimIdObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaXChainOwnedClaimIdObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private XChainBridge xChainBridge;
        @Nullable
        private XChainClaimId xChainClaimId;
        @Nullable
        private Address otherChainSource;
        private ImmutableList.Builder<MetaXChainClaimAttestation> xChainClaimAttestations = ImmutableList.builder();
        @Nullable
        private XrpCurrencyAmount signatureReward;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaXChainOwnedClaimIdObject instance) {
            Optional<UnsignedInteger> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<String> ownerNodeOptional;
            Optional<Address> otherChainSourceOptional;
            Optional<XChainClaimId> xChainClaimIdOptional;
            Optional<XChainBridge> xChainBridgeOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((xChainBridgeOptional = instance.xChainBridge()).isPresent()) {
                this.xChainBridge(xChainBridgeOptional);
            }
            if ((xChainClaimIdOptional = instance.xChainClaimId()).isPresent()) {
                this.xChainClaimId(xChainClaimIdOptional);
            }
            if ((otherChainSourceOptional = instance.otherChainSource()).isPresent()) {
                this.otherChainSource(otherChainSourceOptional);
            }
            this.addAllXChainClaimAttestations(instance.xChainClaimAttestations());
            Optional<XrpCurrencyAmount> signatureRewardOptional = instance.signatureReward();
            if (signatureRewardOptional.isPresent()) {
                this.signatureReward(signatureRewardOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = Objects.requireNonNull(xChainBridge, "xChainBridge");
            return this;
        }

        @JsonProperty(value="XChainBridge")
        @CanIgnoreReturnValue
        public final Builder xChainBridge(Optional<? extends XChainBridge> xChainBridge) {
            this.xChainBridge = xChainBridge.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xChainClaimId(XChainClaimId xChainClaimId) {
            this.xChainClaimId = Objects.requireNonNull(xChainClaimId, "xChainClaimId");
            return this;
        }

        @JsonProperty(value="XChainClaimID")
        @CanIgnoreReturnValue
        public final Builder xChainClaimId(Optional<? extends XChainClaimId> xChainClaimId) {
            this.xChainClaimId = xChainClaimId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder otherChainSource(Address otherChainSource) {
            this.otherChainSource = Objects.requireNonNull(otherChainSource, "otherChainSource");
            return this;
        }

        @JsonProperty(value="OtherChainSource")
        @CanIgnoreReturnValue
        public final Builder otherChainSource(Optional<? extends Address> otherChainSource) {
            this.otherChainSource = otherChainSource.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXChainClaimAttestations(MetaXChainClaimAttestation element) {
            this.xChainClaimAttestations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXChainClaimAttestations(MetaXChainClaimAttestation ... elements) {
            this.xChainClaimAttestations.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="XChainClaimAttestations")
        @CanIgnoreReturnValue
        public final Builder xChainClaimAttestations(Iterable<? extends MetaXChainClaimAttestation> elements) {
            this.xChainClaimAttestations = ImmutableList.builder();
            return this.addAllXChainClaimAttestations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllXChainClaimAttestations(Iterable<? extends MetaXChainClaimAttestation> elements) {
            this.xChainClaimAttestations.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = Objects.requireNonNull(signatureReward, "signatureReward");
            return this;
        }

        @JsonProperty(value="SignatureReward")
        @CanIgnoreReturnValue
        public final Builder signatureReward(Optional<? extends XrpCurrencyAmount> signatureReward) {
            this.signatureReward = signatureReward.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends UnsignedInteger> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        public ImmutableMetaXChainOwnedClaimIdObject build() {
            return new ImmutableMetaXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations.build(), this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaXChainOwnedClaimIdObject", generator="Immutables")
    static final class Json
    implements MetaXChainOwnedClaimIdObject {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<XChainBridge> xChainBridge = Optional.empty();
        @Nullable
        Optional<XChainClaimId> xChainClaimId = Optional.empty();
        @Nullable
        Optional<Address> otherChainSource = Optional.empty();
        @Nullable
        List<MetaXChainClaimAttestation> xChainClaimAttestations = ImmutableList.of();
        @Nullable
        Optional<XrpCurrencyAmount> signatureReward = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> previousTransactionLedgerSequence = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="XChainBridge")
        public void setXChainBridge(Optional<XChainBridge> xChainBridge) {
            this.xChainBridge = xChainBridge;
        }

        @JsonProperty(value="XChainClaimID")
        public void setXChainClaimId(Optional<XChainClaimId> xChainClaimId) {
            this.xChainClaimId = xChainClaimId;
        }

        @JsonProperty(value="OtherChainSource")
        public void setOtherChainSource(Optional<Address> otherChainSource) {
            this.otherChainSource = otherChainSource;
        }

        @JsonProperty(value="XChainClaimAttestations")
        public void setXChainClaimAttestations(List<MetaXChainClaimAttestation> xChainClaimAttestations) {
            this.xChainClaimAttestations = xChainClaimAttestations;
        }

        @JsonProperty(value="SignatureReward")
        public void setSignatureReward(Optional<XrpCurrencyAmount> signatureReward) {
            this.signatureReward = signatureReward;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<UnsignedInteger> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XChainBridge> xChainBridge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XChainClaimId> xChainClaimId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> otherChainSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MetaXChainClaimAttestation> xChainClaimAttestations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XrpCurrencyAmount> signatureReward() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }
    }
}

