/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaXChainCreateAccountProofSig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaXChainCreateAccountProofSig", generator="Immutables")
@Immutable
public final class ImmutableMetaXChainCreateAccountProofSig
implements MetaXChainCreateAccountProofSig {
    @Nullable
    private final CurrencyAmount amount;
    @Nullable
    private final XrpCurrencyAmount signatureReward;
    @Nullable
    private final Address attestationRewardAccount;
    @Nullable
    private final Address attestationSignerAccount;
    @Nullable
    private final Address destination;
    @Nullable
    private final PublicKey publicKey;
    @Nullable
    private final Boolean wasLockingChainSend;

    private ImmutableMetaXChainCreateAccountProofSig(@Nullable CurrencyAmount amount, @Nullable XrpCurrencyAmount signatureReward, @Nullable Address attestationRewardAccount, @Nullable Address attestationSignerAccount, @Nullable Address destination, @Nullable PublicKey publicKey, @Nullable Boolean wasLockingChainSend) {
        this.amount = amount;
        this.signatureReward = signatureReward;
        this.attestationRewardAccount = attestationRewardAccount;
        this.attestationSignerAccount = attestationSignerAccount;
        this.destination = destination;
        this.publicKey = publicKey;
        this.wasLockingChainSend = wasLockingChainSend;
    }

    @Override
    @JsonProperty(value="Amount")
    public Optional<CurrencyAmount> amount() {
        return Optional.ofNullable(this.amount);
    }

    @Override
    @JsonProperty(value="SignatureReward")
    public Optional<XrpCurrencyAmount> signatureReward() {
        return Optional.ofNullable(this.signatureReward);
    }

    @Override
    @JsonProperty(value="AttestationRewardAccount")
    public Optional<Address> attestationRewardAccount() {
        return Optional.ofNullable(this.attestationRewardAccount);
    }

    @Override
    @JsonProperty(value="AttestationSignerAccount")
    public Optional<Address> attestationSignerAccount() {
        return Optional.ofNullable(this.attestationSignerAccount);
    }

    @Override
    @JsonProperty(value="Destination")
    public Optional<Address> destination() {
        return Optional.ofNullable(this.destination);
    }

    @Override
    @JsonProperty(value="PublicKey")
    public Optional<PublicKey> publicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    @Override
    @JsonProperty(value="WasLockingChainSend")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    public Optional<Boolean> wasLockingChainSend() {
        return Optional.ofNullable(this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withAmount(CurrencyAmount value) {
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        if (this.amount == newValue) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(newValue, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withAmount(Optional<? extends CurrencyAmount> optional) {
        CurrencyAmount value = optional.orElse(null);
        if (this.amount == value) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(value, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withSignatureReward(XrpCurrencyAmount value) {
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "signatureReward");
        if (this.signatureReward == newValue) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, newValue, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withSignatureReward(Optional<? extends XrpCurrencyAmount> optional) {
        XrpCurrencyAmount value = optional.orElse(null);
        if (this.signatureReward == value) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, value, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withAttestationRewardAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "attestationRewardAccount");
        if (this.attestationRewardAccount == newValue) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, newValue, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withAttestationRewardAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.attestationRewardAccount == value) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, value, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withAttestationSignerAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "attestationSignerAccount");
        if (this.attestationSignerAccount == newValue) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, newValue, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withAttestationSignerAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.attestationSignerAccount == value) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, value, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withDestination(Address value) {
        Address newValue = Objects.requireNonNull(value, "destination");
        if (this.destination == newValue) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, newValue, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withDestination(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.destination == value) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, value, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withPublicKey(PublicKey value) {
        PublicKey newValue = Objects.requireNonNull(value, "publicKey");
        if (this.publicKey == newValue) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, newValue, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withPublicKey(Optional<? extends PublicKey> optional) {
        PublicKey value = optional.orElse(null);
        if (this.publicKey == value) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, value, this.wasLockingChainSend);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withWasLockingChainSend(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.wasLockingChainSend, newValue)) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, newValue);
    }

    public final ImmutableMetaXChainCreateAccountProofSig withWasLockingChainSend(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.wasLockingChainSend, value)) {
            return this;
        }
        return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaXChainCreateAccountProofSig && this.equalTo(0, (ImmutableMetaXChainCreateAccountProofSig)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaXChainCreateAccountProofSig another) {
        return Objects.equals(this.amount, another.amount) && Objects.equals(this.signatureReward, another.signatureReward) && Objects.equals(this.attestationRewardAccount, another.attestationRewardAccount) && Objects.equals(this.attestationSignerAccount, another.attestationSignerAccount) && Objects.equals(this.destination, another.destination) && Objects.equals(this.publicKey, another.publicKey) && Objects.equals(this.wasLockingChainSend, another.wasLockingChainSend);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.amount);
        h += (h << 5) + Objects.hashCode(this.signatureReward);
        h += (h << 5) + Objects.hashCode(this.attestationRewardAccount);
        h += (h << 5) + Objects.hashCode(this.attestationSignerAccount);
        h += (h << 5) + Objects.hashCode(this.destination);
        h += (h << 5) + Objects.hashCode(this.publicKey);
        h += (h << 5) + Objects.hashCode(this.wasLockingChainSend);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaXChainCreateAccountProofSig").omitNullValues().add("amount", (Object)this.amount).add("signatureReward", (Object)this.signatureReward).add("attestationRewardAccount", (Object)this.attestationRewardAccount).add("attestationSignerAccount", (Object)this.attestationSignerAccount).add("destination", (Object)this.destination).add("publicKey", (Object)this.publicKey).add("wasLockingChainSend", (Object)this.wasLockingChainSend).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaXChainCreateAccountProofSig fromJson(Json json) {
        Builder builder = ImmutableMetaXChainCreateAccountProofSig.builder();
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.signatureReward != null) {
            builder.signatureReward(json.signatureReward);
        }
        if (json.attestationRewardAccount != null) {
            builder.attestationRewardAccount(json.attestationRewardAccount);
        }
        if (json.attestationSignerAccount != null) {
            builder.attestationSignerAccount(json.attestationSignerAccount);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.publicKey != null) {
            builder.publicKey(json.publicKey);
        }
        if (json.wasLockingChainSend != null) {
            builder.wasLockingChainSend(json.wasLockingChainSend);
        }
        return builder.build();
    }

    public static ImmutableMetaXChainCreateAccountProofSig copyOf(MetaXChainCreateAccountProofSig instance) {
        if (instance instanceof ImmutableMetaXChainCreateAccountProofSig) {
            return (ImmutableMetaXChainCreateAccountProofSig)instance;
        }
        return ImmutableMetaXChainCreateAccountProofSig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaXChainCreateAccountProofSig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private CurrencyAmount amount;
        @Nullable
        private XrpCurrencyAmount signatureReward;
        @Nullable
        private Address attestationRewardAccount;
        @Nullable
        private Address attestationSignerAccount;
        @Nullable
        private Address destination;
        @Nullable
        private PublicKey publicKey;
        @Nullable
        private Boolean wasLockingChainSend;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaXChainCreateAccountProofSig instance) {
            Optional<Boolean> wasLockingChainSendOptional;
            Optional<PublicKey> publicKeyOptional;
            Optional<Address> destinationOptional;
            Optional<Address> attestationSignerAccountOptional;
            Optional<Address> attestationRewardAccountOptional;
            Optional<XrpCurrencyAmount> signatureRewardOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<CurrencyAmount> amountOptional = instance.amount();
            if (amountOptional.isPresent()) {
                this.amount(amountOptional);
            }
            if ((signatureRewardOptional = instance.signatureReward()).isPresent()) {
                this.signatureReward(signatureRewardOptional);
            }
            if ((attestationRewardAccountOptional = instance.attestationRewardAccount()).isPresent()) {
                this.attestationRewardAccount(attestationRewardAccountOptional);
            }
            if ((attestationSignerAccountOptional = instance.attestationSignerAccount()).isPresent()) {
                this.attestationSignerAccount(attestationSignerAccountOptional);
            }
            if ((destinationOptional = instance.destination()).isPresent()) {
                this.destination(destinationOptional);
            }
            if ((publicKeyOptional = instance.publicKey()).isPresent()) {
                this.publicKey(publicKeyOptional);
            }
            if ((wasLockingChainSendOptional = instance.wasLockingChainSend()).isPresent()) {
                this.wasLockingChainSend(wasLockingChainSendOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder amount(CurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(Optional<? extends CurrencyAmount> amount) {
            this.amount = amount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = Objects.requireNonNull(signatureReward, "signatureReward");
            return this;
        }

        @JsonProperty(value="SignatureReward")
        @CanIgnoreReturnValue
        public final Builder signatureReward(Optional<? extends XrpCurrencyAmount> signatureReward) {
            this.signatureReward = signatureReward.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attestationRewardAccount(Address attestationRewardAccount) {
            this.attestationRewardAccount = Objects.requireNonNull(attestationRewardAccount, "attestationRewardAccount");
            return this;
        }

        @JsonProperty(value="AttestationRewardAccount")
        @CanIgnoreReturnValue
        public final Builder attestationRewardAccount(Optional<? extends Address> attestationRewardAccount) {
            this.attestationRewardAccount = attestationRewardAccount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attestationSignerAccount(Address attestationSignerAccount) {
            this.attestationSignerAccount = Objects.requireNonNull(attestationSignerAccount, "attestationSignerAccount");
            return this;
        }

        @JsonProperty(value="AttestationSignerAccount")
        @CanIgnoreReturnValue
        public final Builder attestationSignerAccount(Optional<? extends Address> attestationSignerAccount) {
            this.attestationSignerAccount = attestationSignerAccount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Optional<? extends Address> destination) {
            this.destination = destination.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKey(PublicKey publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            return this;
        }

        @JsonProperty(value="PublicKey")
        @CanIgnoreReturnValue
        public final Builder publicKey(Optional<? extends PublicKey> publicKey) {
            this.publicKey = publicKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wasLockingChainSend(boolean wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
            return this;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        @CanIgnoreReturnValue
        public final Builder wasLockingChainSend(Optional<Boolean> wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend.orElse(null);
            return this;
        }

        public ImmutableMetaXChainCreateAccountProofSig build() {
            return new ImmutableMetaXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaXChainCreateAccountProofSig", generator="Immutables")
    static final class Json
    implements MetaXChainCreateAccountProofSig {
        @Nullable
        Optional<CurrencyAmount> amount = Optional.empty();
        @Nullable
        Optional<XrpCurrencyAmount> signatureReward = Optional.empty();
        @Nullable
        Optional<Address> attestationRewardAccount = Optional.empty();
        @Nullable
        Optional<Address> attestationSignerAccount = Optional.empty();
        @Nullable
        Optional<Address> destination = Optional.empty();
        @Nullable
        Optional<PublicKey> publicKey = Optional.empty();
        @Nullable
        Optional<Boolean> wasLockingChainSend = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Amount")
        public void setAmount(Optional<CurrencyAmount> amount) {
            this.amount = amount;
        }

        @JsonProperty(value="SignatureReward")
        public void setSignatureReward(Optional<XrpCurrencyAmount> signatureReward) {
            this.signatureReward = signatureReward;
        }

        @JsonProperty(value="AttestationRewardAccount")
        public void setAttestationRewardAccount(Optional<Address> attestationRewardAccount) {
            this.attestationRewardAccount = attestationRewardAccount;
        }

        @JsonProperty(value="AttestationSignerAccount")
        public void setAttestationSignerAccount(Optional<Address> attestationSignerAccount) {
            this.attestationSignerAccount = attestationSignerAccount;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Optional<Address> destination) {
            this.destination = destination;
        }

        @JsonProperty(value="PublicKey")
        public void setPublicKey(Optional<PublicKey> publicKey) {
            this.publicKey = publicKey;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        public void setWasLockingChainSend(Optional<Boolean> wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
        }

        @Override
        public Optional<CurrencyAmount> amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XrpCurrencyAmount> signatureReward() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> attestationRewardAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> attestationSignerAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<PublicKey> publicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> wasLockingChainSend() {
            throw new UnsupportedOperationException();
        }
    }
}

