/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaXChainClaimProofSig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaXChainClaimProofSig", generator="Immutables")
@Immutable
public final class ImmutableMetaXChainClaimProofSig
implements MetaXChainClaimProofSig {
    @Nullable
    private final Address attestationSignerAccount;
    @Nullable
    private final PublicKey publicKey;
    @Nullable
    private final CurrencyAmount amount;
    @Nullable
    private final Address attestationRewardAccount;
    @Nullable
    private final Boolean wasLockingChainSend;
    @Nullable
    private final Address destination;

    private ImmutableMetaXChainClaimProofSig(@Nullable Address attestationSignerAccount, @Nullable PublicKey publicKey, @Nullable CurrencyAmount amount, @Nullable Address attestationRewardAccount, @Nullable Boolean wasLockingChainSend, @Nullable Address destination) {
        this.attestationSignerAccount = attestationSignerAccount;
        this.publicKey = publicKey;
        this.amount = amount;
        this.attestationRewardAccount = attestationRewardAccount;
        this.wasLockingChainSend = wasLockingChainSend;
        this.destination = destination;
    }

    @Override
    @JsonProperty(value="AttestationSignerAccount")
    public Optional<Address> attestationSignerAccount() {
        return Optional.ofNullable(this.attestationSignerAccount);
    }

    @Override
    @JsonProperty(value="PublicKey")
    public Optional<PublicKey> publicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    @Override
    @JsonProperty(value="Amount")
    public Optional<CurrencyAmount> amount() {
        return Optional.ofNullable(this.amount);
    }

    @Override
    @JsonProperty(value="AttestationRewardAccount")
    public Optional<Address> attestationRewardAccount() {
        return Optional.ofNullable(this.attestationRewardAccount);
    }

    @Override
    @JsonProperty(value="WasLockingChainSend")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    public Optional<Boolean> wasLockingChainSend() {
        return Optional.ofNullable(this.wasLockingChainSend);
    }

    @Override
    @JsonProperty(value="Destination")
    public Optional<Address> destination() {
        return Optional.ofNullable(this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withAttestationSignerAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "attestationSignerAccount");
        if (this.attestationSignerAccount == newValue) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(newValue, this.publicKey, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withAttestationSignerAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.attestationSignerAccount == value) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(value, this.publicKey, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withPublicKey(PublicKey value) {
        PublicKey newValue = Objects.requireNonNull(value, "publicKey");
        if (this.publicKey == newValue) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, newValue, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withPublicKey(Optional<? extends PublicKey> optional) {
        PublicKey value = optional.orElse(null);
        if (this.publicKey == value) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, value, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withAmount(CurrencyAmount value) {
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        if (this.amount == newValue) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, newValue, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withAmount(Optional<? extends CurrencyAmount> optional) {
        CurrencyAmount value = optional.orElse(null);
        if (this.amount == value) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, value, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withAttestationRewardAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "attestationRewardAccount");
        if (this.attestationRewardAccount == newValue) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, newValue, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withAttestationRewardAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.attestationRewardAccount == value) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, value, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withWasLockingChainSend(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.wasLockingChainSend, newValue)) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, this.attestationRewardAccount, newValue, this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withWasLockingChainSend(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.wasLockingChainSend, value)) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, this.attestationRewardAccount, value, this.destination);
    }

    public final ImmutableMetaXChainClaimProofSig withDestination(Address value) {
        Address newValue = Objects.requireNonNull(value, "destination");
        if (this.destination == newValue) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, newValue);
    }

    public final ImmutableMetaXChainClaimProofSig withDestination(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.destination == value) {
            return this;
        }
        return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaXChainClaimProofSig && this.equalTo(0, (ImmutableMetaXChainClaimProofSig)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaXChainClaimProofSig another) {
        return Objects.equals(this.attestationSignerAccount, another.attestationSignerAccount) && Objects.equals(this.publicKey, another.publicKey) && Objects.equals(this.amount, another.amount) && Objects.equals(this.attestationRewardAccount, another.attestationRewardAccount) && Objects.equals(this.wasLockingChainSend, another.wasLockingChainSend) && Objects.equals(this.destination, another.destination);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.attestationSignerAccount);
        h += (h << 5) + Objects.hashCode(this.publicKey);
        h += (h << 5) + Objects.hashCode(this.amount);
        h += (h << 5) + Objects.hashCode(this.attestationRewardAccount);
        h += (h << 5) + Objects.hashCode(this.wasLockingChainSend);
        h += (h << 5) + Objects.hashCode(this.destination);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaXChainClaimProofSig").omitNullValues().add("attestationSignerAccount", (Object)this.attestationSignerAccount).add("publicKey", (Object)this.publicKey).add("amount", (Object)this.amount).add("attestationRewardAccount", (Object)this.attestationRewardAccount).add("wasLockingChainSend", (Object)this.wasLockingChainSend).add("destination", (Object)this.destination).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaXChainClaimProofSig fromJson(Json json) {
        Builder builder = ImmutableMetaXChainClaimProofSig.builder();
        if (json.attestationSignerAccount != null) {
            builder.attestationSignerAccount(json.attestationSignerAccount);
        }
        if (json.publicKey != null) {
            builder.publicKey(json.publicKey);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.attestationRewardAccount != null) {
            builder.attestationRewardAccount(json.attestationRewardAccount);
        }
        if (json.wasLockingChainSend != null) {
            builder.wasLockingChainSend(json.wasLockingChainSend);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        return builder.build();
    }

    public static ImmutableMetaXChainClaimProofSig copyOf(MetaXChainClaimProofSig instance) {
        if (instance instanceof ImmutableMetaXChainClaimProofSig) {
            return (ImmutableMetaXChainClaimProofSig)instance;
        }
        return ImmutableMetaXChainClaimProofSig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaXChainClaimProofSig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address attestationSignerAccount;
        @Nullable
        private PublicKey publicKey;
        @Nullable
        private CurrencyAmount amount;
        @Nullable
        private Address attestationRewardAccount;
        @Nullable
        private Boolean wasLockingChainSend;
        @Nullable
        private Address destination;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaXChainClaimProofSig instance) {
            Optional<Address> destinationOptional;
            Optional<Boolean> wasLockingChainSendOptional;
            Optional<Address> attestationRewardAccountOptional;
            Optional<CurrencyAmount> amountOptional;
            Optional<PublicKey> publicKeyOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> attestationSignerAccountOptional = instance.attestationSignerAccount();
            if (attestationSignerAccountOptional.isPresent()) {
                this.attestationSignerAccount(attestationSignerAccountOptional);
            }
            if ((publicKeyOptional = instance.publicKey()).isPresent()) {
                this.publicKey(publicKeyOptional);
            }
            if ((amountOptional = instance.amount()).isPresent()) {
                this.amount(amountOptional);
            }
            if ((attestationRewardAccountOptional = instance.attestationRewardAccount()).isPresent()) {
                this.attestationRewardAccount(attestationRewardAccountOptional);
            }
            if ((wasLockingChainSendOptional = instance.wasLockingChainSend()).isPresent()) {
                this.wasLockingChainSend(wasLockingChainSendOptional);
            }
            if ((destinationOptional = instance.destination()).isPresent()) {
                this.destination(destinationOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attestationSignerAccount(Address attestationSignerAccount) {
            this.attestationSignerAccount = Objects.requireNonNull(attestationSignerAccount, "attestationSignerAccount");
            return this;
        }

        @JsonProperty(value="AttestationSignerAccount")
        @CanIgnoreReturnValue
        public final Builder attestationSignerAccount(Optional<? extends Address> attestationSignerAccount) {
            this.attestationSignerAccount = attestationSignerAccount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKey(PublicKey publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            return this;
        }

        @JsonProperty(value="PublicKey")
        @CanIgnoreReturnValue
        public final Builder publicKey(Optional<? extends PublicKey> publicKey) {
            this.publicKey = publicKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder amount(CurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(Optional<? extends CurrencyAmount> amount) {
            this.amount = amount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attestationRewardAccount(Address attestationRewardAccount) {
            this.attestationRewardAccount = Objects.requireNonNull(attestationRewardAccount, "attestationRewardAccount");
            return this;
        }

        @JsonProperty(value="AttestationRewardAccount")
        @CanIgnoreReturnValue
        public final Builder attestationRewardAccount(Optional<? extends Address> attestationRewardAccount) {
            this.attestationRewardAccount = attestationRewardAccount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wasLockingChainSend(boolean wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
            return this;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        @CanIgnoreReturnValue
        public final Builder wasLockingChainSend(Optional<Boolean> wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Optional<? extends Address> destination) {
            this.destination = destination.orElse(null);
            return this;
        }

        public ImmutableMetaXChainClaimProofSig build() {
            return new ImmutableMetaXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaXChainClaimProofSig", generator="Immutables")
    static final class Json
    implements MetaXChainClaimProofSig {
        @Nullable
        Optional<Address> attestationSignerAccount = Optional.empty();
        @Nullable
        Optional<PublicKey> publicKey = Optional.empty();
        @Nullable
        Optional<CurrencyAmount> amount = Optional.empty();
        @Nullable
        Optional<Address> attestationRewardAccount = Optional.empty();
        @Nullable
        Optional<Boolean> wasLockingChainSend = Optional.empty();
        @Nullable
        Optional<Address> destination = Optional.empty();

        Json() {
        }

        @JsonProperty(value="AttestationSignerAccount")
        public void setAttestationSignerAccount(Optional<Address> attestationSignerAccount) {
            this.attestationSignerAccount = attestationSignerAccount;
        }

        @JsonProperty(value="PublicKey")
        public void setPublicKey(Optional<PublicKey> publicKey) {
            this.publicKey = publicKey;
        }

        @JsonProperty(value="Amount")
        public void setAmount(Optional<CurrencyAmount> amount) {
            this.amount = amount;
        }

        @JsonProperty(value="AttestationRewardAccount")
        public void setAttestationRewardAccount(Optional<Address> attestationRewardAccount) {
            this.attestationRewardAccount = attestationRewardAccount;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        public void setWasLockingChainSend(Optional<Boolean> wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Optional<Address> destination) {
            this.destination = destination;
        }

        @Override
        public Optional<Address> attestationSignerAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<PublicKey> publicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CurrencyAmount> amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> attestationRewardAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> wasLockingChainSend() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> destination() {
            throw new UnsupportedOperationException();
        }
    }
}

