/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.TradingFee;
import org.xrpl.xrpl4j.model.transactions.VoteWeight;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaVoteEntry;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaVoteEntry", generator="Immutables")
@Immutable
public final class ImmutableMetaVoteEntry
implements MetaVoteEntry {
    @Nullable
    private final Address account;
    @Nullable
    private final TradingFee tradingFee;
    @Nullable
    private final VoteWeight voteWeight;

    private ImmutableMetaVoteEntry(@Nullable Address account, @Nullable TradingFee tradingFee, @Nullable VoteWeight voteWeight) {
        this.account = account;
        this.tradingFee = tradingFee;
        this.voteWeight = voteWeight;
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="TradingFee")
    public Optional<TradingFee> tradingFee() {
        return Optional.ofNullable(this.tradingFee);
    }

    @Override
    @JsonProperty(value="VoteWeight")
    public Optional<VoteWeight> voteWeight() {
        return Optional.ofNullable(this.voteWeight);
    }

    public final ImmutableMetaVoteEntry withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaVoteEntry(newValue, this.tradingFee, this.voteWeight);
    }

    public final ImmutableMetaVoteEntry withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaVoteEntry(value, this.tradingFee, this.voteWeight);
    }

    public final ImmutableMetaVoteEntry withTradingFee(TradingFee value) {
        TradingFee newValue = Objects.requireNonNull(value, "tradingFee");
        if (this.tradingFee == newValue) {
            return this;
        }
        return new ImmutableMetaVoteEntry(this.account, newValue, this.voteWeight);
    }

    public final ImmutableMetaVoteEntry withTradingFee(Optional<? extends TradingFee> optional) {
        TradingFee value = optional.orElse(null);
        if (this.tradingFee == value) {
            return this;
        }
        return new ImmutableMetaVoteEntry(this.account, value, this.voteWeight);
    }

    public final ImmutableMetaVoteEntry withVoteWeight(VoteWeight value) {
        VoteWeight newValue = Objects.requireNonNull(value, "voteWeight");
        if (this.voteWeight == newValue) {
            return this;
        }
        return new ImmutableMetaVoteEntry(this.account, this.tradingFee, newValue);
    }

    public final ImmutableMetaVoteEntry withVoteWeight(Optional<? extends VoteWeight> optional) {
        VoteWeight value = optional.orElse(null);
        if (this.voteWeight == value) {
            return this;
        }
        return new ImmutableMetaVoteEntry(this.account, this.tradingFee, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaVoteEntry && this.equalTo(0, (ImmutableMetaVoteEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaVoteEntry another) {
        return Objects.equals(this.account, another.account) && Objects.equals(this.tradingFee, another.tradingFee) && Objects.equals(this.voteWeight, another.voteWeight);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.tradingFee);
        h += (h << 5) + Objects.hashCode(this.voteWeight);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaVoteEntry").omitNullValues().add("account", (Object)this.account).add("tradingFee", (Object)this.tradingFee).add("voteWeight", (Object)this.voteWeight).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaVoteEntry fromJson(Json json) {
        Builder builder = ImmutableMetaVoteEntry.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.tradingFee != null) {
            builder.tradingFee(json.tradingFee);
        }
        if (json.voteWeight != null) {
            builder.voteWeight(json.voteWeight);
        }
        return builder.build();
    }

    public static ImmutableMetaVoteEntry copyOf(MetaVoteEntry instance) {
        if (instance instanceof ImmutableMetaVoteEntry) {
            return (ImmutableMetaVoteEntry)instance;
        }
        return ImmutableMetaVoteEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaVoteEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private TradingFee tradingFee;
        @Nullable
        private VoteWeight voteWeight;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaVoteEntry instance) {
            Optional<VoteWeight> voteWeightOptional;
            Optional<TradingFee> tradingFeeOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((tradingFeeOptional = instance.tradingFee()).isPresent()) {
                this.tradingFee(tradingFeeOptional);
            }
            if ((voteWeightOptional = instance.voteWeight()).isPresent()) {
                this.voteWeight(voteWeightOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tradingFee(TradingFee tradingFee) {
            this.tradingFee = Objects.requireNonNull(tradingFee, "tradingFee");
            return this;
        }

        @JsonProperty(value="TradingFee")
        @CanIgnoreReturnValue
        public final Builder tradingFee(Optional<? extends TradingFee> tradingFee) {
            this.tradingFee = tradingFee.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder voteWeight(VoteWeight voteWeight) {
            this.voteWeight = Objects.requireNonNull(voteWeight, "voteWeight");
            return this;
        }

        @JsonProperty(value="VoteWeight")
        @CanIgnoreReturnValue
        public final Builder voteWeight(Optional<? extends VoteWeight> voteWeight) {
            this.voteWeight = voteWeight.orElse(null);
            return this;
        }

        public ImmutableMetaVoteEntry build() {
            return new ImmutableMetaVoteEntry(this.account, this.tradingFee, this.voteWeight);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaVoteEntry", generator="Immutables")
    static final class Json
    implements MetaVoteEntry {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<TradingFee> tradingFee = Optional.empty();
        @Nullable
        Optional<VoteWeight> voteWeight = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="TradingFee")
        public void setTradingFee(Optional<TradingFee> tradingFee) {
            this.tradingFee = tradingFee;
        }

        @JsonProperty(value="VoteWeight")
        public void setVoteWeight(Optional<VoteWeight> voteWeight) {
            this.voteWeight = voteWeight;
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TradingFee> tradingFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<VoteWeight> voteWeight() {
            throw new UnsupportedOperationException();
        }
    }
}

