/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.SignerListFlags;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaSignerEntryWrapper;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaSignerListObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaSignerListObject", generator="Immutables")
@Immutable
public final class ImmutableMetaSignerListObject
implements MetaSignerListObject {
    @Nullable
    private final SignerListFlags flags;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final LedgerIndex previousTransactionLedgerSequence;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final UnsignedInteger signerListId;
    @Nullable
    private final UnsignedInteger signerQuorum;
    private final ImmutableList<MetaSignerEntryWrapper> signerEntries;

    private ImmutableMetaSignerListObject(@Nullable SignerListFlags flags, @Nullable Hash256 previousTransactionId, @Nullable LedgerIndex previousTransactionLedgerSequence, @Nullable String ownerNode, @Nullable UnsignedInteger signerListId, @Nullable UnsignedInteger signerQuorum, ImmutableList<MetaSignerEntryWrapper> signerEntries) {
        this.flags = flags;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.ownerNode = ownerNode;
        this.signerListId = signerListId;
        this.signerQuorum = signerQuorum;
        this.signerEntries = signerEntries;
    }

    @Override
    @JsonProperty(value="Flags")
    public Optional<SignerListFlags> flags() {
        return Optional.ofNullable(this.flags);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="SignerListID")
    public Optional<UnsignedInteger> signerListId() {
        return Optional.ofNullable(this.signerListId);
    }

    @Override
    @JsonProperty(value="SignerQuorum")
    public Optional<UnsignedInteger> signerQuorum() {
        return Optional.ofNullable(this.signerQuorum);
    }

    @JsonProperty(value="SignerEntries")
    public ImmutableList<MetaSignerEntryWrapper> signerEntries() {
        return this.signerEntries;
    }

    public final ImmutableMetaSignerListObject withFlags(SignerListFlags value) {
        SignerListFlags newValue = Objects.requireNonNull(value, "flags");
        if (this.flags == newValue) {
            return this;
        }
        return new ImmutableMetaSignerListObject(newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withFlags(Optional<? extends SignerListFlags> optional) {
        SignerListFlags value = optional.orElse(null);
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMetaSignerListObject(value, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaSignerListObject(this.flags, newValue, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaSignerListObject(this.flags, value, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withPreviousTransactionLedgerSequence(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence == newValue) {
            return this;
        }
        return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, newValue, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withPreviousTransactionLedgerSequence(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.previousTransactionLedgerSequence == value) {
            return this;
        }
        return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, value, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue, this.signerListId, this.signerQuorum, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, value, this.signerListId, this.signerQuorum, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withSignerListId(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "signerListId");
        if (Objects.equals(this.signerListId, newValue)) {
            return this;
        }
        return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, newValue, this.signerQuorum, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withSignerListId(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.signerListId, value)) {
            return this;
        }
        return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, value, this.signerQuorum, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withSignerQuorum(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "signerQuorum");
        if (Objects.equals(this.signerQuorum, newValue)) {
            return this;
        }
        return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, newValue, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withSignerQuorum(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.signerQuorum, value)) {
            return this;
        }
        return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, value, this.signerEntries);
    }

    public final ImmutableMetaSignerListObject withSignerEntries(MetaSignerEntryWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, (ImmutableList<MetaSignerEntryWrapper>)newValue);
    }

    public final ImmutableMetaSignerListObject withSignerEntries(Iterable<? extends MetaSignerEntryWrapper> elements) {
        if (this.signerEntries == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, (ImmutableList<MetaSignerEntryWrapper>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaSignerListObject && this.equalTo(0, (ImmutableMetaSignerListObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaSignerListObject another) {
        return Objects.equals(this.flags, another.flags) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.signerListId, another.signerListId) && Objects.equals(this.signerQuorum, another.signerQuorum) && this.signerEntries.equals(another.signerEntries);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.flags);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.signerListId);
        h += (h << 5) + Objects.hashCode(this.signerQuorum);
        h += (h << 5) + this.signerEntries.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaSignerListObject").omitNullValues().add("flags", (Object)this.flags).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("ownerNode", (Object)this.ownerNode).add("signerListId", (Object)this.signerListId).add("signerQuorum", (Object)this.signerQuorum).add("signerEntries", this.signerEntries).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaSignerListObject fromJson(Json json) {
        Builder builder = ImmutableMetaSignerListObject.builder();
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.signerListId != null) {
            builder.signerListId(json.signerListId);
        }
        if (json.signerQuorum != null) {
            builder.signerQuorum(json.signerQuorum);
        }
        if (json.signerEntries != null) {
            builder.addAllSignerEntries(json.signerEntries);
        }
        return builder.build();
    }

    public static ImmutableMetaSignerListObject copyOf(MetaSignerListObject instance) {
        if (instance instanceof ImmutableMetaSignerListObject) {
            return (ImmutableMetaSignerListObject)instance;
        }
        return ImmutableMetaSignerListObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaSignerListObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private SignerListFlags flags;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private LedgerIndex previousTransactionLedgerSequence;
        @Nullable
        private String ownerNode;
        @Nullable
        private UnsignedInteger signerListId;
        @Nullable
        private UnsignedInteger signerQuorum;
        private ImmutableList.Builder<MetaSignerEntryWrapper> signerEntries = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaSignerListObject instance) {
            Optional<UnsignedInteger> signerQuorumOptional;
            Optional<UnsignedInteger> signerListIdOptional;
            Optional<String> ownerNodeOptional;
            Optional<LedgerIndex> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<SignerListFlags> flagsOptional = instance.flags();
            if (flagsOptional.isPresent()) {
                this.flags(flagsOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((signerListIdOptional = instance.signerListId()).isPresent()) {
                this.signerListId(signerListIdOptional);
            }
            if ((signerQuorumOptional = instance.signerQuorum()).isPresent()) {
                this.signerQuorum(signerQuorumOptional);
            }
            this.addAllSignerEntries(instance.signerEntries());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder flags(SignerListFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(Optional<? extends SignerListFlags> flags) {
            this.flags = flags.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(LedgerIndex previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signerListId(UnsignedInteger signerListId) {
            this.signerListId = Objects.requireNonNull(signerListId, "signerListId");
            return this;
        }

        @JsonProperty(value="SignerListID")
        @CanIgnoreReturnValue
        public final Builder signerListId(Optional<? extends UnsignedInteger> signerListId) {
            this.signerListId = signerListId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signerQuorum(UnsignedInteger signerQuorum) {
            this.signerQuorum = Objects.requireNonNull(signerQuorum, "signerQuorum");
            return this;
        }

        @JsonProperty(value="SignerQuorum")
        @CanIgnoreReturnValue
        public final Builder signerQuorum(Optional<? extends UnsignedInteger> signerQuorum) {
            this.signerQuorum = signerQuorum.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignerEntries(MetaSignerEntryWrapper element) {
            this.signerEntries.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignerEntries(MetaSignerEntryWrapper ... elements) {
            this.signerEntries.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="SignerEntries")
        @CanIgnoreReturnValue
        public final Builder signerEntries(Iterable<? extends MetaSignerEntryWrapper> elements) {
            this.signerEntries = ImmutableList.builder();
            return this.addAllSignerEntries(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSignerEntries(Iterable<? extends MetaSignerEntryWrapper> elements) {
            this.signerEntries.addAll(elements);
            return this;
        }

        public ImmutableMetaSignerListObject build() {
            return new ImmutableMetaSignerListObject(this.flags, this.previousTransactionId, this.previousTransactionLedgerSequence, this.ownerNode, this.signerListId, this.signerQuorum, this.signerEntries.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaSignerListObject", generator="Immutables")
    static final class Json
    implements MetaSignerListObject {
        @Nullable
        Optional<SignerListFlags> flags = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<LedgerIndex> previousTransactionLedgerSequence = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> signerListId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> signerQuorum = Optional.empty();
        @Nullable
        List<MetaSignerEntryWrapper> signerEntries = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Flags")
        public void setFlags(Optional<SignerListFlags> flags) {
            this.flags = flags;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="SignerListID")
        public void setSignerListId(Optional<UnsignedInteger> signerListId) {
            this.signerListId = signerListId;
        }

        @JsonProperty(value="SignerQuorum")
        public void setSignerQuorum(Optional<UnsignedInteger> signerQuorum) {
            this.signerQuorum = signerQuorum;
        }

        @JsonProperty(value="SignerEntries")
        public void setSignerEntries(List<MetaSignerEntryWrapper> signerEntries) {
            this.signerEntries = signerEntries;
        }

        @Override
        public Optional<SignerListFlags> flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> signerListId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> signerQuorum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MetaSignerEntryWrapper> signerEntries() {
            throw new UnsupportedOperationException();
        }
    }
}

