/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaPayChannelObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaPayChannelObject", generator="Immutables")
@Immutable
public final class ImmutableMetaPayChannelObject
implements MetaPayChannelObject {
    private final transient Flags flags;
    @Nullable
    private final Address account;
    @Nullable
    private final Address destination;
    @Nullable
    private final XrpCurrencyAmount amount;
    @Nullable
    private final XrpCurrencyAmount balance;
    @Nullable
    private final String publicKey;
    @Nullable
    private final UnsignedLong settleDelay;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final LedgerIndex previousTransactionLedgerSequence;
    @Nullable
    private final UnsignedLong expiration;
    @Nullable
    private final UnsignedLong cancelAfter;
    @Nullable
    private final UnsignedInteger sourceTag;
    @Nullable
    private final UnsignedInteger destinationTag;

    private ImmutableMetaPayChannelObject(@Nullable Address account, @Nullable Address destination, @Nullable XrpCurrencyAmount amount, @Nullable XrpCurrencyAmount balance, @Nullable String publicKey, @Nullable UnsignedLong settleDelay, @Nullable String ownerNode, @Nullable Hash256 previousTransactionId, @Nullable LedgerIndex previousTransactionLedgerSequence, @Nullable UnsignedLong expiration, @Nullable UnsignedLong cancelAfter, @Nullable UnsignedInteger sourceTag, @Nullable UnsignedInteger destinationTag) {
        this.account = account;
        this.destination = destination;
        this.amount = amount;
        this.balance = balance;
        this.publicKey = publicKey;
        this.settleDelay = settleDelay;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.expiration = expiration;
        this.cancelAfter = cancelAfter;
        this.sourceTag = sourceTag;
        this.destinationTag = destinationTag;
        this.flags = Objects.requireNonNull(MetaPayChannelObject.super.flags(), "flags");
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="Destination")
    public Optional<Address> destination() {
        return Optional.ofNullable(this.destination);
    }

    @Override
    @JsonProperty(value="Amount")
    public Optional<XrpCurrencyAmount> amount() {
        return Optional.ofNullable(this.amount);
    }

    @Override
    @JsonProperty(value="Balance")
    public Optional<XrpCurrencyAmount> balance() {
        return Optional.ofNullable(this.balance);
    }

    @Override
    @JsonProperty(value="PublicKey")
    public Optional<String> publicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    @Override
    @JsonProperty(value="SettleDelay")
    public Optional<UnsignedLong> settleDelay() {
        return Optional.ofNullable(this.settleDelay);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    @Override
    @JsonProperty(value="Expiration")
    public Optional<UnsignedLong> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    @Override
    @JsonProperty(value="CancelAfter")
    public Optional<UnsignedLong> cancelAfter() {
        return Optional.ofNullable(this.cancelAfter);
    }

    @Override
    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag() {
        return Optional.ofNullable(this.sourceTag);
    }

    @Override
    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag() {
        return Optional.ofNullable(this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(newValue, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(value, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withDestination(Address value) {
        Address newValue = Objects.requireNonNull(value, "destination");
        if (this.destination == newValue) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, newValue, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withDestination(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.destination == value) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, value, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withAmount(XrpCurrencyAmount value) {
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        if (this.amount == newValue) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, newValue, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withAmount(Optional<? extends XrpCurrencyAmount> optional) {
        XrpCurrencyAmount value = optional.orElse(null);
        if (this.amount == value) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, value, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withBalance(XrpCurrencyAmount value) {
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "balance");
        if (this.balance == newValue) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, newValue, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withBalance(Optional<? extends XrpCurrencyAmount> optional) {
        XrpCurrencyAmount value = optional.orElse(null);
        if (this.balance == value) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, value, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "publicKey");
        if (Objects.equals(this.publicKey, newValue)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, newValue, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withPublicKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.publicKey, value)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, value, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withSettleDelay(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "settleDelay");
        if (Objects.equals(this.settleDelay, newValue)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withSettleDelay(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.settleDelay, value)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, value, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, value, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, newValue, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, value, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withPreviousTransactionLedgerSequence(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence == newValue) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, newValue, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withPreviousTransactionLedgerSequence(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.previousTransactionLedgerSequence == value) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, value, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withExpiration(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withExpiration(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, value, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withCancelAfter(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "cancelAfter");
        if (Objects.equals(this.cancelAfter, newValue)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, newValue, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withCancelAfter(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.cancelAfter, value)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, value, this.sourceTag, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withSourceTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sourceTag");
        if (Objects.equals(this.sourceTag, newValue)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, newValue, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withSourceTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sourceTag, value)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, value, this.destinationTag);
    }

    public final ImmutableMetaPayChannelObject withDestinationTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "destinationTag");
        if (Objects.equals(this.destinationTag, newValue)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, newValue);
    }

    public final ImmutableMetaPayChannelObject withDestinationTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.destinationTag, value)) {
            return this;
        }
        return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaPayChannelObject && this.equalTo(0, (ImmutableMetaPayChannelObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaPayChannelObject another) {
        return this.flags.equals(another.flags) && Objects.equals(this.account, another.account) && Objects.equals(this.destination, another.destination) && Objects.equals(this.amount, another.amount) && Objects.equals(this.balance, another.balance) && Objects.equals(this.publicKey, another.publicKey) && Objects.equals(this.settleDelay, another.settleDelay) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence) && Objects.equals(this.expiration, another.expiration) && Objects.equals(this.cancelAfter, another.cancelAfter) && Objects.equals(this.sourceTag, another.sourceTag) && Objects.equals(this.destinationTag, another.destinationTag);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.destination);
        h += (h << 5) + Objects.hashCode(this.amount);
        h += (h << 5) + Objects.hashCode(this.balance);
        h += (h << 5) + Objects.hashCode(this.publicKey);
        h += (h << 5) + Objects.hashCode(this.settleDelay);
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        h += (h << 5) + Objects.hashCode(this.expiration);
        h += (h << 5) + Objects.hashCode(this.cancelAfter);
        h += (h << 5) + Objects.hashCode(this.sourceTag);
        h += (h << 5) + Objects.hashCode(this.destinationTag);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaPayChannelObject").omitNullValues().add("flags", (Object)this.flags).add("account", (Object)this.account).add("destination", (Object)this.destination).add("amount", (Object)this.amount).add("balance", (Object)this.balance).add("publicKey", (Object)this.publicKey).add("settleDelay", (Object)this.settleDelay).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("expiration", (Object)this.expiration).add("cancelAfter", (Object)this.cancelAfter).add("sourceTag", (Object)this.sourceTag).add("destinationTag", (Object)this.destinationTag).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaPayChannelObject fromJson(Json json) {
        Builder builder = ImmutableMetaPayChannelObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.balance != null) {
            builder.balance(json.balance);
        }
        if (json.publicKey != null) {
            builder.publicKey(json.publicKey);
        }
        if (json.settleDelay != null) {
            builder.settleDelay(json.settleDelay);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        if (json.cancelAfter != null) {
            builder.cancelAfter(json.cancelAfter);
        }
        if (json.sourceTag != null) {
            builder.sourceTag(json.sourceTag);
        }
        if (json.destinationTag != null) {
            builder.destinationTag(json.destinationTag);
        }
        return builder.build();
    }

    public static ImmutableMetaPayChannelObject copyOf(MetaPayChannelObject instance) {
        if (instance instanceof ImmutableMetaPayChannelObject) {
            return (ImmutableMetaPayChannelObject)instance;
        }
        return ImmutableMetaPayChannelObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaPayChannelObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private Address destination;
        @Nullable
        private XrpCurrencyAmount amount;
        @Nullable
        private XrpCurrencyAmount balance;
        @Nullable
        private String publicKey;
        @Nullable
        private UnsignedLong settleDelay;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private LedgerIndex previousTransactionLedgerSequence;
        @Nullable
        private UnsignedLong expiration;
        @Nullable
        private UnsignedLong cancelAfter;
        @Nullable
        private UnsignedInteger sourceTag;
        @Nullable
        private UnsignedInteger destinationTag;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaPayChannelObject instance) {
            Optional<UnsignedInteger> destinationTagOptional;
            Optional<UnsignedInteger> sourceTagOptional;
            Optional<UnsignedLong> cancelAfterOptional;
            Optional<UnsignedLong> expirationOptional;
            Optional<LedgerIndex> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<String> ownerNodeOptional;
            Optional<UnsignedLong> settleDelayOptional;
            Optional<String> publicKeyOptional;
            Optional<XrpCurrencyAmount> balanceOptional;
            Optional<XrpCurrencyAmount> amountOptional;
            Optional<Address> destinationOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((destinationOptional = instance.destination()).isPresent()) {
                this.destination(destinationOptional);
            }
            if ((amountOptional = instance.amount()).isPresent()) {
                this.amount(amountOptional);
            }
            if ((balanceOptional = instance.balance()).isPresent()) {
                this.balance(balanceOptional);
            }
            if ((publicKeyOptional = instance.publicKey()).isPresent()) {
                this.publicKey(publicKeyOptional);
            }
            if ((settleDelayOptional = instance.settleDelay()).isPresent()) {
                this.settleDelay(settleDelayOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            if ((expirationOptional = instance.expiration()).isPresent()) {
                this.expiration(expirationOptional);
            }
            if ((cancelAfterOptional = instance.cancelAfter()).isPresent()) {
                this.cancelAfter(cancelAfterOptional);
            }
            if ((sourceTagOptional = instance.sourceTag()).isPresent()) {
                this.sourceTag(sourceTagOptional);
            }
            if ((destinationTagOptional = instance.destinationTag()).isPresent()) {
                this.destinationTag(destinationTagOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Optional<? extends Address> destination) {
            this.destination = destination.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder amount(XrpCurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(Optional<? extends XrpCurrencyAmount> amount) {
            this.amount = amount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder balance(XrpCurrencyAmount balance) {
            this.balance = Objects.requireNonNull(balance, "balance");
            return this;
        }

        @JsonProperty(value="Balance")
        @CanIgnoreReturnValue
        public final Builder balance(Optional<? extends XrpCurrencyAmount> balance) {
            this.balance = balance.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKey(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            return this;
        }

        @JsonProperty(value="PublicKey")
        @CanIgnoreReturnValue
        public final Builder publicKey(Optional<String> publicKey) {
            this.publicKey = publicKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder settleDelay(UnsignedLong settleDelay) {
            this.settleDelay = Objects.requireNonNull(settleDelay, "settleDelay");
            return this;
        }

        @JsonProperty(value="SettleDelay")
        @CanIgnoreReturnValue
        public final Builder settleDelay(Optional<? extends UnsignedLong> settleDelay) {
            this.settleDelay = settleDelay.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(LedgerIndex previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedLong expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="Expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedLong> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cancelAfter(UnsignedLong cancelAfter) {
            this.cancelAfter = Objects.requireNonNull(cancelAfter, "cancelAfter");
            return this;
        }

        @JsonProperty(value="CancelAfter")
        @CanIgnoreReturnValue
        public final Builder cancelAfter(Optional<? extends UnsignedLong> cancelAfter) {
            this.cancelAfter = cancelAfter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceTag(UnsignedInteger sourceTag) {
            this.sourceTag = Objects.requireNonNull(sourceTag, "sourceTag");
            return this;
        }

        @JsonProperty(value="SourceTag")
        @CanIgnoreReturnValue
        public final Builder sourceTag(Optional<? extends UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationTag(UnsignedInteger destinationTag) {
            this.destinationTag = Objects.requireNonNull(destinationTag, "destinationTag");
            return this;
        }

        @JsonProperty(value="DestinationTag")
        @CanIgnoreReturnValue
        public final Builder destinationTag(Optional<? extends UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag.orElse(null);
            return this;
        }

        public ImmutableMetaPayChannelObject build() {
            return new ImmutableMetaPayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaPayChannelObject", generator="Immutables")
    static final class Json
    implements MetaPayChannelObject {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<Address> destination = Optional.empty();
        @Nullable
        Optional<XrpCurrencyAmount> amount = Optional.empty();
        @Nullable
        Optional<XrpCurrencyAmount> balance = Optional.empty();
        @Nullable
        Optional<String> publicKey = Optional.empty();
        @Nullable
        Optional<UnsignedLong> settleDelay = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<LedgerIndex> previousTransactionLedgerSequence = Optional.empty();
        @Nullable
        Optional<UnsignedLong> expiration = Optional.empty();
        @Nullable
        Optional<UnsignedLong> cancelAfter = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> sourceTag = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> destinationTag = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Optional<Address> destination) {
            this.destination = destination;
        }

        @JsonProperty(value="Amount")
        public void setAmount(Optional<XrpCurrencyAmount> amount) {
            this.amount = amount;
        }

        @JsonProperty(value="Balance")
        public void setBalance(Optional<XrpCurrencyAmount> balance) {
            this.balance = balance;
        }

        @JsonProperty(value="PublicKey")
        public void setPublicKey(Optional<String> publicKey) {
            this.publicKey = publicKey;
        }

        @JsonProperty(value="SettleDelay")
        public void setSettleDelay(Optional<UnsignedLong> settleDelay) {
            this.settleDelay = settleDelay;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="Expiration")
        public void setExpiration(Optional<UnsignedLong> expiration) {
            this.expiration = expiration;
        }

        @JsonProperty(value="CancelAfter")
        public void setCancelAfter(Optional<UnsignedLong> cancelAfter) {
            this.cancelAfter = cancelAfter;
        }

        @JsonProperty(value="SourceTag")
        public void setSourceTag(Optional<UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag;
        }

        @JsonProperty(value="DestinationTag")
        public void setDestinationTag(Optional<UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag;
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XrpCurrencyAmount> amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XrpCurrencyAmount> balance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> publicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> settleDelay() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> expiration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> cancelAfter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sourceTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> destinationTag() {
            throw new UnsupportedOperationException();
        }
    }
}

