/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.OfferFlags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaOfferObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaOfferObject", generator="Immutables")
@Immutable
public final class ImmutableMetaOfferObject
implements MetaOfferObject {
    @Nullable
    private final Address account;
    @Nullable
    private final OfferFlags flags;
    @Nullable
    private final UnsignedInteger sequence;
    @Nullable
    private final CurrencyAmount takerPays;
    @Nullable
    private final CurrencyAmount takerGets;
    @Nullable
    private final Hash256 bookDirectory;
    @Nullable
    private final String bookNode;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final LedgerIndex previousTransactionLedgerSequence;
    @Nullable
    private final UnsignedInteger expiration;

    private ImmutableMetaOfferObject(@Nullable Address account, @Nullable OfferFlags flags, @Nullable UnsignedInteger sequence, @Nullable CurrencyAmount takerPays, @Nullable CurrencyAmount takerGets, @Nullable Hash256 bookDirectory, @Nullable String bookNode, @Nullable String ownerNode, @Nullable Hash256 previousTransactionId, @Nullable LedgerIndex previousTransactionLedgerSequence, @Nullable UnsignedInteger expiration) {
        this.account = account;
        this.flags = flags;
        this.sequence = sequence;
        this.takerPays = takerPays;
        this.takerGets = takerGets;
        this.bookDirectory = bookDirectory;
        this.bookNode = bookNode;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.expiration = expiration;
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="Flags")
    public Optional<OfferFlags> flags() {
        return Optional.ofNullable(this.flags);
    }

    @Override
    @JsonProperty(value="Sequence")
    public Optional<UnsignedInteger> sequence() {
        return Optional.ofNullable(this.sequence);
    }

    @Override
    @JsonProperty(value="TakerPays")
    public Optional<CurrencyAmount> takerPays() {
        return Optional.ofNullable(this.takerPays);
    }

    @Override
    @JsonProperty(value="TakerGets")
    public Optional<CurrencyAmount> takerGets() {
        return Optional.ofNullable(this.takerGets);
    }

    @Override
    @JsonProperty(value="BookDirectory")
    public Optional<Hash256> bookDirectory() {
        return Optional.ofNullable(this.bookDirectory);
    }

    @Override
    @JsonProperty(value="BookNode")
    public Optional<String> bookNode() {
        return Optional.ofNullable(this.bookNode);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    @Override
    @JsonProperty(value="Expiration")
    public Optional<UnsignedInteger> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    public final ImmutableMetaOfferObject withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaOfferObject(newValue, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaOfferObject(value, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withFlags(OfferFlags value) {
        OfferFlags newValue = Objects.requireNonNull(value, "flags");
        if (this.flags == newValue) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, newValue, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withFlags(Optional<? extends OfferFlags> optional) {
        OfferFlags value = optional.orElse(null);
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, value, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (Objects.equals(this.sequence, newValue)) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, newValue, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sequence, value)) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, value, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withTakerPays(CurrencyAmount value) {
        CurrencyAmount newValue = Objects.requireNonNull(value, "takerPays");
        if (this.takerPays == newValue) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, newValue, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withTakerPays(Optional<? extends CurrencyAmount> optional) {
        CurrencyAmount value = optional.orElse(null);
        if (this.takerPays == value) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, value, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withTakerGets(CurrencyAmount value) {
        CurrencyAmount newValue = Objects.requireNonNull(value, "takerGets");
        if (this.takerGets == newValue) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, newValue, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withTakerGets(Optional<? extends CurrencyAmount> optional) {
        CurrencyAmount value = optional.orElse(null);
        if (this.takerGets == value) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, value, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withBookDirectory(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "bookDirectory");
        if (this.bookDirectory == newValue) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, newValue, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withBookDirectory(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.bookDirectory == value) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, value, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withBookNode(String value) {
        String newValue = Objects.requireNonNull(value, "bookNode");
        if (Objects.equals(this.bookNode, newValue)) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withBookNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.bookNode, value)) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, value, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, value, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, newValue, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, value, this.previousTransactionLedgerSequence, this.expiration);
    }

    public final ImmutableMetaOfferObject withPreviousTransactionLedgerSequence(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence == newValue) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, newValue, this.expiration);
    }

    public final ImmutableMetaOfferObject withPreviousTransactionLedgerSequence(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.previousTransactionLedgerSequence == value) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, value, this.expiration);
    }

    public final ImmutableMetaOfferObject withExpiration(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue);
    }

    public final ImmutableMetaOfferObject withExpiration(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaOfferObject && this.equalTo(0, (ImmutableMetaOfferObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaOfferObject another) {
        return Objects.equals(this.account, another.account) && Objects.equals(this.flags, another.flags) && Objects.equals(this.sequence, another.sequence) && Objects.equals(this.takerPays, another.takerPays) && Objects.equals(this.takerGets, another.takerGets) && Objects.equals(this.bookDirectory, another.bookDirectory) && Objects.equals(this.bookNode, another.bookNode) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence) && Objects.equals(this.expiration, another.expiration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.flags);
        h += (h << 5) + Objects.hashCode(this.sequence);
        h += (h << 5) + Objects.hashCode(this.takerPays);
        h += (h << 5) + Objects.hashCode(this.takerGets);
        h += (h << 5) + Objects.hashCode(this.bookDirectory);
        h += (h << 5) + Objects.hashCode(this.bookNode);
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        h += (h << 5) + Objects.hashCode(this.expiration);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaOfferObject").omitNullValues().add("account", (Object)this.account).add("flags", (Object)this.flags).add("sequence", (Object)this.sequence).add("takerPays", (Object)this.takerPays).add("takerGets", (Object)this.takerGets).add("bookDirectory", (Object)this.bookDirectory).add("bookNode", (Object)this.bookNode).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("expiration", (Object)this.expiration).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaOfferObject fromJson(Json json) {
        Builder builder = ImmutableMetaOfferObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.takerPays != null) {
            builder.takerPays(json.takerPays);
        }
        if (json.takerGets != null) {
            builder.takerGets(json.takerGets);
        }
        if (json.bookDirectory != null) {
            builder.bookDirectory(json.bookDirectory);
        }
        if (json.bookNode != null) {
            builder.bookNode(json.bookNode);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        return builder.build();
    }

    public static ImmutableMetaOfferObject copyOf(MetaOfferObject instance) {
        if (instance instanceof ImmutableMetaOfferObject) {
            return (ImmutableMetaOfferObject)instance;
        }
        return ImmutableMetaOfferObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaOfferObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private OfferFlags flags;
        @Nullable
        private UnsignedInteger sequence;
        @Nullable
        private CurrencyAmount takerPays;
        @Nullable
        private CurrencyAmount takerGets;
        @Nullable
        private Hash256 bookDirectory;
        @Nullable
        private String bookNode;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private LedgerIndex previousTransactionLedgerSequence;
        @Nullable
        private UnsignedInteger expiration;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaOfferObject instance) {
            Optional<UnsignedInteger> expirationOptional;
            Optional<LedgerIndex> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<String> ownerNodeOptional;
            Optional<String> bookNodeOptional;
            Optional<Hash256> bookDirectoryOptional;
            Optional<CurrencyAmount> takerGetsOptional;
            Optional<CurrencyAmount> takerPaysOptional;
            Optional<UnsignedInteger> sequenceOptional;
            Optional<OfferFlags> flagsOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((flagsOptional = instance.flags()).isPresent()) {
                this.flags(flagsOptional);
            }
            if ((sequenceOptional = instance.sequence()).isPresent()) {
                this.sequence(sequenceOptional);
            }
            if ((takerPaysOptional = instance.takerPays()).isPresent()) {
                this.takerPays(takerPaysOptional);
            }
            if ((takerGetsOptional = instance.takerGets()).isPresent()) {
                this.takerGets(takerGetsOptional);
            }
            if ((bookDirectoryOptional = instance.bookDirectory()).isPresent()) {
                this.bookDirectory(bookDirectoryOptional);
            }
            if ((bookNodeOptional = instance.bookNode()).isPresent()) {
                this.bookNode(bookNodeOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            if ((expirationOptional = instance.expiration()).isPresent()) {
                this.expiration(expirationOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder flags(OfferFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(Optional<? extends OfferFlags> flags) {
            this.flags = flags.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            return this;
        }

        @JsonProperty(value="Sequence")
        @CanIgnoreReturnValue
        public final Builder sequence(Optional<? extends UnsignedInteger> sequence) {
            this.sequence = sequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder takerPays(CurrencyAmount takerPays) {
            this.takerPays = Objects.requireNonNull(takerPays, "takerPays");
            return this;
        }

        @JsonProperty(value="TakerPays")
        @CanIgnoreReturnValue
        public final Builder takerPays(Optional<? extends CurrencyAmount> takerPays) {
            this.takerPays = takerPays.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder takerGets(CurrencyAmount takerGets) {
            this.takerGets = Objects.requireNonNull(takerGets, "takerGets");
            return this;
        }

        @JsonProperty(value="TakerGets")
        @CanIgnoreReturnValue
        public final Builder takerGets(Optional<? extends CurrencyAmount> takerGets) {
            this.takerGets = takerGets.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bookDirectory(Hash256 bookDirectory) {
            this.bookDirectory = Objects.requireNonNull(bookDirectory, "bookDirectory");
            return this;
        }

        @JsonProperty(value="BookDirectory")
        @CanIgnoreReturnValue
        public final Builder bookDirectory(Optional<? extends Hash256> bookDirectory) {
            this.bookDirectory = bookDirectory.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bookNode(String bookNode) {
            this.bookNode = Objects.requireNonNull(bookNode, "bookNode");
            return this;
        }

        @JsonProperty(value="BookNode")
        @CanIgnoreReturnValue
        public final Builder bookNode(Optional<String> bookNode) {
            this.bookNode = bookNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(LedgerIndex previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedInteger expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="Expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedInteger> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        public ImmutableMetaOfferObject build() {
            return new ImmutableMetaOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaOfferObject", generator="Immutables")
    static final class Json
    implements MetaOfferObject {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<OfferFlags> flags = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> sequence = Optional.empty();
        @Nullable
        Optional<CurrencyAmount> takerPays = Optional.empty();
        @Nullable
        Optional<CurrencyAmount> takerGets = Optional.empty();
        @Nullable
        Optional<Hash256> bookDirectory = Optional.empty();
        @Nullable
        Optional<String> bookNode = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<LedgerIndex> previousTransactionLedgerSequence = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> expiration = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="Flags")
        public void setFlags(Optional<OfferFlags> flags) {
            this.flags = flags;
        }

        @JsonProperty(value="Sequence")
        public void setSequence(Optional<UnsignedInteger> sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="TakerPays")
        public void setTakerPays(Optional<CurrencyAmount> takerPays) {
            this.takerPays = takerPays;
        }

        @JsonProperty(value="TakerGets")
        public void setTakerGets(Optional<CurrencyAmount> takerGets) {
            this.takerGets = takerGets;
        }

        @JsonProperty(value="BookDirectory")
        public void setBookDirectory(Optional<Hash256> bookDirectory) {
            this.bookDirectory = bookDirectory;
        }

        @JsonProperty(value="BookNode")
        public void setBookNode(Optional<String> bookNode) {
            this.bookNode = bookNode;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="Expiration")
        public void setExpiration(Optional<UnsignedInteger> expiration) {
            this.expiration = expiration;
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<OfferFlags> flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CurrencyAmount> takerPays() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CurrencyAmount> takerGets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> bookDirectory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> bookNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> expiration() {
            throw new UnsupportedOperationException();
        }
    }
}

