/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.ledger.NfTokenWrapper;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaNfTokenPageObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaNfTokenPageObject", generator="Immutables")
@Immutable
public final class ImmutableMetaNfTokenPageObject
implements MetaNfTokenPageObject {
    private final ImmutableList<NfTokenWrapper> nfTokens;
    @Nullable
    private final Hash256 nextPageMin;
    @Nullable
    private final Hash256 previousPageMin;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final LedgerIndex previousTransactionLedgerSequence;

    private ImmutableMetaNfTokenPageObject(ImmutableList<NfTokenWrapper> nfTokens, @Nullable Hash256 nextPageMin, @Nullable Hash256 previousPageMin, @Nullable Hash256 previousTransactionId, @Nullable LedgerIndex previousTransactionLedgerSequence) {
        this.nfTokens = nfTokens;
        this.nextPageMin = nextPageMin;
        this.previousPageMin = previousPageMin;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
    }

    @JsonProperty(value="NFTokens")
    public ImmutableList<NfTokenWrapper> nfTokens() {
        return this.nfTokens;
    }

    @Override
    @JsonProperty(value="NextPageMin")
    public Optional<Hash256> nextPageMin() {
        return Optional.ofNullable(this.nextPageMin);
    }

    @Override
    @JsonProperty(value="PreviousPageMin")
    public Optional<Hash256> previousPageMin() {
        return Optional.ofNullable(this.previousPageMin);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaNfTokenPageObject withNfTokens(NfTokenWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMetaNfTokenPageObject((ImmutableList<NfTokenWrapper>)newValue, this.nextPageMin, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaNfTokenPageObject withNfTokens(Iterable<? extends NfTokenWrapper> elements) {
        if (this.nfTokens == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetaNfTokenPageObject((ImmutableList<NfTokenWrapper>)newValue, this.nextPageMin, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaNfTokenPageObject withNextPageMin(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "nextPageMin");
        if (this.nextPageMin == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenPageObject(this.nfTokens, newValue, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaNfTokenPageObject withNextPageMin(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.nextPageMin == value) {
            return this;
        }
        return new ImmutableMetaNfTokenPageObject(this.nfTokens, value, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaNfTokenPageObject withPreviousPageMin(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousPageMin");
        if (this.previousPageMin == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenPageObject(this.nfTokens, this.nextPageMin, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaNfTokenPageObject withPreviousPageMin(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousPageMin == value) {
            return this;
        }
        return new ImmutableMetaNfTokenPageObject(this.nfTokens, this.nextPageMin, value, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaNfTokenPageObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenPageObject(this.nfTokens, this.nextPageMin, this.previousPageMin, newValue, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaNfTokenPageObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaNfTokenPageObject(this.nfTokens, this.nextPageMin, this.previousPageMin, value, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaNfTokenPageObject withPreviousTransactionLedgerSequence(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenPageObject(this.nfTokens, this.nextPageMin, this.previousPageMin, this.previousTransactionId, newValue);
    }

    public final ImmutableMetaNfTokenPageObject withPreviousTransactionLedgerSequence(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.previousTransactionLedgerSequence == value) {
            return this;
        }
        return new ImmutableMetaNfTokenPageObject(this.nfTokens, this.nextPageMin, this.previousPageMin, this.previousTransactionId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaNfTokenPageObject && this.equalTo(0, (ImmutableMetaNfTokenPageObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaNfTokenPageObject another) {
        return this.nfTokens.equals(another.nfTokens) && Objects.equals(this.nextPageMin, another.nextPageMin) && Objects.equals(this.previousPageMin, another.previousPageMin) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nfTokens.hashCode();
        h += (h << 5) + Objects.hashCode(this.nextPageMin);
        h += (h << 5) + Objects.hashCode(this.previousPageMin);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaNfTokenPageObject").omitNullValues().add("nfTokens", this.nfTokens).add("nextPageMin", (Object)this.nextPageMin).add("previousPageMin", (Object)this.previousPageMin).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaNfTokenPageObject fromJson(Json json) {
        Builder builder = ImmutableMetaNfTokenPageObject.builder();
        if (json.nfTokens != null) {
            builder.addAllNfTokens(json.nfTokens);
        }
        if (json.nextPageMin != null) {
            builder.nextPageMin(json.nextPageMin);
        }
        if (json.previousPageMin != null) {
            builder.previousPageMin(json.previousPageMin);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        return builder.build();
    }

    public static ImmutableMetaNfTokenPageObject copyOf(MetaNfTokenPageObject instance) {
        if (instance instanceof ImmutableMetaNfTokenPageObject) {
            return (ImmutableMetaNfTokenPageObject)instance;
        }
        return ImmutableMetaNfTokenPageObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaNfTokenPageObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<NfTokenWrapper> nfTokens = ImmutableList.builder();
        @Nullable
        private Hash256 nextPageMin;
        @Nullable
        private Hash256 previousPageMin;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private LedgerIndex previousTransactionLedgerSequence;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaNfTokenPageObject instance) {
            Optional<LedgerIndex> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<Hash256> previousPageMinOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllNfTokens(instance.nfTokens());
            Optional<Hash256> nextPageMinOptional = instance.nextPageMin();
            if (nextPageMinOptional.isPresent()) {
                this.nextPageMin(nextPageMinOptional);
            }
            if ((previousPageMinOptional = instance.previousPageMin()).isPresent()) {
                this.previousPageMin(previousPageMinOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNfTokens(NfTokenWrapper element) {
            this.nfTokens.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNfTokens(NfTokenWrapper ... elements) {
            this.nfTokens.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="NFTokens")
        @CanIgnoreReturnValue
        public final Builder nfTokens(Iterable<? extends NfTokenWrapper> elements) {
            this.nfTokens = ImmutableList.builder();
            return this.addAllNfTokens(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNfTokens(Iterable<? extends NfTokenWrapper> elements) {
            this.nfTokens.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nextPageMin(Hash256 nextPageMin) {
            this.nextPageMin = Objects.requireNonNull(nextPageMin, "nextPageMin");
            return this;
        }

        @JsonProperty(value="NextPageMin")
        @CanIgnoreReturnValue
        public final Builder nextPageMin(Optional<? extends Hash256> nextPageMin) {
            this.nextPageMin = nextPageMin.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousPageMin(Hash256 previousPageMin) {
            this.previousPageMin = Objects.requireNonNull(previousPageMin, "previousPageMin");
            return this;
        }

        @JsonProperty(value="PreviousPageMin")
        @CanIgnoreReturnValue
        public final Builder previousPageMin(Optional<? extends Hash256> previousPageMin) {
            this.previousPageMin = previousPageMin.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(LedgerIndex previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        public ImmutableMetaNfTokenPageObject build() {
            return new ImmutableMetaNfTokenPageObject(this.nfTokens.build(), this.nextPageMin, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaNfTokenPageObject", generator="Immutables")
    static final class Json
    implements MetaNfTokenPageObject {
        @Nullable
        List<NfTokenWrapper> nfTokens = ImmutableList.of();
        @Nullable
        Optional<Hash256> nextPageMin = Optional.empty();
        @Nullable
        Optional<Hash256> previousPageMin = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<LedgerIndex> previousTransactionLedgerSequence = Optional.empty();

        Json() {
        }

        @JsonProperty(value="NFTokens")
        public void setNfTokens(List<NfTokenWrapper> nfTokens) {
            this.nfTokens = nfTokens;
        }

        @JsonProperty(value="NextPageMin")
        public void setNextPageMin(Optional<Hash256> nextPageMin) {
            this.nextPageMin = nextPageMin;
        }

        @JsonProperty(value="PreviousPageMin")
        public void setPreviousPageMin(Optional<Hash256> previousPageMin) {
            this.previousPageMin = previousPageMin;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @Override
        public List<NfTokenWrapper> nfTokens() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> nextPageMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousPageMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }
    }
}

