/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.NfTokenOfferFlags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaNfTokenOfferObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaNfTokenOfferObject", generator="Immutables")
@Immutable
public final class ImmutableMetaNfTokenOfferObject
implements MetaNfTokenOfferObject {
    @Nullable
    private final CurrencyAmount amount;
    @Nullable
    private final Address owner;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final LedgerIndex previousTransactionLedgerSequence;
    @Nullable
    private final NfTokenId nfTokenId;
    @Nullable
    private final UnsignedInteger expiration;
    @Nullable
    private final Address destination;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final String offerNode;
    @Nullable
    private final NfTokenOfferFlags flags;

    private ImmutableMetaNfTokenOfferObject(@Nullable CurrencyAmount amount, @Nullable Address owner, @Nullable Hash256 previousTransactionId, @Nullable LedgerIndex previousTransactionLedgerSequence, @Nullable NfTokenId nfTokenId, @Nullable UnsignedInteger expiration, @Nullable Address destination, @Nullable String ownerNode, @Nullable String offerNode, @Nullable NfTokenOfferFlags flags) {
        this.amount = amount;
        this.owner = owner;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.nfTokenId = nfTokenId;
        this.expiration = expiration;
        this.destination = destination;
        this.ownerNode = ownerNode;
        this.offerNode = offerNode;
        this.flags = flags;
    }

    @Override
    @JsonProperty(value="Amount")
    public Optional<CurrencyAmount> amount() {
        return Optional.ofNullable(this.amount);
    }

    @Override
    @JsonProperty(value="Owner")
    public Optional<Address> owner() {
        return Optional.ofNullable(this.owner);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    @Override
    @JsonProperty(value="NFTokenID")
    public Optional<NfTokenId> nfTokenId() {
        return Optional.ofNullable(this.nfTokenId);
    }

    @Override
    @JsonProperty(value="expiration")
    public Optional<UnsignedInteger> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    @Override
    @JsonProperty(value="Destination")
    public Optional<Address> destination() {
        return Optional.ofNullable(this.destination);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="NFTokenOfferNode")
    public Optional<String> offerNode() {
        return Optional.ofNullable(this.offerNode);
    }

    @Override
    @JsonProperty(value="Flags")
    public Optional<NfTokenOfferFlags> flags() {
        return Optional.ofNullable(this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withAmount(CurrencyAmount value) {
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        if (this.amount == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(newValue, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withAmount(Optional<? extends CurrencyAmount> optional) {
        CurrencyAmount value = optional.orElse(null);
        if (this.amount == value) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(value, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withOwner(Address value) {
        Address newValue = Objects.requireNonNull(value, "owner");
        if (this.owner == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withOwner(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.owner == value) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, value, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, newValue, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, value, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withPreviousTransactionLedgerSequence(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, newValue, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withPreviousTransactionLedgerSequence(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.previousTransactionLedgerSequence == value) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, value, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withNfTokenId(NfTokenId value) {
        NfTokenId newValue = Objects.requireNonNull(value, "nfTokenId");
        if (this.nfTokenId == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withNfTokenId(Optional<? extends NfTokenId> optional) {
        NfTokenId value = optional.orElse(null);
        if (this.nfTokenId == value) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, value, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withExpiration(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, newValue, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withExpiration(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, value, this.destination, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withDestination(Address value) {
        Address newValue = Objects.requireNonNull(value, "destination");
        if (this.destination == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, newValue, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withDestination(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.destination == value) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, value, this.ownerNode, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, newValue, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, value, this.offerNode, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withOfferNode(String value) {
        String newValue = Objects.requireNonNull(value, "offerNode");
        if (Objects.equals(this.offerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, newValue, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withOfferNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.offerNode, value)) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, value, this.flags);
    }

    public final ImmutableMetaNfTokenOfferObject withFlags(NfTokenOfferFlags value) {
        NfTokenOfferFlags newValue = Objects.requireNonNull(value, "flags");
        if (this.flags == newValue) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, newValue);
    }

    public final ImmutableMetaNfTokenOfferObject withFlags(Optional<? extends NfTokenOfferFlags> optional) {
        NfTokenOfferFlags value = optional.orElse(null);
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaNfTokenOfferObject && this.equalTo(0, (ImmutableMetaNfTokenOfferObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaNfTokenOfferObject another) {
        return Objects.equals(this.amount, another.amount) && Objects.equals(this.owner, another.owner) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence) && Objects.equals(this.nfTokenId, another.nfTokenId) && Objects.equals(this.expiration, another.expiration) && Objects.equals(this.destination, another.destination) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.offerNode, another.offerNode) && Objects.equals(this.flags, another.flags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.amount);
        h += (h << 5) + Objects.hashCode(this.owner);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        h += (h << 5) + Objects.hashCode(this.nfTokenId);
        h += (h << 5) + Objects.hashCode(this.expiration);
        h += (h << 5) + Objects.hashCode(this.destination);
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.offerNode);
        h += (h << 5) + Objects.hashCode(this.flags);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaNfTokenOfferObject").omitNullValues().add("amount", (Object)this.amount).add("owner", (Object)this.owner).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("nfTokenId", (Object)this.nfTokenId).add("expiration", (Object)this.expiration).add("destination", (Object)this.destination).add("ownerNode", (Object)this.ownerNode).add("offerNode", (Object)this.offerNode).add("flags", (Object)this.flags).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaNfTokenOfferObject fromJson(Json json) {
        Builder builder = ImmutableMetaNfTokenOfferObject.builder();
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.owner != null) {
            builder.owner(json.owner);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.nfTokenId != null) {
            builder.nfTokenId(json.nfTokenId);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.offerNode != null) {
            builder.offerNode(json.offerNode);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        return builder.build();
    }

    public static ImmutableMetaNfTokenOfferObject copyOf(MetaNfTokenOfferObject instance) {
        if (instance instanceof ImmutableMetaNfTokenOfferObject) {
            return (ImmutableMetaNfTokenOfferObject)instance;
        }
        return ImmutableMetaNfTokenOfferObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaNfTokenOfferObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private CurrencyAmount amount;
        @Nullable
        private Address owner;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private LedgerIndex previousTransactionLedgerSequence;
        @Nullable
        private NfTokenId nfTokenId;
        @Nullable
        private UnsignedInteger expiration;
        @Nullable
        private Address destination;
        @Nullable
        private String ownerNode;
        @Nullable
        private String offerNode;
        @Nullable
        private NfTokenOfferFlags flags;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaNfTokenOfferObject instance) {
            Optional<NfTokenOfferFlags> flagsOptional;
            Optional<String> offerNodeOptional;
            Optional<String> ownerNodeOptional;
            Optional<Address> destinationOptional;
            Optional<UnsignedInteger> expirationOptional;
            Optional<NfTokenId> nfTokenIdOptional;
            Optional<LedgerIndex> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<Address> ownerOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<CurrencyAmount> amountOptional = instance.amount();
            if (amountOptional.isPresent()) {
                this.amount(amountOptional);
            }
            if ((ownerOptional = instance.owner()).isPresent()) {
                this.owner(ownerOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            if ((nfTokenIdOptional = instance.nfTokenId()).isPresent()) {
                this.nfTokenId(nfTokenIdOptional);
            }
            if ((expirationOptional = instance.expiration()).isPresent()) {
                this.expiration(expirationOptional);
            }
            if ((destinationOptional = instance.destination()).isPresent()) {
                this.destination(destinationOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((offerNodeOptional = instance.offerNode()).isPresent()) {
                this.offerNode(offerNodeOptional);
            }
            if ((flagsOptional = instance.flags()).isPresent()) {
                this.flags(flagsOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder amount(CurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(Optional<? extends CurrencyAmount> amount) {
            this.amount = amount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder owner(Address owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            return this;
        }

        @JsonProperty(value="Owner")
        @CanIgnoreReturnValue
        public final Builder owner(Optional<? extends Address> owner) {
            this.owner = owner.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(LedgerIndex previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = Objects.requireNonNull(nfTokenId, "nfTokenId");
            return this;
        }

        @JsonProperty(value="NFTokenID")
        @CanIgnoreReturnValue
        public final Builder nfTokenId(Optional<? extends NfTokenId> nfTokenId) {
            this.nfTokenId = nfTokenId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedInteger expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedInteger> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Optional<? extends Address> destination) {
            this.destination = destination.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder offerNode(String offerNode) {
            this.offerNode = Objects.requireNonNull(offerNode, "offerNode");
            return this;
        }

        @JsonProperty(value="NFTokenOfferNode")
        @CanIgnoreReturnValue
        public final Builder offerNode(Optional<String> offerNode) {
            this.offerNode = offerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder flags(NfTokenOfferFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(Optional<? extends NfTokenOfferFlags> flags) {
            this.flags = flags.orElse(null);
            return this;
        }

        public ImmutableMetaNfTokenOfferObject build() {
            return new ImmutableMetaNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaNfTokenOfferObject", generator="Immutables")
    static final class Json
    implements MetaNfTokenOfferObject {
        @Nullable
        Optional<CurrencyAmount> amount = Optional.empty();
        @Nullable
        Optional<Address> owner = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<LedgerIndex> previousTransactionLedgerSequence = Optional.empty();
        @Nullable
        Optional<NfTokenId> nfTokenId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> expiration = Optional.empty();
        @Nullable
        Optional<Address> destination = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<String> offerNode = Optional.empty();
        @Nullable
        Optional<NfTokenOfferFlags> flags = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Amount")
        public void setAmount(Optional<CurrencyAmount> amount) {
            this.amount = amount;
        }

        @JsonProperty(value="Owner")
        public void setOwner(Optional<Address> owner) {
            this.owner = owner;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="NFTokenID")
        public void setNfTokenId(Optional<NfTokenId> nfTokenId) {
            this.nfTokenId = nfTokenId;
        }

        @JsonProperty(value="expiration")
        public void setExpiration(Optional<UnsignedInteger> expiration) {
            this.expiration = expiration;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Optional<Address> destination) {
            this.destination = destination;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="NFTokenOfferNode")
        public void setOfferNode(Optional<String> offerNode) {
            this.offerNode = offerNode;
        }

        @JsonProperty(value="Flags")
        public void setFlags(Optional<NfTokenOfferFlags> flags) {
            this.flags = flags;
        }

        @Override
        public Optional<CurrencyAmount> amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> owner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NfTokenId> nfTokenId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> expiration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> offerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NfTokenOfferFlags> flags() {
            throw new UnsupportedOperationException();
        }
    }
}

