/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.DidData;
import org.xrpl.xrpl4j.model.transactions.DidDocument;
import org.xrpl.xrpl4j.model.transactions.DidUri;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaDidObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaDidObject", generator="Immutables")
@Immutable
public final class ImmutableMetaDidObject
implements MetaDidObject {
    private final transient Flags flags;
    @Nullable
    private final Address account;
    @Nullable
    private final DidDocument didDocument;
    @Nullable
    private final DidData data;
    @Nullable
    private final DidUri uri;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final UnsignedInteger previousTransactionLedgerSequence;

    private ImmutableMetaDidObject(@Nullable Address account, @Nullable DidDocument didDocument, @Nullable DidData data, @Nullable DidUri uri, @Nullable String ownerNode, @Nullable Hash256 previousTransactionId, @Nullable UnsignedInteger previousTransactionLedgerSequence) {
        this.account = account;
        this.didDocument = didDocument;
        this.data = data;
        this.uri = uri;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.flags = Objects.requireNonNull(MetaDidObject.super.flags(), "flags");
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="DIDDocument")
    public Optional<DidDocument> didDocument() {
        return Optional.ofNullable(this.didDocument);
    }

    @Override
    @JsonProperty(value="Data")
    public Optional<DidData> data() {
        return Optional.ofNullable(this.data);
    }

    @Override
    @JsonProperty(value="URI")
    public Optional<DidUri> uri() {
        return Optional.ofNullable(this.uri);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<UnsignedInteger> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaDidObject(newValue, this.didDocument, this.data, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaDidObject(value, this.didDocument, this.data, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withDidDocument(DidDocument value) {
        DidDocument newValue = Objects.requireNonNull(value, "didDocument");
        if (this.didDocument == newValue) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, newValue, this.data, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withDidDocument(Optional<? extends DidDocument> optional) {
        DidDocument value = optional.orElse(null);
        if (this.didDocument == value) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, value, this.data, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withData(DidData value) {
        DidData newValue = Objects.requireNonNull(value, "data");
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, this.didDocument, newValue, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withData(Optional<? extends DidData> optional) {
        DidData value = optional.orElse(null);
        if (this.data == value) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, this.didDocument, value, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withUri(DidUri value) {
        DidUri newValue = Objects.requireNonNull(value, "uri");
        if (this.uri == newValue) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, this.didDocument, this.data, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withUri(Optional<? extends DidUri> optional) {
        DidUri value = optional.orElse(null);
        if (this.uri == value) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, this.didDocument, this.data, value, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, this.didDocument, this.data, this.uri, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, this.didDocument, this.data, this.uri, value, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, this.didDocument, this.data, this.uri, this.ownerNode, newValue, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, this.didDocument, this.data, this.uri, this.ownerNode, value, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDidObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (Objects.equals(this.previousTransactionLedgerSequence, newValue)) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, this.didDocument, this.data, this.uri, this.ownerNode, this.previousTransactionId, newValue);
    }

    public final ImmutableMetaDidObject withPreviousTransactionLedgerSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.previousTransactionLedgerSequence, value)) {
            return this;
        }
        return new ImmutableMetaDidObject(this.account, this.didDocument, this.data, this.uri, this.ownerNode, this.previousTransactionId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaDidObject && this.equalTo(0, (ImmutableMetaDidObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaDidObject another) {
        return this.flags.equals(another.flags) && Objects.equals(this.account, another.account) && Objects.equals(this.didDocument, another.didDocument) && Objects.equals(this.data, another.data) && Objects.equals(this.uri, another.uri) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.didDocument);
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + Objects.hashCode(this.uri);
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaDidObject").omitNullValues().add("flags", (Object)this.flags).add("account", (Object)this.account).add("didDocument", (Object)this.didDocument).add("data", (Object)this.data).add("uri", (Object)this.uri).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaDidObject fromJson(Json json) {
        Builder builder = ImmutableMetaDidObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.didDocument != null) {
            builder.didDocument(json.didDocument);
        }
        if (json.data != null) {
            builder.data(json.data);
        }
        if (json.uri != null) {
            builder.uri(json.uri);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        return builder.build();
    }

    public static ImmutableMetaDidObject copyOf(MetaDidObject instance) {
        if (instance instanceof ImmutableMetaDidObject) {
            return (ImmutableMetaDidObject)instance;
        }
        return ImmutableMetaDidObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaDidObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private DidDocument didDocument;
        @Nullable
        private DidData data;
        @Nullable
        private DidUri uri;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaDidObject instance) {
            Optional<UnsignedInteger> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<String> ownerNodeOptional;
            Optional<DidUri> uriOptional;
            Optional<DidData> dataOptional;
            Optional<DidDocument> didDocumentOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((didDocumentOptional = instance.didDocument()).isPresent()) {
                this.didDocument(didDocumentOptional);
            }
            if ((dataOptional = instance.data()).isPresent()) {
                this.data(dataOptional);
            }
            if ((uriOptional = instance.uri()).isPresent()) {
                this.uri(uriOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder didDocument(DidDocument didDocument) {
            this.didDocument = Objects.requireNonNull(didDocument, "didDocument");
            return this;
        }

        @JsonProperty(value="DIDDocument")
        @CanIgnoreReturnValue
        public final Builder didDocument(Optional<? extends DidDocument> didDocument) {
            this.didDocument = didDocument.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder data(DidData data) {
            this.data = Objects.requireNonNull(data, "data");
            return this;
        }

        @JsonProperty(value="Data")
        @CanIgnoreReturnValue
        public final Builder data(Optional<? extends DidData> data) {
            this.data = data.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(DidUri uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            return this;
        }

        @JsonProperty(value="URI")
        @CanIgnoreReturnValue
        public final Builder uri(Optional<? extends DidUri> uri) {
            this.uri = uri.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends UnsignedInteger> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        public ImmutableMetaDidObject build() {
            return new ImmutableMetaDidObject(this.account, this.didDocument, this.data, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaDidObject", generator="Immutables")
    static final class Json
    implements MetaDidObject {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<DidDocument> didDocument = Optional.empty();
        @Nullable
        Optional<DidData> data = Optional.empty();
        @Nullable
        Optional<DidUri> uri = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> previousTransactionLedgerSequence = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="DIDDocument")
        public void setDidDocument(Optional<DidDocument> didDocument) {
            this.didDocument = didDocument;
        }

        @JsonProperty(value="Data")
        public void setData(Optional<DidData> data) {
            this.data = data;
        }

        @JsonProperty(value="URI")
        public void setUri(Optional<DidUri> uri) {
            this.uri = uri;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<UnsignedInteger> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DidDocument> didDocument() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DidData> data() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DidUri> uri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }
    }
}

