/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaDepositPreAuthObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaDepositPreAuthObject", generator="Immutables")
@Immutable
public final class ImmutableMetaDepositPreAuthObject
implements MetaDepositPreAuthObject {
    @Nullable
    private final Address account;
    @Nullable
    private final Address authorize;
    private final transient Flags flags;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final LedgerIndex previousTransactionLedgerSequence;

    private ImmutableMetaDepositPreAuthObject(@Nullable Address account, @Nullable Address authorize, @Nullable String ownerNode, @Nullable Hash256 previousTransactionId, @Nullable LedgerIndex previousTransactionLedgerSequence) {
        this.account = account;
        this.authorize = authorize;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.flags = Objects.requireNonNull(MetaDepositPreAuthObject.super.flags(), "flags");
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="Authorize")
    public Optional<Address> authorize() {
        return Optional.ofNullable(this.authorize);
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDepositPreAuthObject withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaDepositPreAuthObject(newValue, this.authorize, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDepositPreAuthObject withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaDepositPreAuthObject(value, this.authorize, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDepositPreAuthObject withAuthorize(Address value) {
        Address newValue = Objects.requireNonNull(value, "authorize");
        if (this.authorize == newValue) {
            return this;
        }
        return new ImmutableMetaDepositPreAuthObject(this.account, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDepositPreAuthObject withAuthorize(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.authorize == value) {
            return this;
        }
        return new ImmutableMetaDepositPreAuthObject(this.account, value, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDepositPreAuthObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaDepositPreAuthObject(this.account, this.authorize, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDepositPreAuthObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableMetaDepositPreAuthObject(this.account, this.authorize, value, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDepositPreAuthObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaDepositPreAuthObject(this.account, this.authorize, this.ownerNode, newValue, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDepositPreAuthObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaDepositPreAuthObject(this.account, this.authorize, this.ownerNode, value, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaDepositPreAuthObject withPreviousTransactionLedgerSequence(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence == newValue) {
            return this;
        }
        return new ImmutableMetaDepositPreAuthObject(this.account, this.authorize, this.ownerNode, this.previousTransactionId, newValue);
    }

    public final ImmutableMetaDepositPreAuthObject withPreviousTransactionLedgerSequence(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.previousTransactionLedgerSequence == value) {
            return this;
        }
        return new ImmutableMetaDepositPreAuthObject(this.account, this.authorize, this.ownerNode, this.previousTransactionId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaDepositPreAuthObject && this.equalTo(0, (ImmutableMetaDepositPreAuthObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaDepositPreAuthObject another) {
        return Objects.equals(this.account, another.account) && Objects.equals(this.authorize, another.authorize) && this.flags.equals(another.flags) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.authorize);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaDepositPreAuthObject").omitNullValues().add("account", (Object)this.account).add("authorize", (Object)this.authorize).add("flags", (Object)this.flags).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaDepositPreAuthObject fromJson(Json json) {
        Builder builder = ImmutableMetaDepositPreAuthObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.authorize != null) {
            builder.authorize(json.authorize);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        return builder.build();
    }

    public static ImmutableMetaDepositPreAuthObject copyOf(MetaDepositPreAuthObject instance) {
        if (instance instanceof ImmutableMetaDepositPreAuthObject) {
            return (ImmutableMetaDepositPreAuthObject)instance;
        }
        return ImmutableMetaDepositPreAuthObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaDepositPreAuthObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private Address authorize;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private LedgerIndex previousTransactionLedgerSequence;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaDepositPreAuthObject instance) {
            Optional<LedgerIndex> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<String> ownerNodeOptional;
            Optional<Address> authorizeOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((authorizeOptional = instance.authorize()).isPresent()) {
                this.authorize(authorizeOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authorize(Address authorize) {
            this.authorize = Objects.requireNonNull(authorize, "authorize");
            return this;
        }

        @JsonProperty(value="Authorize")
        @CanIgnoreReturnValue
        public final Builder authorize(Optional<? extends Address> authorize) {
            this.authorize = authorize.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(LedgerIndex previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        public ImmutableMetaDepositPreAuthObject build() {
            return new ImmutableMetaDepositPreAuthObject(this.account, this.authorize, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaDepositPreAuthObject", generator="Immutables")
    static final class Json
    implements MetaDepositPreAuthObject {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<Address> authorize = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<LedgerIndex> previousTransactionLedgerSequence = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="Authorize")
        public void setAuthorize(Optional<Address> authorize) {
            this.authorize = authorize;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> authorize() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }
    }
}

