/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaCheckObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaCheckObject", generator="Immutables")
@Immutable
public final class ImmutableMetaCheckObject
implements MetaCheckObject {
    @Nullable
    private final Address account;
    @Nullable
    private final UnsignedInteger sourceTag;
    @Nullable
    private final Address destination;
    @Nullable
    private final UnsignedInteger destinationTag;
    private final transient Flags flags;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final Hash256 previousTxnId;
    @Nullable
    private final LedgerIndex previousTransactionLedgerSequence;
    @Nullable
    private final CurrencyAmount sendMax;
    @Nullable
    private final UnsignedInteger sequence;
    @Nullable
    private final String destinationNode;
    @Nullable
    private final UnsignedInteger expiration;
    @Nullable
    private final Hash256 invoiceId;

    private ImmutableMetaCheckObject(@Nullable Address account, @Nullable UnsignedInteger sourceTag, @Nullable Address destination, @Nullable UnsignedInteger destinationTag, @Nullable String ownerNode, @Nullable Hash256 previousTxnId, @Nullable LedgerIndex previousTransactionLedgerSequence, @Nullable CurrencyAmount sendMax, @Nullable UnsignedInteger sequence, @Nullable String destinationNode, @Nullable UnsignedInteger expiration, @Nullable Hash256 invoiceId) {
        this.account = account;
        this.sourceTag = sourceTag;
        this.destination = destination;
        this.destinationTag = destinationTag;
        this.ownerNode = ownerNode;
        this.previousTxnId = previousTxnId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.sendMax = sendMax;
        this.sequence = sequence;
        this.destinationNode = destinationNode;
        this.expiration = expiration;
        this.invoiceId = invoiceId;
        this.flags = Objects.requireNonNull(MetaCheckObject.super.flags(), "flags");
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag() {
        return Optional.ofNullable(this.sourceTag);
    }

    @Override
    @JsonProperty(value="Destination")
    public Optional<Address> destination() {
        return Optional.ofNullable(this.destination);
    }

    @Override
    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag() {
        return Optional.ofNullable(this.destinationTag);
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTxnId() {
        return Optional.ofNullable(this.previousTxnId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    @Override
    @JsonProperty(value="SendMax")
    public Optional<CurrencyAmount> sendMax() {
        return Optional.ofNullable(this.sendMax);
    }

    @Override
    @JsonProperty(value="Sequence")
    public Optional<UnsignedInteger> sequence() {
        return Optional.ofNullable(this.sequence);
    }

    @Override
    @JsonProperty(value="DestinationNode")
    public Optional<String> destinationNode() {
        return Optional.ofNullable(this.destinationNode);
    }

    @Override
    @JsonProperty(value="Expiration")
    public Optional<UnsignedInteger> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    @Override
    @JsonProperty(value="InvoiceID")
    public Optional<Hash256> invoiceId() {
        return Optional.ofNullable(this.invoiceId);
    }

    public final ImmutableMetaCheckObject withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaCheckObject(newValue, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaCheckObject(value, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withSourceTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sourceTag");
        if (Objects.equals(this.sourceTag, newValue)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, newValue, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withSourceTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sourceTag, value)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, value, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withDestination(Address value) {
        Address newValue = Objects.requireNonNull(value, "destination");
        if (this.destination == newValue) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, newValue, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withDestination(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.destination == value) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, value, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withDestinationTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "destinationTag");
        if (Objects.equals(this.destinationTag, newValue)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, newValue, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withDestinationTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.destinationTag, value)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, value, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, newValue, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, value, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withPreviousTxnId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTxnId");
        if (this.previousTxnId == newValue) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, newValue, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withPreviousTxnId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTxnId == value) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, value, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withPreviousTransactionLedgerSequence(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence == newValue) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, newValue, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withPreviousTransactionLedgerSequence(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.previousTransactionLedgerSequence == value) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, value, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withSendMax(CurrencyAmount value) {
        CurrencyAmount newValue = Objects.requireNonNull(value, "sendMax");
        if (this.sendMax == newValue) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, newValue, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withSendMax(Optional<? extends CurrencyAmount> optional) {
        CurrencyAmount value = optional.orElse(null);
        if (this.sendMax == value) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, value, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (Objects.equals(this.sequence, newValue)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, newValue, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sequence, value)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, value, this.destinationNode, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withDestinationNode(String value) {
        String newValue = Objects.requireNonNull(value, "destinationNode");
        if (Objects.equals(this.destinationNode, newValue)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, newValue, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withDestinationNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.destinationNode, value)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, value, this.expiration, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withExpiration(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, newValue, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withExpiration(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, value, this.invoiceId);
    }

    public final ImmutableMetaCheckObject withInvoiceId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "invoiceId");
        if (this.invoiceId == newValue) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, newValue);
    }

    public final ImmutableMetaCheckObject withInvoiceId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.invoiceId == value) {
            return this;
        }
        return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaCheckObject && this.equalTo(0, (ImmutableMetaCheckObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaCheckObject another) {
        return Objects.equals(this.account, another.account) && Objects.equals(this.sourceTag, another.sourceTag) && Objects.equals(this.destination, another.destination) && Objects.equals(this.destinationTag, another.destinationTag) && this.flags.equals(another.flags) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.previousTxnId, another.previousTxnId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence) && Objects.equals(this.sendMax, another.sendMax) && Objects.equals(this.sequence, another.sequence) && Objects.equals(this.destinationNode, another.destinationNode) && Objects.equals(this.expiration, another.expiration) && Objects.equals(this.invoiceId, another.invoiceId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.sourceTag);
        h += (h << 5) + Objects.hashCode(this.destination);
        h += (h << 5) + Objects.hashCode(this.destinationTag);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.previousTxnId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        h += (h << 5) + Objects.hashCode(this.sendMax);
        h += (h << 5) + Objects.hashCode(this.sequence);
        h += (h << 5) + Objects.hashCode(this.destinationNode);
        h += (h << 5) + Objects.hashCode(this.expiration);
        h += (h << 5) + Objects.hashCode(this.invoiceId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaCheckObject").omitNullValues().add("account", (Object)this.account).add("sourceTag", (Object)this.sourceTag).add("destination", (Object)this.destination).add("destinationTag", (Object)this.destinationTag).add("flags", (Object)this.flags).add("ownerNode", (Object)this.ownerNode).add("previousTxnId", (Object)this.previousTxnId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("sendMax", (Object)this.sendMax).add("sequence", (Object)this.sequence).add("destinationNode", (Object)this.destinationNode).add("expiration", (Object)this.expiration).add("invoiceId", (Object)this.invoiceId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaCheckObject fromJson(Json json) {
        Builder builder = ImmutableMetaCheckObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.sourceTag != null) {
            builder.sourceTag(json.sourceTag);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.destinationTag != null) {
            builder.destinationTag(json.destinationTag);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTxnId != null) {
            builder.previousTxnId(json.previousTxnId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.sendMax != null) {
            builder.sendMax(json.sendMax);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.destinationNode != null) {
            builder.destinationNode(json.destinationNode);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        if (json.invoiceId != null) {
            builder.invoiceId(json.invoiceId);
        }
        return builder.build();
    }

    public static ImmutableMetaCheckObject copyOf(MetaCheckObject instance) {
        if (instance instanceof ImmutableMetaCheckObject) {
            return (ImmutableMetaCheckObject)instance;
        }
        return ImmutableMetaCheckObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaCheckObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private UnsignedInteger sourceTag;
        @Nullable
        private Address destination;
        @Nullable
        private UnsignedInteger destinationTag;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTxnId;
        @Nullable
        private LedgerIndex previousTransactionLedgerSequence;
        @Nullable
        private CurrencyAmount sendMax;
        @Nullable
        private UnsignedInteger sequence;
        @Nullable
        private String destinationNode;
        @Nullable
        private UnsignedInteger expiration;
        @Nullable
        private Hash256 invoiceId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaCheckObject instance) {
            Optional<Hash256> invoiceIdOptional;
            Optional<UnsignedInteger> expirationOptional;
            Optional<String> destinationNodeOptional;
            Optional<UnsignedInteger> sequenceOptional;
            Optional<CurrencyAmount> sendMaxOptional;
            Optional<LedgerIndex> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTxnIdOptional;
            Optional<String> ownerNodeOptional;
            Optional<UnsignedInteger> destinationTagOptional;
            Optional<Address> destinationOptional;
            Optional<UnsignedInteger> sourceTagOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((sourceTagOptional = instance.sourceTag()).isPresent()) {
                this.sourceTag(sourceTagOptional);
            }
            if ((destinationOptional = instance.destination()).isPresent()) {
                this.destination(destinationOptional);
            }
            if ((destinationTagOptional = instance.destinationTag()).isPresent()) {
                this.destinationTag(destinationTagOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((previousTxnIdOptional = instance.previousTxnId()).isPresent()) {
                this.previousTxnId(previousTxnIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            if ((sendMaxOptional = instance.sendMax()).isPresent()) {
                this.sendMax(sendMaxOptional);
            }
            if ((sequenceOptional = instance.sequence()).isPresent()) {
                this.sequence(sequenceOptional);
            }
            if ((destinationNodeOptional = instance.destinationNode()).isPresent()) {
                this.destinationNode(destinationNodeOptional);
            }
            if ((expirationOptional = instance.expiration()).isPresent()) {
                this.expiration(expirationOptional);
            }
            if ((invoiceIdOptional = instance.invoiceId()).isPresent()) {
                this.invoiceId(invoiceIdOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceTag(UnsignedInteger sourceTag) {
            this.sourceTag = Objects.requireNonNull(sourceTag, "sourceTag");
            return this;
        }

        @JsonProperty(value="SourceTag")
        @CanIgnoreReturnValue
        public final Builder sourceTag(Optional<? extends UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Optional<? extends Address> destination) {
            this.destination = destination.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationTag(UnsignedInteger destinationTag) {
            this.destinationTag = Objects.requireNonNull(destinationTag, "destinationTag");
            return this;
        }

        @JsonProperty(value="DestinationTag")
        @CanIgnoreReturnValue
        public final Builder destinationTag(Optional<? extends UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTxnId(Hash256 previousTxnId) {
            this.previousTxnId = Objects.requireNonNull(previousTxnId, "previousTxnId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTxnId(Optional<? extends Hash256> previousTxnId) {
            this.previousTxnId = previousTxnId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(LedgerIndex previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sendMax(CurrencyAmount sendMax) {
            this.sendMax = Objects.requireNonNull(sendMax, "sendMax");
            return this;
        }

        @JsonProperty(value="SendMax")
        @CanIgnoreReturnValue
        public final Builder sendMax(Optional<? extends CurrencyAmount> sendMax) {
            this.sendMax = sendMax.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            return this;
        }

        @JsonProperty(value="Sequence")
        @CanIgnoreReturnValue
        public final Builder sequence(Optional<? extends UnsignedInteger> sequence) {
            this.sequence = sequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationNode(String destinationNode) {
            this.destinationNode = Objects.requireNonNull(destinationNode, "destinationNode");
            return this;
        }

        @JsonProperty(value="DestinationNode")
        @CanIgnoreReturnValue
        public final Builder destinationNode(Optional<String> destinationNode) {
            this.destinationNode = destinationNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedInteger expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="Expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedInteger> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder invoiceId(Hash256 invoiceId) {
            this.invoiceId = Objects.requireNonNull(invoiceId, "invoiceId");
            return this;
        }

        @JsonProperty(value="InvoiceID")
        @CanIgnoreReturnValue
        public final Builder invoiceId(Optional<? extends Hash256> invoiceId) {
            this.invoiceId = invoiceId.orElse(null);
            return this;
        }

        public ImmutableMetaCheckObject build() {
            return new ImmutableMetaCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaCheckObject", generator="Immutables")
    static final class Json
    implements MetaCheckObject {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> sourceTag = Optional.empty();
        @Nullable
        Optional<Address> destination = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> destinationTag = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<Hash256> previousTxnId = Optional.empty();
        @Nullable
        Optional<LedgerIndex> previousTransactionLedgerSequence = Optional.empty();
        @Nullable
        Optional<CurrencyAmount> sendMax = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> sequence = Optional.empty();
        @Nullable
        Optional<String> destinationNode = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> expiration = Optional.empty();
        @Nullable
        Optional<Hash256> invoiceId = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="SourceTag")
        public void setSourceTag(Optional<UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Optional<Address> destination) {
            this.destination = destination;
        }

        @JsonProperty(value="DestinationTag")
        public void setDestinationTag(Optional<UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTxnId(Optional<Hash256> previousTxnId) {
            this.previousTxnId = previousTxnId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="SendMax")
        public void setSendMax(Optional<CurrencyAmount> sendMax) {
            this.sendMax = sendMax;
        }

        @JsonProperty(value="Sequence")
        public void setSequence(Optional<UnsignedInteger> sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="DestinationNode")
        public void setDestinationNode(Optional<String> destinationNode) {
            this.destinationNode = destinationNode;
        }

        @JsonProperty(value="Expiration")
        public void setExpiration(Optional<UnsignedInteger> expiration) {
            this.expiration = expiration;
        }

        @JsonProperty(value="InvoiceID")
        public void setInvoiceId(Optional<Hash256> invoiceId) {
            this.invoiceId = invoiceId;
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sourceTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> destinationTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTxnId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CurrencyAmount> sendMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> destinationNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> expiration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> invoiceId() {
            throw new UnsupportedOperationException();
        }
    }
}

