/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;
import org.xrpl.xrpl4j.model.transactions.XChainClaimId;
import org.xrpl.xrpl4j.model.transactions.XChainCount;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaBridgeObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaBridgeObject", generator="Immutables")
@Immutable
public final class ImmutableMetaBridgeObject
implements MetaBridgeObject {
    private final transient Flags flags;
    @Nullable
    private final Address account;
    @Nullable
    private final XrpCurrencyAmount minAccountCreateAmount;
    @Nullable
    private final XrpCurrencyAmount signatureReward;
    @Nullable
    private final XChainBridge xChainBridge;
    @Nullable
    private final XChainClaimId xChainClaimId;
    @Nullable
    private final XChainCount xChainAccountCreateCount;
    @Nullable
    private final XChainCount xChainAccountClaimCount;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final UnsignedInteger previousTransactionLedgerSequence;

    private ImmutableMetaBridgeObject(@Nullable Address account, @Nullable XrpCurrencyAmount minAccountCreateAmount, @Nullable XrpCurrencyAmount signatureReward, @Nullable XChainBridge xChainBridge, @Nullable XChainClaimId xChainClaimId, @Nullable XChainCount xChainAccountCreateCount, @Nullable XChainCount xChainAccountClaimCount, @Nullable String ownerNode, @Nullable Hash256 previousTransactionId, @Nullable UnsignedInteger previousTransactionLedgerSequence) {
        this.account = account;
        this.minAccountCreateAmount = minAccountCreateAmount;
        this.signatureReward = signatureReward;
        this.xChainBridge = xChainBridge;
        this.xChainClaimId = xChainClaimId;
        this.xChainAccountCreateCount = xChainAccountCreateCount;
        this.xChainAccountClaimCount = xChainAccountClaimCount;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.flags = Objects.requireNonNull(MetaBridgeObject.super.flags(), "flags");
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="MinAccountCreateAmount")
    public Optional<XrpCurrencyAmount> minAccountCreateAmount() {
        return Optional.ofNullable(this.minAccountCreateAmount);
    }

    @Override
    @JsonProperty(value="SignatureReward")
    public Optional<XrpCurrencyAmount> signatureReward() {
        return Optional.ofNullable(this.signatureReward);
    }

    @Override
    @JsonProperty(value="XChainBridge")
    public Optional<XChainBridge> xChainBridge() {
        return Optional.ofNullable(this.xChainBridge);
    }

    @Override
    @JsonProperty(value="XChainClaimID")
    public Optional<XChainClaimId> xChainClaimId() {
        return Optional.ofNullable(this.xChainClaimId);
    }

    @Override
    @JsonProperty(value="XChainAccountCreateCount")
    public Optional<XChainCount> xChainAccountCreateCount() {
        return Optional.ofNullable(this.xChainAccountCreateCount);
    }

    @Override
    @JsonProperty(value="XChainAccountClaimCount")
    public Optional<XChainCount> xChainAccountClaimCount() {
        return Optional.ofNullable(this.xChainAccountClaimCount);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<UnsignedInteger> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaBridgeObject(newValue, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaBridgeObject(value, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withMinAccountCreateAmount(XrpCurrencyAmount value) {
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "minAccountCreateAmount");
        if (this.minAccountCreateAmount == newValue) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, newValue, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withMinAccountCreateAmount(Optional<? extends XrpCurrencyAmount> optional) {
        XrpCurrencyAmount value = optional.orElse(null);
        if (this.minAccountCreateAmount == value) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, value, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withSignatureReward(XrpCurrencyAmount value) {
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "signatureReward");
        if (this.signatureReward == newValue) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, newValue, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withSignatureReward(Optional<? extends XrpCurrencyAmount> optional) {
        XrpCurrencyAmount value = optional.orElse(null);
        if (this.signatureReward == value) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, value, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withXChainBridge(XChainBridge value) {
        XChainBridge newValue = Objects.requireNonNull(value, "xChainBridge");
        if (this.xChainBridge == newValue) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, newValue, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withXChainBridge(Optional<? extends XChainBridge> optional) {
        XChainBridge value = optional.orElse(null);
        if (this.xChainBridge == value) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, value, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withXChainClaimId(XChainClaimId value) {
        XChainClaimId newValue = Objects.requireNonNull(value, "xChainClaimId");
        if (this.xChainClaimId == newValue) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, newValue, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withXChainClaimId(Optional<? extends XChainClaimId> optional) {
        XChainClaimId value = optional.orElse(null);
        if (this.xChainClaimId == value) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, value, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withXChainAccountCreateCount(XChainCount value) {
        XChainCount newValue = Objects.requireNonNull(value, "xChainAccountCreateCount");
        if (this.xChainAccountCreateCount == newValue) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, newValue, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withXChainAccountCreateCount(Optional<? extends XChainCount> optional) {
        XChainCount value = optional.orElse(null);
        if (this.xChainAccountCreateCount == value) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, value, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withXChainAccountClaimCount(XChainCount value) {
        XChainCount newValue = Objects.requireNonNull(value, "xChainAccountClaimCount");
        if (this.xChainAccountClaimCount == newValue) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withXChainAccountClaimCount(Optional<? extends XChainCount> optional) {
        XChainCount value = optional.orElse(null);
        if (this.xChainAccountClaimCount == value) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, value, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, value, this.previousTransactionId, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, newValue, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, value, this.previousTransactionLedgerSequence);
    }

    public final ImmutableMetaBridgeObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (Objects.equals(this.previousTransactionLedgerSequence, newValue)) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, newValue);
    }

    public final ImmutableMetaBridgeObject withPreviousTransactionLedgerSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.previousTransactionLedgerSequence, value)) {
            return this;
        }
        return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaBridgeObject && this.equalTo(0, (ImmutableMetaBridgeObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaBridgeObject another) {
        return this.flags.equals(another.flags) && Objects.equals(this.account, another.account) && Objects.equals(this.minAccountCreateAmount, another.minAccountCreateAmount) && Objects.equals(this.signatureReward, another.signatureReward) && Objects.equals(this.xChainBridge, another.xChainBridge) && Objects.equals(this.xChainClaimId, another.xChainClaimId) && Objects.equals(this.xChainAccountCreateCount, another.xChainAccountCreateCount) && Objects.equals(this.xChainAccountClaimCount, another.xChainAccountClaimCount) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.minAccountCreateAmount);
        h += (h << 5) + Objects.hashCode(this.signatureReward);
        h += (h << 5) + Objects.hashCode(this.xChainBridge);
        h += (h << 5) + Objects.hashCode(this.xChainClaimId);
        h += (h << 5) + Objects.hashCode(this.xChainAccountCreateCount);
        h += (h << 5) + Objects.hashCode(this.xChainAccountClaimCount);
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaBridgeObject").omitNullValues().add("flags", (Object)this.flags).add("account", (Object)this.account).add("minAccountCreateAmount", (Object)this.minAccountCreateAmount).add("signatureReward", (Object)this.signatureReward).add("xChainBridge", (Object)this.xChainBridge).add("xChainClaimId", (Object)this.xChainClaimId).add("xChainAccountCreateCount", (Object)this.xChainAccountCreateCount).add("xChainAccountClaimCount", (Object)this.xChainAccountClaimCount).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaBridgeObject fromJson(Json json) {
        Builder builder = ImmutableMetaBridgeObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.minAccountCreateAmount != null) {
            builder.minAccountCreateAmount(json.minAccountCreateAmount);
        }
        if (json.signatureReward != null) {
            builder.signatureReward(json.signatureReward);
        }
        if (json.xChainBridge != null) {
            builder.xChainBridge(json.xChainBridge);
        }
        if (json.xChainClaimId != null) {
            builder.xChainClaimId(json.xChainClaimId);
        }
        if (json.xChainAccountCreateCount != null) {
            builder.xChainAccountCreateCount(json.xChainAccountCreateCount);
        }
        if (json.xChainAccountClaimCount != null) {
            builder.xChainAccountClaimCount(json.xChainAccountClaimCount);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        return builder.build();
    }

    public static ImmutableMetaBridgeObject copyOf(MetaBridgeObject instance) {
        if (instance instanceof ImmutableMetaBridgeObject) {
            return (ImmutableMetaBridgeObject)instance;
        }
        return ImmutableMetaBridgeObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaBridgeObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private XrpCurrencyAmount minAccountCreateAmount;
        @Nullable
        private XrpCurrencyAmount signatureReward;
        @Nullable
        private XChainBridge xChainBridge;
        @Nullable
        private XChainClaimId xChainClaimId;
        @Nullable
        private XChainCount xChainAccountCreateCount;
        @Nullable
        private XChainCount xChainAccountClaimCount;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaBridgeObject instance) {
            Optional<UnsignedInteger> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<String> ownerNodeOptional;
            Optional<XChainCount> xChainAccountClaimCountOptional;
            Optional<XChainCount> xChainAccountCreateCountOptional;
            Optional<XChainClaimId> xChainClaimIdOptional;
            Optional<XChainBridge> xChainBridgeOptional;
            Optional<XrpCurrencyAmount> signatureRewardOptional;
            Optional<XrpCurrencyAmount> minAccountCreateAmountOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((minAccountCreateAmountOptional = instance.minAccountCreateAmount()).isPresent()) {
                this.minAccountCreateAmount(minAccountCreateAmountOptional);
            }
            if ((signatureRewardOptional = instance.signatureReward()).isPresent()) {
                this.signatureReward(signatureRewardOptional);
            }
            if ((xChainBridgeOptional = instance.xChainBridge()).isPresent()) {
                this.xChainBridge(xChainBridgeOptional);
            }
            if ((xChainClaimIdOptional = instance.xChainClaimId()).isPresent()) {
                this.xChainClaimId(xChainClaimIdOptional);
            }
            if ((xChainAccountCreateCountOptional = instance.xChainAccountCreateCount()).isPresent()) {
                this.xChainAccountCreateCount(xChainAccountCreateCountOptional);
            }
            if ((xChainAccountClaimCountOptional = instance.xChainAccountClaimCount()).isPresent()) {
                this.xChainAccountClaimCount(xChainAccountClaimCountOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minAccountCreateAmount(XrpCurrencyAmount minAccountCreateAmount) {
            this.minAccountCreateAmount = Objects.requireNonNull(minAccountCreateAmount, "minAccountCreateAmount");
            return this;
        }

        @JsonProperty(value="MinAccountCreateAmount")
        @CanIgnoreReturnValue
        public final Builder minAccountCreateAmount(Optional<? extends XrpCurrencyAmount> minAccountCreateAmount) {
            this.minAccountCreateAmount = minAccountCreateAmount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = Objects.requireNonNull(signatureReward, "signatureReward");
            return this;
        }

        @JsonProperty(value="SignatureReward")
        @CanIgnoreReturnValue
        public final Builder signatureReward(Optional<? extends XrpCurrencyAmount> signatureReward) {
            this.signatureReward = signatureReward.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = Objects.requireNonNull(xChainBridge, "xChainBridge");
            return this;
        }

        @JsonProperty(value="XChainBridge")
        @CanIgnoreReturnValue
        public final Builder xChainBridge(Optional<? extends XChainBridge> xChainBridge) {
            this.xChainBridge = xChainBridge.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xChainClaimId(XChainClaimId xChainClaimId) {
            this.xChainClaimId = Objects.requireNonNull(xChainClaimId, "xChainClaimId");
            return this;
        }

        @JsonProperty(value="XChainClaimID")
        @CanIgnoreReturnValue
        public final Builder xChainClaimId(Optional<? extends XChainClaimId> xChainClaimId) {
            this.xChainClaimId = xChainClaimId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xChainAccountCreateCount(XChainCount xChainAccountCreateCount) {
            this.xChainAccountCreateCount = Objects.requireNonNull(xChainAccountCreateCount, "xChainAccountCreateCount");
            return this;
        }

        @JsonProperty(value="XChainAccountCreateCount")
        @CanIgnoreReturnValue
        public final Builder xChainAccountCreateCount(Optional<? extends XChainCount> xChainAccountCreateCount) {
            this.xChainAccountCreateCount = xChainAccountCreateCount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xChainAccountClaimCount(XChainCount xChainAccountClaimCount) {
            this.xChainAccountClaimCount = Objects.requireNonNull(xChainAccountClaimCount, "xChainAccountClaimCount");
            return this;
        }

        @JsonProperty(value="XChainAccountClaimCount")
        @CanIgnoreReturnValue
        public final Builder xChainAccountClaimCount(Optional<? extends XChainCount> xChainAccountClaimCount) {
            this.xChainAccountClaimCount = xChainAccountClaimCount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends UnsignedInteger> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        public ImmutableMetaBridgeObject build() {
            return new ImmutableMetaBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaBridgeObject", generator="Immutables")
    static final class Json
    implements MetaBridgeObject {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<XrpCurrencyAmount> minAccountCreateAmount = Optional.empty();
        @Nullable
        Optional<XrpCurrencyAmount> signatureReward = Optional.empty();
        @Nullable
        Optional<XChainBridge> xChainBridge = Optional.empty();
        @Nullable
        Optional<XChainClaimId> xChainClaimId = Optional.empty();
        @Nullable
        Optional<XChainCount> xChainAccountCreateCount = Optional.empty();
        @Nullable
        Optional<XChainCount> xChainAccountClaimCount = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> previousTransactionLedgerSequence = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="MinAccountCreateAmount")
        public void setMinAccountCreateAmount(Optional<XrpCurrencyAmount> minAccountCreateAmount) {
            this.minAccountCreateAmount = minAccountCreateAmount;
        }

        @JsonProperty(value="SignatureReward")
        public void setSignatureReward(Optional<XrpCurrencyAmount> signatureReward) {
            this.signatureReward = signatureReward;
        }

        @JsonProperty(value="XChainBridge")
        public void setXChainBridge(Optional<XChainBridge> xChainBridge) {
            this.xChainBridge = xChainBridge;
        }

        @JsonProperty(value="XChainClaimID")
        public void setXChainClaimId(Optional<XChainClaimId> xChainClaimId) {
            this.xChainClaimId = xChainClaimId;
        }

        @JsonProperty(value="XChainAccountCreateCount")
        public void setXChainAccountCreateCount(Optional<XChainCount> xChainAccountCreateCount) {
            this.xChainAccountCreateCount = xChainAccountCreateCount;
        }

        @JsonProperty(value="XChainAccountClaimCount")
        public void setXChainAccountClaimCount(Optional<XChainCount> xChainAccountClaimCount) {
            this.xChainAccountClaimCount = xChainAccountClaimCount;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<UnsignedInteger> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XrpCurrencyAmount> minAccountCreateAmount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XrpCurrencyAmount> signatureReward() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XChainBridge> xChainBridge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XChainClaimId> xChainClaimId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XChainCount> xChainAccountCreateCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XChainCount> xChainAccountClaimCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }
    }
}

