/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaAuctionSlot;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaAuthAccountWrapper;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaAuctionSlot", generator="Immutables")
@Immutable
public final class ImmutableMetaAuctionSlot
implements MetaAuctionSlot {
    @Nullable
    private final Address account;
    private final ImmutableList<MetaAuthAccountWrapper> authAccounts;
    private final transient List<Address> authAccountsAddresses;
    @Nullable
    private final TradingFee discountedFee;
    @Nullable
    private final IssuedCurrencyAmount price;
    @Nullable
    private final UnsignedInteger expiration;

    private ImmutableMetaAuctionSlot(@Nullable Address account, ImmutableList<MetaAuthAccountWrapper> authAccounts, @Nullable TradingFee discountedFee, @Nullable IssuedCurrencyAmount price, @Nullable UnsignedInteger expiration) {
        this.account = account;
        this.authAccounts = authAccounts;
        this.discountedFee = discountedFee;
        this.price = price;
        this.expiration = expiration;
        this.authAccountsAddresses = Objects.requireNonNull(MetaAuctionSlot.super.authAccountsAddresses(), "authAccountsAddresses");
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @JsonProperty(value="AuthAccounts")
    public ImmutableList<MetaAuthAccountWrapper> authAccounts() {
        return this.authAccounts;
    }

    @Override
    @JsonProperty(value="authAccountsAddresses")
    @JsonIgnore
    public List<Address> authAccountsAddresses() {
        return this.authAccountsAddresses;
    }

    @Override
    @JsonProperty(value="DiscountedFee")
    public Optional<TradingFee> discountedFee() {
        return Optional.ofNullable(this.discountedFee);
    }

    @Override
    @JsonProperty(value="Price")
    public Optional<IssuedCurrencyAmount> price() {
        return Optional.ofNullable(this.price);
    }

    @Override
    @JsonProperty(value="Expiration")
    public Optional<UnsignedInteger> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    public final ImmutableMetaAuctionSlot withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaAuctionSlot(newValue, this.authAccounts, this.discountedFee, this.price, this.expiration);
    }

    public final ImmutableMetaAuctionSlot withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaAuctionSlot(value, this.authAccounts, this.discountedFee, this.price, this.expiration);
    }

    public final ImmutableMetaAuctionSlot withAuthAccounts(MetaAuthAccountWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMetaAuctionSlot(this.account, (ImmutableList<MetaAuthAccountWrapper>)newValue, this.discountedFee, this.price, this.expiration);
    }

    public final ImmutableMetaAuctionSlot withAuthAccounts(Iterable<? extends MetaAuthAccountWrapper> elements) {
        if (this.authAccounts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetaAuctionSlot(this.account, (ImmutableList<MetaAuthAccountWrapper>)newValue, this.discountedFee, this.price, this.expiration);
    }

    public final ImmutableMetaAuctionSlot withDiscountedFee(TradingFee value) {
        TradingFee newValue = Objects.requireNonNull(value, "discountedFee");
        if (this.discountedFee == newValue) {
            return this;
        }
        return new ImmutableMetaAuctionSlot(this.account, this.authAccounts, newValue, this.price, this.expiration);
    }

    public final ImmutableMetaAuctionSlot withDiscountedFee(Optional<? extends TradingFee> optional) {
        TradingFee value = optional.orElse(null);
        if (this.discountedFee == value) {
            return this;
        }
        return new ImmutableMetaAuctionSlot(this.account, this.authAccounts, value, this.price, this.expiration);
    }

    public final ImmutableMetaAuctionSlot withPrice(IssuedCurrencyAmount value) {
        IssuedCurrencyAmount newValue = Objects.requireNonNull(value, "price");
        if (this.price == newValue) {
            return this;
        }
        return new ImmutableMetaAuctionSlot(this.account, this.authAccounts, this.discountedFee, newValue, this.expiration);
    }

    public final ImmutableMetaAuctionSlot withPrice(Optional<? extends IssuedCurrencyAmount> optional) {
        IssuedCurrencyAmount value = optional.orElse(null);
        if (this.price == value) {
            return this;
        }
        return new ImmutableMetaAuctionSlot(this.account, this.authAccounts, this.discountedFee, value, this.expiration);
    }

    public final ImmutableMetaAuctionSlot withExpiration(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutableMetaAuctionSlot(this.account, this.authAccounts, this.discountedFee, this.price, newValue);
    }

    public final ImmutableMetaAuctionSlot withExpiration(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutableMetaAuctionSlot(this.account, this.authAccounts, this.discountedFee, this.price, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaAuctionSlot && this.equalTo(0, (ImmutableMetaAuctionSlot)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaAuctionSlot another) {
        return Objects.equals(this.account, another.account) && this.authAccounts.equals(another.authAccounts) && this.authAccountsAddresses.equals(another.authAccountsAddresses) && Objects.equals(this.discountedFee, another.discountedFee) && Objects.equals(this.price, another.price) && Objects.equals(this.expiration, another.expiration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + this.authAccounts.hashCode();
        h += (h << 5) + this.authAccountsAddresses.hashCode();
        h += (h << 5) + Objects.hashCode(this.discountedFee);
        h += (h << 5) + Objects.hashCode(this.price);
        h += (h << 5) + Objects.hashCode(this.expiration);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaAuctionSlot").omitNullValues().add("account", (Object)this.account).add("authAccounts", this.authAccounts).add("authAccountsAddresses", this.authAccountsAddresses).add("discountedFee", (Object)this.discountedFee).add("price", (Object)this.price).add("expiration", (Object)this.expiration).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaAuctionSlot fromJson(Json json) {
        Builder builder = ImmutableMetaAuctionSlot.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.authAccounts != null) {
            builder.addAllAuthAccounts(json.authAccounts);
        }
        if (json.discountedFee != null) {
            builder.discountedFee(json.discountedFee);
        }
        if (json.price != null) {
            builder.price(json.price);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        return builder.build();
    }

    public static ImmutableMetaAuctionSlot copyOf(MetaAuctionSlot instance) {
        if (instance instanceof ImmutableMetaAuctionSlot) {
            return (ImmutableMetaAuctionSlot)instance;
        }
        return ImmutableMetaAuctionSlot.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaAuctionSlot", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        private ImmutableList.Builder<MetaAuthAccountWrapper> authAccounts = ImmutableList.builder();
        @Nullable
        private TradingFee discountedFee;
        @Nullable
        private IssuedCurrencyAmount price;
        @Nullable
        private UnsignedInteger expiration;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaAuctionSlot instance) {
            Optional<UnsignedInteger> expirationOptional;
            Optional<IssuedCurrencyAmount> priceOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            this.addAllAuthAccounts(instance.authAccounts());
            Optional<TradingFee> discountedFeeOptional = instance.discountedFee();
            if (discountedFeeOptional.isPresent()) {
                this.discountedFee(discountedFeeOptional);
            }
            if ((priceOptional = instance.price()).isPresent()) {
                this.price(priceOptional);
            }
            if ((expirationOptional = instance.expiration()).isPresent()) {
                this.expiration(expirationOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAuthAccounts(MetaAuthAccountWrapper element) {
            this.authAccounts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAuthAccounts(MetaAuthAccountWrapper ... elements) {
            this.authAccounts.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="AuthAccounts")
        @CanIgnoreReturnValue
        public final Builder authAccounts(Iterable<? extends MetaAuthAccountWrapper> elements) {
            this.authAccounts = ImmutableList.builder();
            return this.addAllAuthAccounts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAuthAccounts(Iterable<? extends MetaAuthAccountWrapper> elements) {
            this.authAccounts.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder discountedFee(TradingFee discountedFee) {
            this.discountedFee = Objects.requireNonNull(discountedFee, "discountedFee");
            return this;
        }

        @JsonProperty(value="DiscountedFee")
        @CanIgnoreReturnValue
        public final Builder discountedFee(Optional<? extends TradingFee> discountedFee) {
            this.discountedFee = discountedFee.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder price(IssuedCurrencyAmount price) {
            this.price = Objects.requireNonNull(price, "price");
            return this;
        }

        @JsonProperty(value="Price")
        @CanIgnoreReturnValue
        public final Builder price(Optional<? extends IssuedCurrencyAmount> price) {
            this.price = price.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedInteger expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="Expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedInteger> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        public ImmutableMetaAuctionSlot build() {
            return new ImmutableMetaAuctionSlot(this.account, this.authAccounts.build(), this.discountedFee, this.price, this.expiration);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaAuctionSlot", generator="Immutables")
    static final class Json
    implements MetaAuctionSlot {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        List<MetaAuthAccountWrapper> authAccounts = ImmutableList.of();
        @Nullable
        Optional<TradingFee> discountedFee = Optional.empty();
        @Nullable
        Optional<IssuedCurrencyAmount> price = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> expiration = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="AuthAccounts")
        public void setAuthAccounts(List<MetaAuthAccountWrapper> authAccounts) {
            this.authAccounts = authAccounts;
        }

        @JsonProperty(value="DiscountedFee")
        public void setDiscountedFee(Optional<TradingFee> discountedFee) {
            this.discountedFee = discountedFee;
        }

        @JsonProperty(value="Price")
        public void setPrice(Optional<IssuedCurrencyAmount> price) {
            this.price = price;
        }

        @JsonProperty(value="Expiration")
        public void setExpiration(Optional<UnsignedInteger> expiration) {
            this.expiration = expiration;
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MetaAuthAccountWrapper> authAccounts() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public List<Address> authAccountsAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TradingFee> discountedFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<IssuedCurrencyAmount> price() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> expiration() {
            throw new UnsupportedOperationException();
        }
    }
}

