/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.Issue;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaAmmObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaAuctionSlot;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaVoteEntry;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaVoteEntryWrapper;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaAmmObject", generator="Immutables")
@Immutable
public final class ImmutableMetaAmmObject
implements MetaAmmObject {
    private final transient Flags flags;
    @Nullable
    private final Issue asset;
    @Nullable
    private final Issue asset2;
    @Nullable
    private final Address account;
    @Nullable
    private final MetaAuctionSlot auctionSlot;
    @Nullable
    private final IssuedCurrencyAmount lpTokenBalance;
    @Nullable
    private final TradingFee tradingFee;
    private final ImmutableList<MetaVoteEntryWrapper> voteSlots;
    private final transient List<MetaVoteEntry> voteSlotsUnwrapped;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMetaAmmObject(@Nullable Issue asset, @Nullable Issue asset2, @Nullable Address account, @Nullable MetaAuctionSlot auctionSlot, @Nullable IssuedCurrencyAmount lpTokenBalance, @Nullable TradingFee tradingFee, ImmutableList<MetaVoteEntryWrapper> voteSlots) {
        this.asset = asset;
        this.asset2 = asset2;
        this.account = account;
        this.auctionSlot = auctionSlot;
        this.lpTokenBalance = lpTokenBalance;
        this.tradingFee = tradingFee;
        this.voteSlots = voteSlots;
        this.flags = this.initShim.flags();
        this.voteSlotsUnwrapped = this.initShim.voteSlotsUnwrapped();
        this.initShim = null;
    }

    private Flags flagsInitialize() {
        return MetaAmmObject.super.flags();
    }

    private List<MetaVoteEntry> voteSlotsUnwrappedInitialize() {
        return MetaAmmObject.super.voteSlotsUnwrapped();
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @JsonProperty(value="Asset")
    public Optional<Issue> asset() {
        return Optional.ofNullable(this.asset);
    }

    @Override
    @JsonProperty(value="Asset2")
    public Optional<Issue> asset2() {
        return Optional.ofNullable(this.asset2);
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="AuctionSlot")
    public Optional<MetaAuctionSlot> auctionSlot() {
        return Optional.ofNullable(this.auctionSlot);
    }

    @Override
    @JsonProperty(value="LPTokenBalance")
    public Optional<IssuedCurrencyAmount> lpTokenBalance() {
        return Optional.ofNullable(this.lpTokenBalance);
    }

    @Override
    @JsonProperty(value="TradingFee")
    public Optional<TradingFee> tradingFee() {
        return Optional.ofNullable(this.tradingFee);
    }

    @JsonProperty(value="VoteSlots")
    public ImmutableList<MetaVoteEntryWrapper> voteSlots() {
        return this.voteSlots;
    }

    @Override
    @JsonProperty(value="voteSlotsUnwrapped")
    @JsonIgnore
    public List<MetaVoteEntry> voteSlotsUnwrapped() {
        InitShim shim = this.initShim;
        return shim != null ? shim.voteSlotsUnwrapped() : this.voteSlotsUnwrapped;
    }

    public final ImmutableMetaAmmObject withAsset(Issue value) {
        Issue newValue = Objects.requireNonNull(value, "asset");
        if (this.asset == newValue) {
            return this;
        }
        return new ImmutableMetaAmmObject(newValue, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withAsset(Optional<? extends Issue> optional) {
        Issue value = optional.orElse(null);
        if (this.asset == value) {
            return this;
        }
        return new ImmutableMetaAmmObject(value, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withAsset2(Issue value) {
        Issue newValue = Objects.requireNonNull(value, "asset2");
        if (this.asset2 == newValue) {
            return this;
        }
        return new ImmutableMetaAmmObject(this.asset, newValue, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withAsset2(Optional<? extends Issue> optional) {
        Issue value = optional.orElse(null);
        if (this.asset2 == value) {
            return this;
        }
        return new ImmutableMetaAmmObject(this.asset, value, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaAmmObject(this.asset, this.asset2, newValue, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaAmmObject(this.asset, this.asset2, value, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withAuctionSlot(MetaAuctionSlot value) {
        MetaAuctionSlot newValue = Objects.requireNonNull(value, "auctionSlot");
        if (this.auctionSlot == newValue) {
            return this;
        }
        return new ImmutableMetaAmmObject(this.asset, this.asset2, this.account, newValue, this.lpTokenBalance, this.tradingFee, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withAuctionSlot(Optional<? extends MetaAuctionSlot> optional) {
        MetaAuctionSlot value = optional.orElse(null);
        if (this.auctionSlot == value) {
            return this;
        }
        return new ImmutableMetaAmmObject(this.asset, this.asset2, this.account, value, this.lpTokenBalance, this.tradingFee, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withLpTokenBalance(IssuedCurrencyAmount value) {
        IssuedCurrencyAmount newValue = Objects.requireNonNull(value, "lpTokenBalance");
        if (this.lpTokenBalance == newValue) {
            return this;
        }
        return new ImmutableMetaAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, newValue, this.tradingFee, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withLpTokenBalance(Optional<? extends IssuedCurrencyAmount> optional) {
        IssuedCurrencyAmount value = optional.orElse(null);
        if (this.lpTokenBalance == value) {
            return this;
        }
        return new ImmutableMetaAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, value, this.tradingFee, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withTradingFee(TradingFee value) {
        TradingFee newValue = Objects.requireNonNull(value, "tradingFee");
        if (this.tradingFee == newValue) {
            return this;
        }
        return new ImmutableMetaAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, newValue, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withTradingFee(Optional<? extends TradingFee> optional) {
        TradingFee value = optional.orElse(null);
        if (this.tradingFee == value) {
            return this;
        }
        return new ImmutableMetaAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, value, this.voteSlots);
    }

    public final ImmutableMetaAmmObject withVoteSlots(MetaVoteEntryWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMetaAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, (ImmutableList<MetaVoteEntryWrapper>)newValue);
    }

    public final ImmutableMetaAmmObject withVoteSlots(Iterable<? extends MetaVoteEntryWrapper> elements) {
        if (this.voteSlots == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetaAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, (ImmutableList<MetaVoteEntryWrapper>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaAmmObject && this.equalTo(0, (ImmutableMetaAmmObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaAmmObject another) {
        return this.flags.equals(another.flags) && Objects.equals(this.asset, another.asset) && Objects.equals(this.asset2, another.asset2) && Objects.equals(this.account, another.account) && Objects.equals(this.auctionSlot, another.auctionSlot) && Objects.equals(this.lpTokenBalance, another.lpTokenBalance) && Objects.equals(this.tradingFee, another.tradingFee) && this.voteSlots.equals(another.voteSlots) && this.voteSlotsUnwrapped.equals(another.voteSlotsUnwrapped);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode(this.asset);
        h += (h << 5) + Objects.hashCode(this.asset2);
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.auctionSlot);
        h += (h << 5) + Objects.hashCode(this.lpTokenBalance);
        h += (h << 5) + Objects.hashCode(this.tradingFee);
        h += (h << 5) + this.voteSlots.hashCode();
        h += (h << 5) + this.voteSlotsUnwrapped.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaAmmObject").omitNullValues().add("flags", (Object)this.flags).add("asset", (Object)this.asset).add("asset2", (Object)this.asset2).add("account", (Object)this.account).add("auctionSlot", (Object)this.auctionSlot).add("lpTokenBalance", (Object)this.lpTokenBalance).add("tradingFee", (Object)this.tradingFee).add("voteSlots", this.voteSlots).add("voteSlotsUnwrapped", this.voteSlotsUnwrapped).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaAmmObject fromJson(Json json) {
        Builder builder = ImmutableMetaAmmObject.builder();
        if (json.asset != null) {
            builder.asset(json.asset);
        }
        if (json.asset2 != null) {
            builder.asset2(json.asset2);
        }
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.auctionSlot != null) {
            builder.auctionSlot(json.auctionSlot);
        }
        if (json.lpTokenBalance != null) {
            builder.lpTokenBalance(json.lpTokenBalance);
        }
        if (json.tradingFee != null) {
            builder.tradingFee(json.tradingFee);
        }
        if (json.voteSlots != null) {
            builder.addAllVoteSlots(json.voteSlots);
        }
        return builder.build();
    }

    public static ImmutableMetaAmmObject copyOf(MetaAmmObject instance) {
        if (instance instanceof ImmutableMetaAmmObject) {
            return (ImmutableMetaAmmObject)instance;
        }
        return ImmutableMetaAmmObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaAmmObject", generator="Immutables")
    private final class InitShim {
        private byte flagsBuildStage = 0;
        private Flags flags;
        private byte voteSlotsUnwrappedBuildStage = 0;
        private List<MetaVoteEntry> voteSlotsUnwrapped;

        private InitShim() {
        }

        Flags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutableMetaAmmObject.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        List<MetaVoteEntry> voteSlotsUnwrapped() {
            if (this.voteSlotsUnwrappedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.voteSlotsUnwrappedBuildStage == 0) {
                this.voteSlotsUnwrappedBuildStage = (byte)-1;
                this.voteSlotsUnwrapped = Objects.requireNonNull(ImmutableMetaAmmObject.this.voteSlotsUnwrappedInitialize(), "voteSlotsUnwrapped");
                this.voteSlotsUnwrappedBuildStage = 1;
            }
            return this.voteSlotsUnwrapped;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.voteSlotsUnwrappedBuildStage == -1) {
                attributes.add("voteSlotsUnwrapped");
            }
            return "Cannot build MetaAmmObject, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="MetaAmmObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Issue asset;
        @Nullable
        private Issue asset2;
        @Nullable
        private Address account;
        @Nullable
        private MetaAuctionSlot auctionSlot;
        @Nullable
        private IssuedCurrencyAmount lpTokenBalance;
        @Nullable
        private TradingFee tradingFee;
        private ImmutableList.Builder<MetaVoteEntryWrapper> voteSlots = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaAmmObject instance) {
            Optional<TradingFee> tradingFeeOptional;
            Optional<IssuedCurrencyAmount> lpTokenBalanceOptional;
            Optional<MetaAuctionSlot> auctionSlotOptional;
            Optional<Address> accountOptional;
            Optional<Issue> asset2Optional;
            Objects.requireNonNull(instance, "instance");
            Optional<Issue> assetOptional = instance.asset();
            if (assetOptional.isPresent()) {
                this.asset(assetOptional);
            }
            if ((asset2Optional = instance.asset2()).isPresent()) {
                this.asset2(asset2Optional);
            }
            if ((accountOptional = instance.account()).isPresent()) {
                this.account(accountOptional);
            }
            if ((auctionSlotOptional = instance.auctionSlot()).isPresent()) {
                this.auctionSlot(auctionSlotOptional);
            }
            if ((lpTokenBalanceOptional = instance.lpTokenBalance()).isPresent()) {
                this.lpTokenBalance(lpTokenBalanceOptional);
            }
            if ((tradingFeeOptional = instance.tradingFee()).isPresent()) {
                this.tradingFee(tradingFeeOptional);
            }
            this.addAllVoteSlots(instance.voteSlots());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder asset(Issue asset) {
            this.asset = Objects.requireNonNull(asset, "asset");
            return this;
        }

        @JsonProperty(value="Asset")
        @CanIgnoreReturnValue
        public final Builder asset(Optional<? extends Issue> asset) {
            this.asset = asset.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder asset2(Issue asset2) {
            this.asset2 = Objects.requireNonNull(asset2, "asset2");
            return this;
        }

        @JsonProperty(value="Asset2")
        @CanIgnoreReturnValue
        public final Builder asset2(Optional<? extends Issue> asset2) {
            this.asset2 = asset2.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auctionSlot(MetaAuctionSlot auctionSlot) {
            this.auctionSlot = Objects.requireNonNull(auctionSlot, "auctionSlot");
            return this;
        }

        @JsonProperty(value="AuctionSlot")
        @CanIgnoreReturnValue
        public final Builder auctionSlot(Optional<? extends MetaAuctionSlot> auctionSlot) {
            this.auctionSlot = auctionSlot.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lpTokenBalance(IssuedCurrencyAmount lpTokenBalance) {
            this.lpTokenBalance = Objects.requireNonNull(lpTokenBalance, "lpTokenBalance");
            return this;
        }

        @JsonProperty(value="LPTokenBalance")
        @CanIgnoreReturnValue
        public final Builder lpTokenBalance(Optional<? extends IssuedCurrencyAmount> lpTokenBalance) {
            this.lpTokenBalance = lpTokenBalance.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tradingFee(TradingFee tradingFee) {
            this.tradingFee = Objects.requireNonNull(tradingFee, "tradingFee");
            return this;
        }

        @JsonProperty(value="TradingFee")
        @CanIgnoreReturnValue
        public final Builder tradingFee(Optional<? extends TradingFee> tradingFee) {
            this.tradingFee = tradingFee.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVoteSlots(MetaVoteEntryWrapper element) {
            this.voteSlots.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVoteSlots(MetaVoteEntryWrapper ... elements) {
            this.voteSlots.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="VoteSlots")
        @CanIgnoreReturnValue
        public final Builder voteSlots(Iterable<? extends MetaVoteEntryWrapper> elements) {
            this.voteSlots = ImmutableList.builder();
            return this.addAllVoteSlots(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllVoteSlots(Iterable<? extends MetaVoteEntryWrapper> elements) {
            this.voteSlots.addAll(elements);
            return this;
        }

        public ImmutableMetaAmmObject build() {
            return new ImmutableMetaAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaAmmObject", generator="Immutables")
    static final class Json
    implements MetaAmmObject {
        @Nullable
        Optional<Issue> asset = Optional.empty();
        @Nullable
        Optional<Issue> asset2 = Optional.empty();
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<MetaAuctionSlot> auctionSlot = Optional.empty();
        @Nullable
        Optional<IssuedCurrencyAmount> lpTokenBalance = Optional.empty();
        @Nullable
        Optional<TradingFee> tradingFee = Optional.empty();
        @Nullable
        List<MetaVoteEntryWrapper> voteSlots = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Asset")
        public void setAsset(Optional<Issue> asset) {
            this.asset = asset;
        }

        @JsonProperty(value="Asset2")
        public void setAsset2(Optional<Issue> asset2) {
            this.asset2 = asset2;
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="AuctionSlot")
        public void setAuctionSlot(Optional<MetaAuctionSlot> auctionSlot) {
            this.auctionSlot = auctionSlot;
        }

        @JsonProperty(value="LPTokenBalance")
        public void setLpTokenBalance(Optional<IssuedCurrencyAmount> lpTokenBalance) {
            this.lpTokenBalance = lpTokenBalance;
        }

        @JsonProperty(value="TradingFee")
        public void setTradingFee(Optional<TradingFee> tradingFee) {
            this.tradingFee = tradingFee;
        }

        @JsonProperty(value="VoteSlots")
        public void setVoteSlots(List<MetaVoteEntryWrapper> voteSlots) {
            this.voteSlots = voteSlots;
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Issue> asset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Issue> asset2() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<MetaAuctionSlot> auctionSlot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<IssuedCurrencyAmount> lpTokenBalance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TradingFee> tradingFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MetaVoteEntryWrapper> voteSlots() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public List<MetaVoteEntry> voteSlotsUnwrapped() {
            throw new UnsupportedOperationException();
        }
    }
}

