/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.AccountRootFlags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaAccountRootObject;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaSignerListObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetaAccountRootObject", generator="Immutables")
@Immutable
public final class ImmutableMetaAccountRootObject
implements MetaAccountRootObject {
    @Nullable
    private final Address account;
    @Nullable
    private final XrpCurrencyAmount balance;
    @Nullable
    private final AccountRootFlags flags;
    @Nullable
    private final UnsignedInteger ownerCount;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final LedgerIndex previousTransactionLedgerSequence;
    @Nullable
    private final UnsignedInteger sequence;
    @Nullable
    private final Hash256 accountTransactionId;
    @Nullable
    private final String domain;
    @Nullable
    private final String emailHash;
    @Nullable
    private final String messageKey;
    @Nullable
    private final Address regularKey;
    @Nullable
    private final UnsignedInteger tickSize;
    @Nullable
    private final UnsignedInteger transferRate;
    private final ImmutableList<MetaSignerListObject> signerLists;
    @Nullable
    private final UnsignedInteger ticketCount;
    @Nullable
    private final UnsignedInteger burnedNfTokens;
    @Nullable
    private final UnsignedInteger mintedNfTokens;
    @Nullable
    private final Address nfTokenMinter;

    private ImmutableMetaAccountRootObject(@Nullable Address account, @Nullable XrpCurrencyAmount balance, @Nullable AccountRootFlags flags, @Nullable UnsignedInteger ownerCount, @Nullable Hash256 previousTransactionId, @Nullable LedgerIndex previousTransactionLedgerSequence, @Nullable UnsignedInteger sequence, @Nullable Hash256 accountTransactionId, @Nullable String domain, @Nullable String emailHash, @Nullable String messageKey, @Nullable Address regularKey, @Nullable UnsignedInteger tickSize, @Nullable UnsignedInteger transferRate, ImmutableList<MetaSignerListObject> signerLists, @Nullable UnsignedInteger ticketCount, @Nullable UnsignedInteger burnedNfTokens, @Nullable UnsignedInteger mintedNfTokens, @Nullable Address nfTokenMinter) {
        this.account = account;
        this.balance = balance;
        this.flags = flags;
        this.ownerCount = ownerCount;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.sequence = sequence;
        this.accountTransactionId = accountTransactionId;
        this.domain = domain;
        this.emailHash = emailHash;
        this.messageKey = messageKey;
        this.regularKey = regularKey;
        this.tickSize = tickSize;
        this.transferRate = transferRate;
        this.signerLists = signerLists;
        this.ticketCount = ticketCount;
        this.burnedNfTokens = burnedNfTokens;
        this.mintedNfTokens = mintedNfTokens;
        this.nfTokenMinter = nfTokenMinter;
    }

    @Override
    @JsonProperty(value="Account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="Balance")
    public Optional<XrpCurrencyAmount> balance() {
        return Optional.ofNullable(this.balance);
    }

    @Override
    @JsonProperty(value="Flags")
    public Optional<AccountRootFlags> flags() {
        return Optional.ofNullable(this.flags);
    }

    @Override
    @JsonProperty(value="OwnerCount")
    public Optional<UnsignedInteger> ownerCount() {
        return Optional.ofNullable(this.ownerCount);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    @Override
    @JsonProperty(value="Sequence")
    public Optional<UnsignedInteger> sequence() {
        return Optional.ofNullable(this.sequence);
    }

    @Override
    @JsonProperty(value="AccountTxnID")
    public Optional<Hash256> accountTransactionId() {
        return Optional.ofNullable(this.accountTransactionId);
    }

    @Override
    @JsonProperty(value="Domain")
    public Optional<String> domain() {
        return Optional.ofNullable(this.domain);
    }

    @Override
    @JsonProperty(value="EmailHash")
    public Optional<String> emailHash() {
        return Optional.ofNullable(this.emailHash);
    }

    @Override
    @JsonProperty(value="MessageKey")
    public Optional<String> messageKey() {
        return Optional.ofNullable(this.messageKey);
    }

    @Override
    @JsonProperty(value="RegularKey")
    public Optional<Address> regularKey() {
        return Optional.ofNullable(this.regularKey);
    }

    @Override
    @JsonProperty(value="TickSize")
    public Optional<UnsignedInteger> tickSize() {
        return Optional.ofNullable(this.tickSize);
    }

    @Override
    @JsonProperty(value="TransferRate")
    public Optional<UnsignedInteger> transferRate() {
        return Optional.ofNullable(this.transferRate);
    }

    @JsonProperty(value="signer_lists")
    public ImmutableList<MetaSignerListObject> signerLists() {
        return this.signerLists;
    }

    @Override
    @JsonProperty(value="TicketCount")
    public Optional<UnsignedInteger> ticketCount() {
        return Optional.ofNullable(this.ticketCount);
    }

    @Override
    @JsonProperty(value="BurnedNFTokens")
    public Optional<UnsignedInteger> burnedNfTokens() {
        return Optional.ofNullable(this.burnedNfTokens);
    }

    @Override
    @JsonProperty(value="MintedNFTokens")
    public Optional<UnsignedInteger> mintedNfTokens() {
        return Optional.ofNullable(this.mintedNfTokens);
    }

    @Override
    @JsonProperty(value="NFTokenMinter")
    public Optional<Address> nfTokenMinter() {
        return Optional.ofNullable(this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(newValue, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(value, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withBalance(XrpCurrencyAmount value) {
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "balance");
        if (this.balance == newValue) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, newValue, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withBalance(Optional<? extends XrpCurrencyAmount> optional) {
        XrpCurrencyAmount value = optional.orElse(null);
        if (this.balance == value) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, value, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withFlags(AccountRootFlags value) {
        AccountRootFlags newValue = Objects.requireNonNull(value, "flags");
        if (this.flags == newValue) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, newValue, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withFlags(Optional<? extends AccountRootFlags> optional) {
        AccountRootFlags value = optional.orElse(null);
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, value, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withOwnerCount(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "ownerCount");
        if (Objects.equals(this.ownerCount, newValue)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withOwnerCount(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.ownerCount, value)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, value, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, newValue, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, value, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withPreviousTransactionLedgerSequence(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence == newValue) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, newValue, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withPreviousTransactionLedgerSequence(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.previousTransactionLedgerSequence == value) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, value, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (Objects.equals(this.sequence, newValue)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sequence, value)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, value, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withAccountTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "accountTransactionId");
        if (this.accountTransactionId == newValue) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, newValue, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withAccountTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.accountTransactionId == value) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, value, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withDomain(String value) {
        String newValue = Objects.requireNonNull(value, "domain");
        if (Objects.equals(this.domain, newValue)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, newValue, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withDomain(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.domain, value)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, value, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withEmailHash(String value) {
        String newValue = Objects.requireNonNull(value, "emailHash");
        if (Objects.equals(this.emailHash, newValue)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, newValue, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withEmailHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.emailHash, value)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, value, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withMessageKey(String value) {
        String newValue = Objects.requireNonNull(value, "messageKey");
        if (Objects.equals(this.messageKey, newValue)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, newValue, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withMessageKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.messageKey, value)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, value, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withRegularKey(Address value) {
        Address newValue = Objects.requireNonNull(value, "regularKey");
        if (this.regularKey == newValue) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, newValue, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withRegularKey(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.regularKey == value) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, value, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withTickSize(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "tickSize");
        if (Objects.equals(this.tickSize, newValue)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, newValue, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withTickSize(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.tickSize, value)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, value, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withTransferRate(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "transferRate");
        if (Objects.equals(this.transferRate, newValue)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, newValue, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withTransferRate(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.transferRate, value)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, value, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withSignerLists(MetaSignerListObject ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, (ImmutableList<MetaSignerListObject>)newValue, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withSignerLists(Iterable<? extends MetaSignerListObject> elements) {
        if (this.signerLists == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, (ImmutableList<MetaSignerListObject>)newValue, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withTicketCount(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "ticketCount");
        if (Objects.equals(this.ticketCount, newValue)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, newValue, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withTicketCount(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.ticketCount, value)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, value, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withBurnedNfTokens(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "burnedNfTokens");
        if (Objects.equals(this.burnedNfTokens, newValue)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, newValue, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withBurnedNfTokens(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.burnedNfTokens, value)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, value, this.mintedNfTokens, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withMintedNfTokens(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "mintedNfTokens");
        if (Objects.equals(this.mintedNfTokens, newValue)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, newValue, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withMintedNfTokens(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.mintedNfTokens, value)) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, value, this.nfTokenMinter);
    }

    public final ImmutableMetaAccountRootObject withNfTokenMinter(Address value) {
        Address newValue = Objects.requireNonNull(value, "nfTokenMinter");
        if (this.nfTokenMinter == newValue) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, newValue);
    }

    public final ImmutableMetaAccountRootObject withNfTokenMinter(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.nfTokenMinter == value) {
            return this;
        }
        return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetaAccountRootObject && this.equalTo(0, (ImmutableMetaAccountRootObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetaAccountRootObject another) {
        return Objects.equals(this.account, another.account) && Objects.equals(this.balance, another.balance) && Objects.equals(this.flags, another.flags) && Objects.equals(this.ownerCount, another.ownerCount) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence) && Objects.equals(this.sequence, another.sequence) && Objects.equals(this.accountTransactionId, another.accountTransactionId) && Objects.equals(this.domain, another.domain) && Objects.equals(this.emailHash, another.emailHash) && Objects.equals(this.messageKey, another.messageKey) && Objects.equals(this.regularKey, another.regularKey) && Objects.equals(this.tickSize, another.tickSize) && Objects.equals(this.transferRate, another.transferRate) && this.signerLists.equals(another.signerLists) && Objects.equals(this.ticketCount, another.ticketCount) && Objects.equals(this.burnedNfTokens, another.burnedNfTokens) && Objects.equals(this.mintedNfTokens, another.mintedNfTokens) && Objects.equals(this.nfTokenMinter, another.nfTokenMinter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.balance);
        h += (h << 5) + Objects.hashCode(this.flags);
        h += (h << 5) + Objects.hashCode(this.ownerCount);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        h += (h << 5) + Objects.hashCode(this.sequence);
        h += (h << 5) + Objects.hashCode(this.accountTransactionId);
        h += (h << 5) + Objects.hashCode(this.domain);
        h += (h << 5) + Objects.hashCode(this.emailHash);
        h += (h << 5) + Objects.hashCode(this.messageKey);
        h += (h << 5) + Objects.hashCode(this.regularKey);
        h += (h << 5) + Objects.hashCode(this.tickSize);
        h += (h << 5) + Objects.hashCode(this.transferRate);
        h += (h << 5) + this.signerLists.hashCode();
        h += (h << 5) + Objects.hashCode(this.ticketCount);
        h += (h << 5) + Objects.hashCode(this.burnedNfTokens);
        h += (h << 5) + Objects.hashCode(this.mintedNfTokens);
        h += (h << 5) + Objects.hashCode(this.nfTokenMinter);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetaAccountRootObject").omitNullValues().add("account", (Object)this.account).add("balance", (Object)this.balance).add("flags", (Object)this.flags).add("ownerCount", (Object)this.ownerCount).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("sequence", (Object)this.sequence).add("accountTransactionId", (Object)this.accountTransactionId).add("domain", (Object)this.domain).add("emailHash", (Object)this.emailHash).add("messageKey", (Object)this.messageKey).add("regularKey", (Object)this.regularKey).add("tickSize", (Object)this.tickSize).add("transferRate", (Object)this.transferRate).add("signerLists", this.signerLists).add("ticketCount", (Object)this.ticketCount).add("burnedNfTokens", (Object)this.burnedNfTokens).add("mintedNfTokens", (Object)this.mintedNfTokens).add("nfTokenMinter", (Object)this.nfTokenMinter).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetaAccountRootObject fromJson(Json json) {
        Builder builder = ImmutableMetaAccountRootObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.balance != null) {
            builder.balance(json.balance);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.ownerCount != null) {
            builder.ownerCount(json.ownerCount);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.accountTransactionId != null) {
            builder.accountTransactionId(json.accountTransactionId);
        }
        if (json.domain != null) {
            builder.domain(json.domain);
        }
        if (json.emailHash != null) {
            builder.emailHash(json.emailHash);
        }
        if (json.messageKey != null) {
            builder.messageKey(json.messageKey);
        }
        if (json.regularKey != null) {
            builder.regularKey(json.regularKey);
        }
        if (json.tickSize != null) {
            builder.tickSize(json.tickSize);
        }
        if (json.transferRate != null) {
            builder.transferRate(json.transferRate);
        }
        if (json.signerLists != null) {
            builder.addAllSignerLists(json.signerLists);
        }
        if (json.ticketCount != null) {
            builder.ticketCount(json.ticketCount);
        }
        if (json.burnedNfTokens != null) {
            builder.burnedNfTokens(json.burnedNfTokens);
        }
        if (json.mintedNfTokens != null) {
            builder.mintedNfTokens(json.mintedNfTokens);
        }
        if (json.nfTokenMinter != null) {
            builder.nfTokenMinter(json.nfTokenMinter);
        }
        return builder.build();
    }

    public static ImmutableMetaAccountRootObject copyOf(MetaAccountRootObject instance) {
        if (instance instanceof ImmutableMetaAccountRootObject) {
            return (ImmutableMetaAccountRootObject)instance;
        }
        return ImmutableMetaAccountRootObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetaAccountRootObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private XrpCurrencyAmount balance;
        @Nullable
        private AccountRootFlags flags;
        @Nullable
        private UnsignedInteger ownerCount;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private LedgerIndex previousTransactionLedgerSequence;
        @Nullable
        private UnsignedInteger sequence;
        @Nullable
        private Hash256 accountTransactionId;
        @Nullable
        private String domain;
        @Nullable
        private String emailHash;
        @Nullable
        private String messageKey;
        @Nullable
        private Address regularKey;
        @Nullable
        private UnsignedInteger tickSize;
        @Nullable
        private UnsignedInteger transferRate;
        private ImmutableList.Builder<MetaSignerListObject> signerLists = ImmutableList.builder();
        @Nullable
        private UnsignedInteger ticketCount;
        @Nullable
        private UnsignedInteger burnedNfTokens;
        @Nullable
        private UnsignedInteger mintedNfTokens;
        @Nullable
        private Address nfTokenMinter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetaAccountRootObject instance) {
            Optional<Address> nfTokenMinterOptional;
            Optional<UnsignedInteger> mintedNfTokensOptional;
            Optional<UnsignedInteger> burnedNfTokensOptional;
            Optional<UnsignedInteger> transferRateOptional;
            Optional<UnsignedInteger> tickSizeOptional;
            Optional<Address> regularKeyOptional;
            Optional<String> messageKeyOptional;
            Optional<String> emailHashOptional;
            Optional<String> domainOptional;
            Optional<Hash256> accountTransactionIdOptional;
            Optional<UnsignedInteger> sequenceOptional;
            Optional<LedgerIndex> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<UnsignedInteger> ownerCountOptional;
            Optional<AccountRootFlags> flagsOptional;
            Optional<XrpCurrencyAmount> balanceOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((balanceOptional = instance.balance()).isPresent()) {
                this.balance(balanceOptional);
            }
            if ((flagsOptional = instance.flags()).isPresent()) {
                this.flags(flagsOptional);
            }
            if ((ownerCountOptional = instance.ownerCount()).isPresent()) {
                this.ownerCount(ownerCountOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            if ((sequenceOptional = instance.sequence()).isPresent()) {
                this.sequence(sequenceOptional);
            }
            if ((accountTransactionIdOptional = instance.accountTransactionId()).isPresent()) {
                this.accountTransactionId(accountTransactionIdOptional);
            }
            if ((domainOptional = instance.domain()).isPresent()) {
                this.domain(domainOptional);
            }
            if ((emailHashOptional = instance.emailHash()).isPresent()) {
                this.emailHash(emailHashOptional);
            }
            if ((messageKeyOptional = instance.messageKey()).isPresent()) {
                this.messageKey(messageKeyOptional);
            }
            if ((regularKeyOptional = instance.regularKey()).isPresent()) {
                this.regularKey(regularKeyOptional);
            }
            if ((tickSizeOptional = instance.tickSize()).isPresent()) {
                this.tickSize(tickSizeOptional);
            }
            if ((transferRateOptional = instance.transferRate()).isPresent()) {
                this.transferRate(transferRateOptional);
            }
            this.addAllSignerLists(instance.signerLists());
            Optional<UnsignedInteger> ticketCountOptional = instance.ticketCount();
            if (ticketCountOptional.isPresent()) {
                this.ticketCount(ticketCountOptional);
            }
            if ((burnedNfTokensOptional = instance.burnedNfTokens()).isPresent()) {
                this.burnedNfTokens(burnedNfTokensOptional);
            }
            if ((mintedNfTokensOptional = instance.mintedNfTokens()).isPresent()) {
                this.mintedNfTokens(mintedNfTokensOptional);
            }
            if ((nfTokenMinterOptional = instance.nfTokenMinter()).isPresent()) {
                this.nfTokenMinter(nfTokenMinterOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder balance(XrpCurrencyAmount balance) {
            this.balance = Objects.requireNonNull(balance, "balance");
            return this;
        }

        @JsonProperty(value="Balance")
        @CanIgnoreReturnValue
        public final Builder balance(Optional<? extends XrpCurrencyAmount> balance) {
            this.balance = balance.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder flags(AccountRootFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(Optional<? extends AccountRootFlags> flags) {
            this.flags = flags.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerCount(UnsignedInteger ownerCount) {
            this.ownerCount = Objects.requireNonNull(ownerCount, "ownerCount");
            return this;
        }

        @JsonProperty(value="OwnerCount")
        @CanIgnoreReturnValue
        public final Builder ownerCount(Optional<? extends UnsignedInteger> ownerCount) {
            this.ownerCount = ownerCount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(LedgerIndex previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            return this;
        }

        @JsonProperty(value="Sequence")
        @CanIgnoreReturnValue
        public final Builder sequence(Optional<? extends UnsignedInteger> sequence) {
            this.sequence = sequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Hash256 accountTransactionId) {
            this.accountTransactionId = Objects.requireNonNull(accountTransactionId, "accountTransactionId");
            return this;
        }

        @JsonProperty(value="AccountTxnID")
        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Optional<? extends Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            return this;
        }

        @JsonProperty(value="Domain")
        @CanIgnoreReturnValue
        public final Builder domain(Optional<String> domain) {
            this.domain = domain.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder emailHash(String emailHash) {
            this.emailHash = Objects.requireNonNull(emailHash, "emailHash");
            return this;
        }

        @JsonProperty(value="EmailHash")
        @CanIgnoreReturnValue
        public final Builder emailHash(Optional<String> emailHash) {
            this.emailHash = emailHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messageKey(String messageKey) {
            this.messageKey = Objects.requireNonNull(messageKey, "messageKey");
            return this;
        }

        @JsonProperty(value="MessageKey")
        @CanIgnoreReturnValue
        public final Builder messageKey(Optional<String> messageKey) {
            this.messageKey = messageKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder regularKey(Address regularKey) {
            this.regularKey = Objects.requireNonNull(regularKey, "regularKey");
            return this;
        }

        @JsonProperty(value="RegularKey")
        @CanIgnoreReturnValue
        public final Builder regularKey(Optional<? extends Address> regularKey) {
            this.regularKey = regularKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tickSize(UnsignedInteger tickSize) {
            this.tickSize = Objects.requireNonNull(tickSize, "tickSize");
            return this;
        }

        @JsonProperty(value="TickSize")
        @CanIgnoreReturnValue
        public final Builder tickSize(Optional<? extends UnsignedInteger> tickSize) {
            this.tickSize = tickSize.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transferRate(UnsignedInteger transferRate) {
            this.transferRate = Objects.requireNonNull(transferRate, "transferRate");
            return this;
        }

        @JsonProperty(value="TransferRate")
        @CanIgnoreReturnValue
        public final Builder transferRate(Optional<? extends UnsignedInteger> transferRate) {
            this.transferRate = transferRate.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignerLists(MetaSignerListObject element) {
            this.signerLists.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignerLists(MetaSignerListObject ... elements) {
            this.signerLists.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="signer_lists")
        @CanIgnoreReturnValue
        public final Builder signerLists(Iterable<? extends MetaSignerListObject> elements) {
            this.signerLists = ImmutableList.builder();
            return this.addAllSignerLists(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSignerLists(Iterable<? extends MetaSignerListObject> elements) {
            this.signerLists.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ticketCount(UnsignedInteger ticketCount) {
            this.ticketCount = Objects.requireNonNull(ticketCount, "ticketCount");
            return this;
        }

        @JsonProperty(value="TicketCount")
        @CanIgnoreReturnValue
        public final Builder ticketCount(Optional<? extends UnsignedInteger> ticketCount) {
            this.ticketCount = ticketCount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder burnedNfTokens(UnsignedInteger burnedNfTokens) {
            this.burnedNfTokens = Objects.requireNonNull(burnedNfTokens, "burnedNfTokens");
            return this;
        }

        @JsonProperty(value="BurnedNFTokens")
        @CanIgnoreReturnValue
        public final Builder burnedNfTokens(Optional<? extends UnsignedInteger> burnedNfTokens) {
            this.burnedNfTokens = burnedNfTokens.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mintedNfTokens(UnsignedInteger mintedNfTokens) {
            this.mintedNfTokens = Objects.requireNonNull(mintedNfTokens, "mintedNfTokens");
            return this;
        }

        @JsonProperty(value="MintedNFTokens")
        @CanIgnoreReturnValue
        public final Builder mintedNfTokens(Optional<? extends UnsignedInteger> mintedNfTokens) {
            this.mintedNfTokens = mintedNfTokens.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nfTokenMinter(Address nfTokenMinter) {
            this.nfTokenMinter = Objects.requireNonNull(nfTokenMinter, "nfTokenMinter");
            return this;
        }

        @JsonProperty(value="NFTokenMinter")
        @CanIgnoreReturnValue
        public final Builder nfTokenMinter(Optional<? extends Address> nfTokenMinter) {
            this.nfTokenMinter = nfTokenMinter.orElse(null);
            return this;
        }

        public ImmutableMetaAccountRootObject build() {
            return new ImmutableMetaAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists.build(), this.ticketCount, this.burnedNfTokens, this.mintedNfTokens, this.nfTokenMinter);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetaAccountRootObject", generator="Immutables")
    static final class Json
    implements MetaAccountRootObject {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<XrpCurrencyAmount> balance = Optional.empty();
        @Nullable
        Optional<AccountRootFlags> flags = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> ownerCount = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<LedgerIndex> previousTransactionLedgerSequence = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> sequence = Optional.empty();
        @Nullable
        Optional<Hash256> accountTransactionId = Optional.empty();
        @Nullable
        Optional<String> domain = Optional.empty();
        @Nullable
        Optional<String> emailHash = Optional.empty();
        @Nullable
        Optional<String> messageKey = Optional.empty();
        @Nullable
        Optional<Address> regularKey = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> tickSize = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> transferRate = Optional.empty();
        @Nullable
        List<MetaSignerListObject> signerLists = ImmutableList.of();
        @Nullable
        Optional<UnsignedInteger> ticketCount = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> burnedNfTokens = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> mintedNfTokens = Optional.empty();
        @Nullable
        Optional<Address> nfTokenMinter = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="Balance")
        public void setBalance(Optional<XrpCurrencyAmount> balance) {
            this.balance = balance;
        }

        @JsonProperty(value="Flags")
        public void setFlags(Optional<AccountRootFlags> flags) {
            this.flags = flags;
        }

        @JsonProperty(value="OwnerCount")
        public void setOwnerCount(Optional<UnsignedInteger> ownerCount) {
            this.ownerCount = ownerCount;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="Sequence")
        public void setSequence(Optional<UnsignedInteger> sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="AccountTxnID")
        public void setAccountTransactionId(Optional<Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId;
        }

        @JsonProperty(value="Domain")
        public void setDomain(Optional<String> domain) {
            this.domain = domain;
        }

        @JsonProperty(value="EmailHash")
        public void setEmailHash(Optional<String> emailHash) {
            this.emailHash = emailHash;
        }

        @JsonProperty(value="MessageKey")
        public void setMessageKey(Optional<String> messageKey) {
            this.messageKey = messageKey;
        }

        @JsonProperty(value="RegularKey")
        public void setRegularKey(Optional<Address> regularKey) {
            this.regularKey = regularKey;
        }

        @JsonProperty(value="TickSize")
        public void setTickSize(Optional<UnsignedInteger> tickSize) {
            this.tickSize = tickSize;
        }

        @JsonProperty(value="TransferRate")
        public void setTransferRate(Optional<UnsignedInteger> transferRate) {
            this.transferRate = transferRate;
        }

        @JsonProperty(value="signer_lists")
        public void setSignerLists(List<MetaSignerListObject> signerLists) {
            this.signerLists = signerLists;
        }

        @JsonProperty(value="TicketCount")
        public void setTicketCount(Optional<UnsignedInteger> ticketCount) {
            this.ticketCount = ticketCount;
        }

        @JsonProperty(value="BurnedNFTokens")
        public void setBurnedNfTokens(Optional<UnsignedInteger> burnedNfTokens) {
            this.burnedNfTokens = burnedNfTokens;
        }

        @JsonProperty(value="MintedNFTokens")
        public void setMintedNfTokens(Optional<UnsignedInteger> mintedNfTokens) {
            this.mintedNfTokens = mintedNfTokens;
        }

        @JsonProperty(value="NFTokenMinter")
        public void setNfTokenMinter(Optional<Address> nfTokenMinter) {
            this.nfTokenMinter = nfTokenMinter;
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XrpCurrencyAmount> balance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<AccountRootFlags> flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> ownerCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> accountTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> domain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> emailHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> messageKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> regularKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> tickSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> transferRate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MetaSignerListObject> signerLists() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> ticketCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> burnedNfTokens() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> mintedNfTokens() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> nfTokenMinter() {
            throw new UnsupportedOperationException();
        }
    }
}

