/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.AffectedNode;
import org.xrpl.xrpl4j.model.transactions.metadata.DeletedNode;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerEntryType;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeletedNode", generator="Immutables")
@Immutable
public final class ImmutableDeletedNode<T extends MetaLedgerObject>
implements DeletedNode<T> {
    private final MetaLedgerEntryType ledgerEntryType;
    private final Hash256 ledgerIndex;
    private final T finalFields;
    @Nullable
    private final T previousFields;

    private ImmutableDeletedNode(MetaLedgerEntryType ledgerEntryType, Hash256 ledgerIndex, T finalFields, @Nullable T previousFields) {
        this.ledgerEntryType = ledgerEntryType;
        this.ledgerIndex = ledgerIndex;
        this.finalFields = finalFields;
        this.previousFields = previousFields;
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public MetaLedgerEntryType ledgerEntryType() {
        return this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="LedgerIndex")
    public Hash256 ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="FinalFields")
    public T finalFields() {
        return this.finalFields;
    }

    @Override
    @JsonProperty(value="PreviousFields")
    public Optional<T> previousFields() {
        return Optional.ofNullable(this.previousFields);
    }

    public final ImmutableDeletedNode<T> withLedgerEntryType(MetaLedgerEntryType value) {
        if (this.ledgerEntryType == value) {
            return this;
        }
        MetaLedgerEntryType newValue = Objects.requireNonNull(value, "ledgerEntryType");
        return new ImmutableDeletedNode<T>(newValue, this.ledgerIndex, this.finalFields, this.previousFields);
    }

    public final ImmutableDeletedNode<T> withLedgerIndex(Hash256 value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "ledgerIndex");
        return new ImmutableDeletedNode<T>(this.ledgerEntryType, newValue, this.finalFields, this.previousFields);
    }

    public final ImmutableDeletedNode<T> withFinalFields(T value) {
        if (this.finalFields == value) {
            return this;
        }
        MetaLedgerObject newValue = (MetaLedgerObject)Objects.requireNonNull(value, "finalFields");
        return new ImmutableDeletedNode<MetaLedgerObject>(this.ledgerEntryType, this.ledgerIndex, newValue, (MetaLedgerObject)this.previousFields);
    }

    public final ImmutableDeletedNode<T> withPreviousFields(T value) {
        MetaLedgerObject newValue = (MetaLedgerObject)Objects.requireNonNull(value, "previousFields");
        if (this.previousFields == newValue) {
            return this;
        }
        return new ImmutableDeletedNode<MetaLedgerObject>(this.ledgerEntryType, this.ledgerIndex, (MetaLedgerObject)this.finalFields, newValue);
    }

    public final ImmutableDeletedNode<T> withPreviousFields(Optional<? extends T> optional) {
        MetaLedgerObject value = optional.orElse(null);
        if (this.previousFields == value) {
            return this;
        }
        return new ImmutableDeletedNode<MetaLedgerObject>(this.ledgerEntryType, this.ledgerIndex, (MetaLedgerObject)this.finalFields, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeletedNode && this.equalTo(0, (ImmutableDeletedNode)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeletedNode<?> another) {
        return this.ledgerEntryType.equals(another.ledgerEntryType) && this.ledgerIndex.equals(another.ledgerIndex) && this.finalFields.equals(another.finalFields) && Objects.equals(this.previousFields, another.previousFields);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.ledgerIndex.hashCode();
        h += (h << 5) + this.finalFields.hashCode();
        h += (h << 5) + Objects.hashCode(this.previousFields);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DeletedNode").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("ledgerIndex", (Object)this.ledgerIndex).add("finalFields", this.finalFields).add("previousFields", this.previousFields).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends MetaLedgerObject> ImmutableDeletedNode<T> fromJson(Json<T> json) {
        Builder builder = ImmutableDeletedNode.builder();
        if (json.ledgerEntryType != null) {
            builder.ledgerEntryType(json.ledgerEntryType);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.finalFields != null) {
            builder.finalFields(json.finalFields);
        }
        if (json.previousFields != null) {
            builder.previousFields(json.previousFields);
        }
        return builder.build();
    }

    public static <T extends MetaLedgerObject> ImmutableDeletedNode<T> copyOf(DeletedNode<T> instance) {
        if (instance instanceof ImmutableDeletedNode) {
            return (ImmutableDeletedNode)instance;
        }
        return ImmutableDeletedNode.builder().from(instance).build();
    }

    public static <T extends MetaLedgerObject> Builder<T> builder() {
        return new Builder();
    }

    /* synthetic */ ImmutableDeletedNode(MetaLedgerEntryType x0, Hash256 x1, MetaLedgerObject x2, MetaLedgerObject x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    @Generated(from="DeletedNode", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends MetaLedgerObject> {
        private static final long INIT_BIT_LEDGER_ENTRY_TYPE = 1L;
        private static final long INIT_BIT_LEDGER_INDEX = 2L;
        private static final long INIT_BIT_FINAL_FIELDS = 4L;
        private long initBits = 7L;
        @Nullable
        private MetaLedgerEntryType ledgerEntryType;
        @Nullable
        private Hash256 ledgerIndex;
        @Nullable
        private T finalFields;
        @Nullable
        private T previousFields;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(AffectedNode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(DeletedNode<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AffectedNode instance;
            long bits = 0L;
            if (object instanceof AffectedNode) {
                instance = (AffectedNode)object;
                if ((bits & 1L) == 0L) {
                    this.ledgerEntryType(instance.ledgerEntryType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.ledgerIndex(instance.ledgerIndex());
                    bits |= 2L;
                }
            }
            if (object instanceof DeletedNode) {
                instance = (DeletedNode)object;
                if ((bits & 1L) == 0L) {
                    this.ledgerEntryType(instance.ledgerEntryType());
                    bits |= 1L;
                }
                this.finalFields(instance.finalFields());
                Optional previousFieldsOptional = instance.previousFields();
                if (previousFieldsOptional.isPresent()) {
                    this.previousFields(previousFieldsOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.ledgerIndex(instance.ledgerIndex());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="LedgerEntryType")
        @CanIgnoreReturnValue
        public final Builder<T> ledgerEntryType(MetaLedgerEntryType ledgerEntryType) {
            this.ledgerEntryType = Objects.requireNonNull(ledgerEntryType, "ledgerEntryType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="LedgerIndex")
        @CanIgnoreReturnValue
        public final Builder<T> ledgerIndex(Hash256 ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="FinalFields")
        @CanIgnoreReturnValue
        public final Builder<T> finalFields(T finalFields) {
            this.finalFields = (MetaLedgerObject)Objects.requireNonNull(finalFields, "finalFields");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> previousFields(T previousFields) {
            this.previousFields = (MetaLedgerObject)Objects.requireNonNull(previousFields, "previousFields");
            return this;
        }

        @JsonProperty(value="PreviousFields")
        @CanIgnoreReturnValue
        public final Builder<T> previousFields(Optional<? extends T> previousFields) {
            this.previousFields = previousFields.orElse(null);
            return this;
        }

        public ImmutableDeletedNode<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeletedNode(this.ledgerEntryType, this.ledgerIndex, (MetaLedgerObject)this.finalFields, (MetaLedgerObject)this.previousFields, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ledgerEntryType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ledgerIndex");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("finalFields");
            }
            return "Cannot build DeletedNode, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DeletedNode", generator="Immutables")
    static final class Json<T extends MetaLedgerObject>
    implements DeletedNode<T> {
        @Nullable
        MetaLedgerEntryType ledgerEntryType;
        @Nullable
        Hash256 ledgerIndex;
        @Nullable
        T finalFields;
        @Nullable
        Optional<T> previousFields = Optional.empty();

        Json() {
        }

        @JsonProperty(value="LedgerEntryType")
        public void setLedgerEntryType(MetaLedgerEntryType ledgerEntryType) {
            this.ledgerEntryType = ledgerEntryType;
        }

        @JsonProperty(value="LedgerIndex")
        public void setLedgerIndex(Hash256 ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="FinalFields")
        public void setFinalFields(T finalFields) {
            this.finalFields = finalFields;
        }

        @JsonProperty(value="PreviousFields")
        public void setPreviousFields(Optional<T> previousFields) {
            this.previousFields = previousFields;
        }

        @Override
        public MetaLedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T finalFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<T> previousFields() {
            throw new UnsupportedOperationException();
        }
    }
}

