/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.AffectedNode;
import org.xrpl.xrpl4j.model.transactions.metadata.CreatedNode;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerEntryType;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreatedNode", generator="Immutables")
@Immutable
public final class ImmutableCreatedNode<T extends MetaLedgerObject>
implements CreatedNode<T> {
    private final MetaLedgerEntryType ledgerEntryType;
    private final Hash256 ledgerIndex;
    private final T newFields;

    private ImmutableCreatedNode(MetaLedgerEntryType ledgerEntryType, Hash256 ledgerIndex, T newFields) {
        this.ledgerEntryType = ledgerEntryType;
        this.ledgerIndex = ledgerIndex;
        this.newFields = newFields;
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public MetaLedgerEntryType ledgerEntryType() {
        return this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="LedgerIndex")
    public Hash256 ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="NewFields")
    public T newFields() {
        return this.newFields;
    }

    public final ImmutableCreatedNode<T> withLedgerEntryType(MetaLedgerEntryType value) {
        if (this.ledgerEntryType == value) {
            return this;
        }
        MetaLedgerEntryType newValue = Objects.requireNonNull(value, "ledgerEntryType");
        return new ImmutableCreatedNode<T>(newValue, this.ledgerIndex, this.newFields);
    }

    public final ImmutableCreatedNode<T> withLedgerIndex(Hash256 value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "ledgerIndex");
        return new ImmutableCreatedNode<T>(this.ledgerEntryType, newValue, this.newFields);
    }

    public final ImmutableCreatedNode<T> withNewFields(T value) {
        if (this.newFields == value) {
            return this;
        }
        MetaLedgerObject newValue = (MetaLedgerObject)Objects.requireNonNull(value, "newFields");
        return new ImmutableCreatedNode<MetaLedgerObject>(this.ledgerEntryType, this.ledgerIndex, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreatedNode && this.equalTo(0, (ImmutableCreatedNode)another);
    }

    private boolean equalTo(int synthetic, ImmutableCreatedNode<?> another) {
        return this.ledgerEntryType.equals(another.ledgerEntryType) && this.ledgerIndex.equals(another.ledgerIndex) && this.newFields.equals(another.newFields);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.ledgerIndex.hashCode();
        h += (h << 5) + this.newFields.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreatedNode").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("ledgerIndex", (Object)this.ledgerIndex).add("newFields", this.newFields).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends MetaLedgerObject> ImmutableCreatedNode<T> fromJson(Json<T> json) {
        Builder builder = ImmutableCreatedNode.builder();
        if (json.ledgerEntryType != null) {
            builder.ledgerEntryType(json.ledgerEntryType);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.newFields != null) {
            builder.newFields(json.newFields);
        }
        return builder.build();
    }

    public static <T extends MetaLedgerObject> ImmutableCreatedNode<T> copyOf(CreatedNode<T> instance) {
        if (instance instanceof ImmutableCreatedNode) {
            return (ImmutableCreatedNode)instance;
        }
        return ImmutableCreatedNode.builder().from(instance).build();
    }

    public static <T extends MetaLedgerObject> Builder<T> builder() {
        return new Builder();
    }

    /* synthetic */ ImmutableCreatedNode(MetaLedgerEntryType x0, Hash256 x1, MetaLedgerObject x2, 1 x3) {
        this(x0, x1, x2);
    }

    @Generated(from="CreatedNode", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends MetaLedgerObject> {
        private static final long INIT_BIT_LEDGER_ENTRY_TYPE = 1L;
        private static final long INIT_BIT_LEDGER_INDEX = 2L;
        private static final long INIT_BIT_NEW_FIELDS = 4L;
        private long initBits = 7L;
        @Nullable
        private MetaLedgerEntryType ledgerEntryType;
        @Nullable
        private Hash256 ledgerIndex;
        @Nullable
        private T newFields;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(AffectedNode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(CreatedNode<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AffectedNode instance;
            long bits = 0L;
            if (object instanceof AffectedNode) {
                instance = (AffectedNode)object;
                if ((bits & 1L) == 0L) {
                    this.ledgerEntryType(instance.ledgerEntryType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.ledgerIndex(instance.ledgerIndex());
                    bits |= 2L;
                }
            }
            if (object instanceof CreatedNode) {
                instance = (CreatedNode)object;
                if ((bits & 1L) == 0L) {
                    this.ledgerEntryType(instance.ledgerEntryType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.ledgerIndex(instance.ledgerIndex());
                    bits |= 2L;
                }
                this.newFields(instance.newFields());
            }
        }

        @JsonProperty(value="LedgerEntryType")
        @CanIgnoreReturnValue
        public final Builder<T> ledgerEntryType(MetaLedgerEntryType ledgerEntryType) {
            this.ledgerEntryType = Objects.requireNonNull(ledgerEntryType, "ledgerEntryType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="LedgerIndex")
        @CanIgnoreReturnValue
        public final Builder<T> ledgerIndex(Hash256 ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="NewFields")
        @CanIgnoreReturnValue
        public final Builder<T> newFields(T newFields) {
            this.newFields = (MetaLedgerObject)Objects.requireNonNull(newFields, "newFields");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableCreatedNode<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreatedNode(this.ledgerEntryType, this.ledgerIndex, (MetaLedgerObject)this.newFields, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ledgerEntryType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ledgerIndex");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("newFields");
            }
            return "Cannot build CreatedNode, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CreatedNode", generator="Immutables")
    static final class Json<T extends MetaLedgerObject>
    implements CreatedNode<T> {
        @Nullable
        MetaLedgerEntryType ledgerEntryType;
        @Nullable
        Hash256 ledgerIndex;
        @Nullable
        T newFields;

        Json() {
        }

        @JsonProperty(value="LedgerEntryType")
        public void setLedgerEntryType(MetaLedgerEntryType ledgerEntryType) {
            this.ledgerEntryType = ledgerEntryType;
        }

        @JsonProperty(value="LedgerIndex")
        public void setLedgerIndex(Hash256 ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="NewFields")
        public void setNewFields(T newFields) {
            this.newFields = newFields;
        }

        @Override
        public MetaLedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T newFields() {
            throw new UnsupportedOperationException();
        }
    }
}

