/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.metadata.CreatedNode;
import org.xrpl.xrpl4j.model.transactions.metadata.DeletedNode;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerEntryType;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerObject;
import org.xrpl.xrpl4j.model.transactions.metadata.ModifiedNode;

public interface AffectedNode {
    default public <T extends MetaLedgerObject> void handle(Consumer<CreatedNode<T>> createdNodeConsumer, Consumer<ModifiedNode<T>> modifiedNodeConsumer, Consumer<DeletedNode<T>> deletedNodeConsumer) {
        Objects.requireNonNull(createdNodeConsumer);
        Objects.requireNonNull(modifiedNodeConsumer);
        Objects.requireNonNull(deletedNodeConsumer);
        if (CreatedNode.class.isAssignableFrom(this.getClass())) {
            createdNodeConsumer.accept((CreatedNode)this);
        } else if (ModifiedNode.class.isAssignableFrom(this.getClass())) {
            modifiedNodeConsumer.accept((ModifiedNode)this);
        } else if (DeletedNode.class.isAssignableFrom(this.getClass())) {
            deletedNodeConsumer.accept((DeletedNode)this);
        } else {
            throw new IllegalStateException(String.format("Unsupported AffectedNode type: %s", this.getClass()));
        }
    }

    default public <T extends MetaLedgerObject, R> R map(Function<CreatedNode<T>, R> createdNodeMapper, Function<ModifiedNode<T>, R> modifiedNodeMapper, Function<DeletedNode<T>, R> deletedNodeMapper) {
        Objects.requireNonNull(createdNodeMapper);
        Objects.requireNonNull(modifiedNodeMapper);
        Objects.requireNonNull(deletedNodeMapper);
        if (CreatedNode.class.isAssignableFrom(this.getClass())) {
            return createdNodeMapper.apply((CreatedNode)this);
        }
        if (ModifiedNode.class.isAssignableFrom(this.getClass())) {
            return modifiedNodeMapper.apply((ModifiedNode)this);
        }
        if (DeletedNode.class.isAssignableFrom(this.getClass())) {
            return deletedNodeMapper.apply((DeletedNode)this);
        }
        throw new IllegalStateException(String.format("Unsupported AffectedNode type: %s", this.getClass()));
    }

    @JsonProperty(value="LedgerEntryType")
    public MetaLedgerEntryType ledgerEntryType();

    @JsonProperty(value="LedgerIndex")
    public Hash256 ledgerIndex();
}

