/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Objects;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.immutables.FluentCompareTo;
import org.xrpl.xrpl4j.model.immutables.Wrapped;
import org.xrpl.xrpl4j.model.immutables.Wrapper;
import org.xrpl.xrpl4j.model.jackson.modules.AddressDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.AddressSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.DidDataDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.DidDataSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.DidDocumentDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.DidDocumentSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.DidUriDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.DidUriSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.Hash256Deserializer;
import org.xrpl.xrpl4j.model.jackson.modules.Hash256Serializer;
import org.xrpl.xrpl4j.model.jackson.modules.MarkerDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.MarkerSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.NetworkIdDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.NetworkIdSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.NfTokenIdDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.NfTokenIdSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.NfTokenUriSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.TradingFeeDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.TradingFeeSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.TransferFeeDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.TransferFeeSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.VoteWeightDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.VoteWeightSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.XChainClaimIdDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.XChainClaimIdSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.XChainCountDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.XChainCountSerializer;
import org.xrpl.xrpl4j.model.jackson.modules.XrpCurrencyAmountDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.XrpCurrencyAmountSerializer;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.DidData;
import org.xrpl.xrpl4j.model.transactions.DidDocument;
import org.xrpl.xrpl4j.model.transactions.DidUri;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;
import org.xrpl.xrpl4j.model.transactions.NetworkId;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;
import org.xrpl.xrpl4j.model.transactions.NfTokenUri;
import org.xrpl.xrpl4j.model.transactions.TradingFee;
import org.xrpl.xrpl4j.model.transactions.TransferFee;
import org.xrpl.xrpl4j.model.transactions.VoteWeight;
import org.xrpl.xrpl4j.model.transactions.XAddress;
import org.xrpl.xrpl4j.model.transactions.XChainClaimId;
import org.xrpl.xrpl4j.model.transactions.XChainCount;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

public class Wrappers {

    @JsonSerialize(as=DidData.class, using=DidDataSerializer.class)
    @JsonDeserialize(as=DidData.class, using=DidDataDeserializer.class)
    @Value.Immutable
    @Wrapped
    @Beta
    static abstract class _DidData
    extends Wrapper<String>
    implements Serializable {
        _DidData() {
        }

        @Override
        public String toString() {
            return (String)this.value();
        }
    }

    @JsonSerialize(as=DidUri.class, using=DidUriSerializer.class)
    @JsonDeserialize(as=DidUri.class, using=DidUriDeserializer.class)
    @Value.Immutable
    @Wrapped
    @Beta
    static abstract class _DidUri
    extends Wrapper<String>
    implements Serializable {
        _DidUri() {
        }

        @Override
        public String toString() {
            return (String)this.value();
        }
    }

    @JsonSerialize(as=DidDocument.class, using=DidDocumentSerializer.class)
    @JsonDeserialize(as=DidDocument.class, using=DidDocumentDeserializer.class)
    @Value.Immutable
    @Wrapped
    @Beta
    static abstract class _DidDocument
    extends Wrapper<String>
    implements Serializable {
        _DidDocument() {
        }

        @Override
        public String toString() {
            return (String)this.value();
        }
    }

    @JsonSerialize(as=XChainCount.class, using=XChainCountSerializer.class)
    @JsonDeserialize(as=XChainCount.class, using=XChainCountDeserializer.class)
    @Value.Immutable
    @Wrapped
    @Beta
    static abstract class _XChainCount
    extends Wrapper<UnsignedLong>
    implements Serializable {
        _XChainCount() {
        }

        @Override
        public String toString() {
            return ((UnsignedLong)this.value()).toString();
        }
    }

    @JsonSerialize(as=XChainClaimId.class, using=XChainClaimIdSerializer.class)
    @JsonDeserialize(as=XChainClaimId.class, using=XChainClaimIdDeserializer.class)
    @Value.Immutable
    @Wrapped
    @Beta
    static abstract class _XChainClaimId
    extends Wrapper<UnsignedLong>
    implements Serializable {
        _XChainClaimId() {
        }

        @Override
        public String toString() {
            return ((UnsignedLong)this.value()).toString();
        }
    }

    @JsonSerialize(as=VoteWeight.class, using=VoteWeightSerializer.class)
    @JsonDeserialize(as=VoteWeight.class, using=VoteWeightDeserializer.class)
    @Value.Immutable
    @Wrapped
    @Beta
    static abstract class _VoteWeight
    extends Wrapper<UnsignedInteger>
    implements Serializable {
        _VoteWeight() {
        }

        @Override
        public String toString() {
            return ((UnsignedInteger)this.value()).toString();
        }

        public BigDecimal bigDecimalValue() {
            return BigDecimal.valueOf(((UnsignedInteger)this.value()).longValue(), 3);
        }
    }

    @JsonSerialize(as=TradingFee.class, using=TradingFeeSerializer.class)
    @JsonDeserialize(as=TradingFee.class, using=TradingFeeDeserializer.class)
    @Value.Immutable
    @Wrapped
    @Beta
    static abstract class _TradingFee
    extends Wrapper<UnsignedInteger>
    implements Serializable {
        _TradingFee() {
        }

        @Override
        public String toString() {
            return ((UnsignedInteger)this.value()).toString();
        }

        public static TradingFee ofPercent(BigDecimal percent) {
            Preconditions.checkArgument((Math.max(0, percent.stripTrailingZeros().scale()) <= 3 ? 1 : 0) != 0, (Object)"Percent value should have a maximum of 3 decimal places.");
            return TradingFee.of(UnsignedInteger.valueOf((BigInteger)percent.scaleByPowerOfTen(3).toBigIntegerExact()));
        }

        public BigDecimal bigDecimalValue() {
            return BigDecimal.valueOf(((UnsignedInteger)this.value()).longValue(), 3);
        }
    }

    @JsonSerialize(as=NetworkId.class, using=NetworkIdSerializer.class)
    @JsonDeserialize(as=NetworkId.class, using=NetworkIdDeserializer.class)
    @Value.Immutable
    @Wrapped
    static abstract class _NetworkId
    extends Wrapper<UnsignedInteger>
    implements Serializable {
        _NetworkId() {
        }

        @Override
        public String toString() {
            return ((UnsignedInteger)this.value()).toString();
        }

        public static NetworkId of(long networkId) {
            return NetworkId.of(UnsignedInteger.valueOf((long)networkId));
        }
    }

    @JsonSerialize(as=TransferFee.class, using=TransferFeeSerializer.class)
    @JsonDeserialize(as=TransferFee.class, using=TransferFeeDeserializer.class)
    @Value.Immutable
    @Wrapped
    static abstract class _TransferFee
    extends Wrapper<UnsignedInteger>
    implements Serializable {
        _TransferFee() {
        }

        @Override
        public String toString() {
            return ((UnsignedInteger)this.value()).toString();
        }

        public static TransferFee ofPercent(BigDecimal percent) {
            Objects.requireNonNull(percent);
            Preconditions.checkArgument((Math.max(0, percent.stripTrailingZeros().scale()) <= 3 ? 1 : 0) != 0, (Object)"Percent value should have a maximum of 3 decimal places.");
            return TransferFee.of(UnsignedInteger.valueOf((BigInteger)percent.scaleByPowerOfTen(3).toBigIntegerExact()));
        }

        @Value.Check
        public void validateBounds() {
            Preconditions.checkArgument((FluentCompareTo.is((UnsignedInteger)this.value()).lessThanOrEqualTo(UnsignedInteger.valueOf((long)50000L)) && FluentCompareTo.is((UnsignedInteger)this.value()).greaterThanEqualTo(UnsignedInteger.valueOf((long)0L)) ? 1 : 0) != 0, (Object)"TransferFee should be in the range 0 to 50000.");
        }
    }

    @JsonSerialize(as=NfTokenUri.class, using=NfTokenUriSerializer.class)
    @JsonDeserialize(as=NfTokenUri.class)
    @Value.Immutable
    @Wrapped
    static abstract class _NfTokenUri
    extends Wrapper<String>
    implements Serializable {
        _NfTokenUri() {
        }

        public static NfTokenUri ofPlainText(String plaintext) {
            return NfTokenUri.of(BaseEncoding.base16().encode(plaintext.getBytes(StandardCharsets.UTF_8)));
        }

        @Override
        public boolean equals(Object obj) {
            String otherValue;
            if (obj != null && obj instanceof NfTokenUri && (otherValue = ((NfTokenUri)obj).value()) != null) {
                return otherValue.toUpperCase(Locale.ENGLISH).equals(((String)this.value()).toUpperCase(Locale.ENGLISH));
            }
            return false;
        }
    }

    @JsonSerialize(as=NfTokenId.class, using=NfTokenIdSerializer.class)
    @JsonDeserialize(as=NfTokenId.class, using=NfTokenIdDeserializer.class)
    @Value.Immutable
    @Wrapped
    static abstract class _NfTokenId
    extends Wrapper<String>
    implements Serializable {
        _NfTokenId() {
        }

        @Override
        public String toString() {
            return (String)this.value();
        }

        @Value.Check
        public void validateLength() {
            Preconditions.checkArgument((((String)this.value()).length() == 64 ? 1 : 0) != 0, (Object)"TokenId must be 64 characters long.");
        }

        @Override
        public boolean equals(Object obj) {
            String otherValue;
            if (obj != null && obj instanceof NfTokenId && (otherValue = ((NfTokenId)obj).value()) != null) {
                return otherValue.toUpperCase(Locale.ENGLISH).equals(((String)this.value()).toUpperCase(Locale.ENGLISH));
            }
            return false;
        }
    }

    @JsonSerialize(as=Marker.class, using=MarkerSerializer.class)
    @JsonDeserialize(as=Marker.class, using=MarkerDeserializer.class)
    @Value.Immutable
    @Wrapped
    static abstract class _Marker
    extends Wrapper<String>
    implements Serializable {
        _Marker() {
        }

        @Override
        @JsonRawValue
        public String toString() {
            return (String)this.value();
        }
    }

    @JsonSerialize(as=XrpCurrencyAmount.class, using=XrpCurrencyAmountSerializer.class)
    @JsonDeserialize(as=XrpCurrencyAmount.class, using=XrpCurrencyAmountDeserializer.class)
    @Value.Immutable(builder=true)
    @Wrapped
    static abstract class _XrpCurrencyAmount
    extends Wrapper<UnsignedLong>
    implements Serializable,
    CurrencyAmount {
        static final BigDecimal SMALLEST_XRP = new BigDecimal("0.000001");
        static final DecimalFormat FORMATTER = new DecimalFormat("###,###");

        _XrpCurrencyAmount() {
        }

        public static XrpCurrencyAmount ofDrops(long drops) {
            return _XrpCurrencyAmount.ofDrops(UnsignedLong.valueOf((long)drops));
        }

        public static XrpCurrencyAmount ofDrops(UnsignedLong drops) {
            return XrpCurrencyAmount.of(drops);
        }

        public static XrpCurrencyAmount ofXrp(BigDecimal amount) {
            if (FluentCompareTo.is(amount).notEqualTo(BigDecimal.ZERO)) {
                Preconditions.checkArgument((boolean)FluentCompareTo.is(amount).greaterThanEqualTo(SMALLEST_XRP));
            }
            return _XrpCurrencyAmount.ofDrops(UnsignedLong.valueOf((BigInteger)amount.scaleByPowerOfTen(6).toBigIntegerExact()));
        }

        public BigDecimal toXrp() {
            return new BigDecimal(((UnsignedLong)this.value()).bigIntegerValue()).divide(BigDecimal.valueOf(1000000L), MathContext.DECIMAL128);
        }

        public XrpCurrencyAmount plus(XrpCurrencyAmount other) {
            return XrpCurrencyAmount.of(((UnsignedLong)this.value()).plus(other.value()));
        }

        public XrpCurrencyAmount minus(XrpCurrencyAmount other) {
            return XrpCurrencyAmount.of(((UnsignedLong)this.value()).minus(other.value()));
        }

        public XrpCurrencyAmount times(XrpCurrencyAmount other) {
            return XrpCurrencyAmount.of(((UnsignedLong)this.value()).times(other.value()));
        }

        @Override
        public String toString() {
            return ((UnsignedLong)this.value()).toString();
        }

        @Value.Check
        protected void check() {
            Preconditions.checkState((boolean)FluentCompareTo.is((UnsignedLong)this.value()).lessThanOrEqualTo(UnsignedLong.valueOf((long)100000000000000000L)), (Object)String.format("XRP Amounts may not exceed %s drops (100B XRP, denominated in Drops)", FORMATTER.format(100000000000000000L)));
        }
    }

    @JsonSerialize(as=Hash256.class, using=Hash256Serializer.class)
    @JsonDeserialize(as=Hash256.class, using=Hash256Deserializer.class)
    @Value.Immutable
    @Wrapped
    static abstract class _Hash256
    extends Wrapper<String>
    implements Serializable {
        _Hash256() {
        }

        @Override
        public String toString() {
            return (String)this.value();
        }

        @Value.Check
        public void validateLength() {
            Preconditions.checkArgument((((String)this.value()).length() == 64 ? 1 : 0) != 0, (Object)"Hash256 Strings must be 64 characters long.");
        }

        @Override
        public boolean equals(Object obj) {
            String otherValue;
            if (obj != null && obj instanceof Hash256 && (otherValue = ((Hash256)obj).value()) != null) {
                return otherValue.toUpperCase(Locale.ENGLISH).equals(((String)this.value()).toUpperCase(Locale.ENGLISH));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((String)this.value()).toUpperCase(Locale.ENGLISH).hashCode();
        }
    }

    @JsonSerialize(as=XAddress.class)
    @JsonDeserialize(as=XAddress.class)
    @Value.Immutable(builder=true)
    @Wrapped
    static abstract class _XAddress
    extends Wrapper<String>
    implements Serializable {
        _XAddress() {
        }

        @Override
        public String toString() {
            return (String)this.value();
        }
    }

    @JsonSerialize(as=Address.class, using=AddressSerializer.class)
    @JsonDeserialize(as=Address.class, using=AddressDeserializer.class)
    @Value.Immutable(builder=true)
    @Wrapped
    static abstract class _Address
    extends Wrapper<String>
    implements Serializable {
        _Address() {
        }

        @Override
        public String toString() {
            return (String)this.value();
        }

        @Value.Check
        public void validateAddress() {
            Preconditions.checkArgument((boolean)((String)this.value()).startsWith("r"), (Object)"Invalid Address: Bad Prefix");
            Preconditions.checkArgument((((String)this.value()).length() >= 25 && ((String)this.value()).length() <= 35 ? 1 : 0) != 0, (Object)"Classic Addresses must be (25,35) characters long inclusive.");
        }
    }
}

