/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.primitives.UnsignedInteger;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.crypto.signing.Signature;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.ImmutableAccountDelete;
import org.xrpl.xrpl4j.model.transactions.ImmutableAccountSet;
import org.xrpl.xrpl4j.model.transactions.ImmutableAmmBid;
import org.xrpl.xrpl4j.model.transactions.ImmutableAmmCreate;
import org.xrpl.xrpl4j.model.transactions.ImmutableAmmDelete;
import org.xrpl.xrpl4j.model.transactions.ImmutableAmmDeposit;
import org.xrpl.xrpl4j.model.transactions.ImmutableAmmVote;
import org.xrpl.xrpl4j.model.transactions.ImmutableAmmWithdraw;
import org.xrpl.xrpl4j.model.transactions.ImmutableCheckCancel;
import org.xrpl.xrpl4j.model.transactions.ImmutableCheckCash;
import org.xrpl.xrpl4j.model.transactions.ImmutableCheckCreate;
import org.xrpl.xrpl4j.model.transactions.ImmutableClawback;
import org.xrpl.xrpl4j.model.transactions.ImmutableDepositPreAuth;
import org.xrpl.xrpl4j.model.transactions.ImmutableDidDelete;
import org.xrpl.xrpl4j.model.transactions.ImmutableDidSet;
import org.xrpl.xrpl4j.model.transactions.ImmutableEnableAmendment;
import org.xrpl.xrpl4j.model.transactions.ImmutableEscrowCancel;
import org.xrpl.xrpl4j.model.transactions.ImmutableEscrowCreate;
import org.xrpl.xrpl4j.model.transactions.ImmutableEscrowFinish;
import org.xrpl.xrpl4j.model.transactions.ImmutableNfTokenAcceptOffer;
import org.xrpl.xrpl4j.model.transactions.ImmutableNfTokenBurn;
import org.xrpl.xrpl4j.model.transactions.ImmutableNfTokenCancelOffer;
import org.xrpl.xrpl4j.model.transactions.ImmutableNfTokenCreateOffer;
import org.xrpl.xrpl4j.model.transactions.ImmutableNfTokenMint;
import org.xrpl.xrpl4j.model.transactions.ImmutableOfferCancel;
import org.xrpl.xrpl4j.model.transactions.ImmutableOfferCreate;
import org.xrpl.xrpl4j.model.transactions.ImmutablePayment;
import org.xrpl.xrpl4j.model.transactions.ImmutablePaymentChannelClaim;
import org.xrpl.xrpl4j.model.transactions.ImmutablePaymentChannelCreate;
import org.xrpl.xrpl4j.model.transactions.ImmutablePaymentChannelFund;
import org.xrpl.xrpl4j.model.transactions.ImmutableSetFee;
import org.xrpl.xrpl4j.model.transactions.ImmutableSetRegularKey;
import org.xrpl.xrpl4j.model.transactions.ImmutableSignerListSet;
import org.xrpl.xrpl4j.model.transactions.ImmutableTicketCreate;
import org.xrpl.xrpl4j.model.transactions.ImmutableTrustSet;
import org.xrpl.xrpl4j.model.transactions.ImmutableUnlModify;
import org.xrpl.xrpl4j.model.transactions.ImmutableXChainAccountCreateCommit;
import org.xrpl.xrpl4j.model.transactions.ImmutableXChainAddAccountCreateAttestation;
import org.xrpl.xrpl4j.model.transactions.ImmutableXChainAddClaimAttestation;
import org.xrpl.xrpl4j.model.transactions.ImmutableXChainClaim;
import org.xrpl.xrpl4j.model.transactions.ImmutableXChainCommit;
import org.xrpl.xrpl4j.model.transactions.ImmutableXChainCreateBridge;
import org.xrpl.xrpl4j.model.transactions.ImmutableXChainCreateClaimId;
import org.xrpl.xrpl4j.model.transactions.ImmutableXChainModifyBridge;
import org.xrpl.xrpl4j.model.transactions.MemoWrapper;
import org.xrpl.xrpl4j.model.transactions.NetworkId;
import org.xrpl.xrpl4j.model.transactions.SignerWrapper;
import org.xrpl.xrpl4j.model.transactions.TransactionType;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

public interface Transaction {
    public static final BiMap<Class<? extends Transaction>, TransactionType> typeMap = new ImmutableBiMap.Builder().put(ImmutableAccountSet.class, (Object)TransactionType.ACCOUNT_SET).put(ImmutableAccountDelete.class, (Object)TransactionType.ACCOUNT_DELETE).put(ImmutableCheckCancel.class, (Object)TransactionType.CHECK_CANCEL).put(ImmutableCheckCash.class, (Object)TransactionType.CHECK_CASH).put(ImmutableCheckCreate.class, (Object)TransactionType.CHECK_CREATE).put(ImmutableDepositPreAuth.class, (Object)TransactionType.DEPOSIT_PRE_AUTH).put(ImmutableEnableAmendment.class, (Object)TransactionType.ENABLE_AMENDMENT).put(ImmutableEscrowCancel.class, (Object)TransactionType.ESCROW_CANCEL).put(ImmutableEscrowCreate.class, (Object)TransactionType.ESCROW_CREATE).put(ImmutableEscrowFinish.class, (Object)TransactionType.ESCROW_FINISH).put(ImmutableNfTokenBurn.class, (Object)TransactionType.NFTOKEN_BURN).put(ImmutableNfTokenMint.class, (Object)TransactionType.NFTOKEN_MINT).put(ImmutableNfTokenAcceptOffer.class, (Object)TransactionType.NFTOKEN_ACCEPT_OFFER).put(ImmutableNfTokenCancelOffer.class, (Object)TransactionType.NFTOKEN_CANCEL_OFFER).put(ImmutableNfTokenCreateOffer.class, (Object)TransactionType.NFTOKEN_CREATE_OFFER).put(ImmutableOfferCancel.class, (Object)TransactionType.OFFER_CANCEL).put(ImmutableOfferCreate.class, (Object)TransactionType.OFFER_CREATE).put(ImmutablePayment.class, (Object)TransactionType.PAYMENT).put(ImmutablePaymentChannelClaim.class, (Object)TransactionType.PAYMENT_CHANNEL_CLAIM).put(ImmutablePaymentChannelCreate.class, (Object)TransactionType.PAYMENT_CHANNEL_CREATE).put(ImmutablePaymentChannelFund.class, (Object)TransactionType.PAYMENT_CHANNEL_FUND).put(ImmutableSetFee.class, (Object)TransactionType.SET_FEE).put(ImmutableSetRegularKey.class, (Object)TransactionType.SET_REGULAR_KEY).put(ImmutableSignerListSet.class, (Object)TransactionType.SIGNER_LIST_SET).put(ImmutableTrustSet.class, (Object)TransactionType.TRUST_SET).put(ImmutableTicketCreate.class, (Object)TransactionType.TICKET_CREATE).put(ImmutableUnlModify.class, (Object)TransactionType.UNL_MODIFY).put(ImmutableAmmBid.class, (Object)TransactionType.AMM_BID).put(ImmutableAmmCreate.class, (Object)TransactionType.AMM_CREATE).put(ImmutableAmmDeposit.class, (Object)TransactionType.AMM_DEPOSIT).put(ImmutableAmmVote.class, (Object)TransactionType.AMM_VOTE).put(ImmutableAmmWithdraw.class, (Object)TransactionType.AMM_WITHDRAW).put(ImmutableAmmDelete.class, (Object)TransactionType.AMM_DELETE).put(ImmutableClawback.class, (Object)TransactionType.CLAWBACK).put(ImmutableXChainAccountCreateCommit.class, (Object)TransactionType.XCHAIN_ACCOUNT_CREATE_COMMIT).put(ImmutableXChainAddAccountCreateAttestation.class, (Object)TransactionType.XCHAIN_ADD_ACCOUNT_CREATE_ATTESTATION).put(ImmutableXChainAddClaimAttestation.class, (Object)TransactionType.XCHAIN_ADD_CLAIM_ATTESTATION).put(ImmutableXChainClaim.class, (Object)TransactionType.XCHAIN_CLAIM).put(ImmutableXChainCommit.class, (Object)TransactionType.XCHAIN_COMMIT).put(ImmutableXChainCreateBridge.class, (Object)TransactionType.XCHAIN_CREATE_BRIDGE).put(ImmutableXChainCreateClaimId.class, (Object)TransactionType.XCHAIN_CREATE_CLAIM_ID).put(ImmutableXChainModifyBridge.class, (Object)TransactionType.XCHAIN_MODIFY_BRIDGE).put(ImmutableDidSet.class, (Object)TransactionType.DID_SET).put(ImmutableDidDelete.class, (Object)TransactionType.DID_DELETE).build();

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="TransactionType")
    default public TransactionType transactionType() {
        return (TransactionType)((Object)typeMap.get(this.getClass()));
    }

    @JsonProperty(value="Fee")
    public XrpCurrencyAmount fee();

    @JsonProperty(value="Sequence")
    @Value.Default
    default public UnsignedInteger sequence() {
        return UnsignedInteger.ZERO;
    }

    @JsonProperty(value="TicketSequence")
    public Optional<UnsignedInteger> ticketSequence();

    @JsonProperty(value="AccountTxnID")
    public Optional<Hash256> accountTransactionId();

    @JsonProperty(value="LastLedgerSequence")
    public Optional<UnsignedInteger> lastLedgerSequence();

    @JsonProperty(value="Memos")
    public List<MemoWrapper> memos();

    @JsonProperty(value="Signers")
    public List<SignerWrapper> signers();

    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag();

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="SigningPubKey")
    @Value.Default
    default public PublicKey signingPublicKey() {
        return PublicKey.MULTI_SIGN_PUBLIC_KEY;
    }

    @JsonProperty(value="TxnSignature")
    public Optional<Signature> transactionSignature();

    @JsonProperty(value="NetworkID")
    public Optional<NetworkId> networkId();
}

