/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedLong;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.NfTokenCreateOfferFlags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.ImmutableNfTokenCreateOffer;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@JsonSerialize(as=ImmutableNfTokenCreateOffer.class)
@JsonDeserialize(as=ImmutableNfTokenCreateOffer.class)
@Value.Immutable
public interface NfTokenCreateOffer
extends Transaction {
    public static ImmutableNfTokenCreateOffer.Builder builder() {
        return ImmutableNfTokenCreateOffer.builder();
    }

    @Override
    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="NFTokenID")
    public NfTokenId nfTokenId();

    @JsonProperty(value="Amount")
    public CurrencyAmount amount();

    @JsonProperty(value="Owner")
    public Optional<Address> owner();

    @JsonProperty(value="Expiration")
    public Optional<UnsignedLong> expiration();

    @JsonProperty(value="Destination")
    public Optional<Address> destination();

    @JsonProperty(value="Flags")
    @Value.Default
    default public NfTokenCreateOfferFlags flags() {
        return NfTokenCreateOfferFlags.empty();
    }
}

