/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.List;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.TransactionFlags;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.ImmutableNfTokenCancelOffer;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@JsonSerialize(as=ImmutableNfTokenCancelOffer.class)
@JsonDeserialize(as=ImmutableNfTokenCancelOffer.class)
@Value.Immutable
public interface NfTokenCancelOffer
extends Transaction {
    public static ImmutableNfTokenCancelOffer.Builder builder() {
        return ImmutableNfTokenCancelOffer.builder();
    }

    @JsonProperty(value="NFTokenOffers")
    public List<Hash256> tokenOffers();

    @Value.Check
    default public void nonEmptyTokenOffers() {
        Preconditions.checkArgument((this.tokenOffers().size() > 0 ? 1 : 0) != 0, (Object)String.format("List of token offers must be non-empty.", new Object[0]));
    }

    @JsonProperty(value="Flags")
    @Value.Default
    default public TransactionFlags flags() {
        return TransactionFlags.EMPTY;
    }
}

