/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.TransactionFlags;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.ImmutableNfTokenAcceptOffer;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@JsonSerialize(as=ImmutableNfTokenAcceptOffer.class)
@JsonDeserialize(as=ImmutableNfTokenAcceptOffer.class)
@Value.Immutable
public interface NfTokenAcceptOffer
extends Transaction {
    public static ImmutableNfTokenAcceptOffer.Builder builder() {
        return ImmutableNfTokenAcceptOffer.builder();
    }

    @JsonProperty(value="NFTokenSellOffer")
    public Optional<Hash256> sellOffer();

    @JsonProperty(value="NFTokenBuyOffer")
    public Optional<Hash256> buyOffer();

    @JsonProperty(value="NFTokenBrokerFee")
    public Optional<CurrencyAmount> brokerFee();

    @Value.Check
    default public void brokerFeeNotPresentInDirectModeAndAtleastOneOfferPresent() {
        Preconditions.checkState((this.buyOffer().isPresent() || this.sellOffer().isPresent() ? 1 : 0) != 0, (Object)"PLease specify one offer for direct mode and both offers for brokered mode.");
        if (!(!this.buyOffer().isPresent() && !this.sellOffer().isPresent() || this.buyOffer().isPresent() && this.sellOffer().isPresent())) {
            Preconditions.checkState((!this.brokerFee().isPresent() ? 1 : 0) != 0, (Object)"No BrokerFee needed in direct mode.");
        }
    }

    @JsonProperty(value="Flags")
    @Value.Default
    default public TransactionFlags flags() {
        return TransactionFlags.EMPTY;
    }
}

