/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.transactions.ImmutableMemo;

@JsonSerialize(as=ImmutableMemo.class)
@JsonDeserialize(as=ImmutableMemo.class)
@Value.Immutable
public abstract class Memo {
    public static ImmutableMemo.Builder withPlaintext(String plaintext) {
        return Memo.builder().memoFormat(BaseEncoding.base16().encode("text/plain".getBytes(StandardCharsets.UTF_8))).memoData(BaseEncoding.base16().encode(plaintext.getBytes(StandardCharsets.UTF_8)));
    }

    public static ImmutableMemo.Builder builder() {
        return ImmutableMemo.builder();
    }

    @JsonProperty(value="MemoData")
    public abstract Optional<String> memoData();

    @JsonProperty(value="MemoFormat")
    public abstract Optional<String> memoFormat();

    @JsonProperty(value="MemoType")
    public abstract Optional<String> memoType();

    @Value.Check
    void check() {
        this.memoData().ifPresent(memoData -> Preconditions.checkState((boolean)Memo.isHex(memoData), (Object)"MemoData must be a hex-encoded string"));
        this.memoFormat().ifPresent(memoFormat -> Preconditions.checkState((boolean)Memo.isHex(memoFormat), (Object)"MemoFormat must be a hex-encoded string"));
        this.memoType().ifPresent(memoType -> Preconditions.checkState((boolean)Memo.isHex(memoType), (Object)"MemoType must be a hex-encoded string"));
    }

    private static boolean isHex(String input) {
        Objects.requireNonNull(input);
        for (char c : input.toCharArray()) {
            if (Memo.isHex(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHex(char input) {
        return input >= '0' && input <= '9' || input >= 'a' && input <= 'f' || input >= 'A' && input <= 'F';
    }
}

