/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.ledger.Issue;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="XChainBridge", generator="Immutables")
@Immutable
public final class ImmutableXChainBridge
implements XChainBridge {
    private final Address issuingChainDoor;
    private final Issue issuingChainIssue;
    private final Address lockingChainDoor;
    private final Issue lockingChainIssue;

    private ImmutableXChainBridge(Address issuingChainDoor, Issue issuingChainIssue, Address lockingChainDoor, Issue lockingChainIssue) {
        this.issuingChainDoor = issuingChainDoor;
        this.issuingChainIssue = issuingChainIssue;
        this.lockingChainDoor = lockingChainDoor;
        this.lockingChainIssue = lockingChainIssue;
    }

    @Override
    @JsonProperty(value="IssuingChainDoor")
    public Address issuingChainDoor() {
        return this.issuingChainDoor;
    }

    @Override
    @JsonProperty(value="IssuingChainIssue")
    public Issue issuingChainIssue() {
        return this.issuingChainIssue;
    }

    @Override
    @JsonProperty(value="LockingChainDoor")
    public Address lockingChainDoor() {
        return this.lockingChainDoor;
    }

    @Override
    @JsonProperty(value="LockingChainIssue")
    public Issue lockingChainIssue() {
        return this.lockingChainIssue;
    }

    public final ImmutableXChainBridge withIssuingChainDoor(Address value) {
        if (this.issuingChainDoor == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "issuingChainDoor");
        return new ImmutableXChainBridge(newValue, this.issuingChainIssue, this.lockingChainDoor, this.lockingChainIssue);
    }

    public final ImmutableXChainBridge withIssuingChainIssue(Issue value) {
        if (this.issuingChainIssue == value) {
            return this;
        }
        Issue newValue = Objects.requireNonNull(value, "issuingChainIssue");
        return new ImmutableXChainBridge(this.issuingChainDoor, newValue, this.lockingChainDoor, this.lockingChainIssue);
    }

    public final ImmutableXChainBridge withLockingChainDoor(Address value) {
        if (this.lockingChainDoor == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "lockingChainDoor");
        return new ImmutableXChainBridge(this.issuingChainDoor, this.issuingChainIssue, newValue, this.lockingChainIssue);
    }

    public final ImmutableXChainBridge withLockingChainIssue(Issue value) {
        if (this.lockingChainIssue == value) {
            return this;
        }
        Issue newValue = Objects.requireNonNull(value, "lockingChainIssue");
        return new ImmutableXChainBridge(this.issuingChainDoor, this.issuingChainIssue, this.lockingChainDoor, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableXChainBridge && this.equalTo(0, (ImmutableXChainBridge)another);
    }

    private boolean equalTo(int synthetic, ImmutableXChainBridge another) {
        return this.issuingChainDoor.equals(another.issuingChainDoor) && this.issuingChainIssue.equals(another.issuingChainIssue) && this.lockingChainDoor.equals(another.lockingChainDoor) && this.lockingChainIssue.equals(another.lockingChainIssue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.issuingChainDoor.hashCode();
        h += (h << 5) + this.issuingChainIssue.hashCode();
        h += (h << 5) + this.lockingChainDoor.hashCode();
        h += (h << 5) + this.lockingChainIssue.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"XChainBridge").omitNullValues().add("issuingChainDoor", (Object)this.issuingChainDoor).add("issuingChainIssue", (Object)this.issuingChainIssue).add("lockingChainDoor", (Object)this.lockingChainDoor).add("lockingChainIssue", (Object)this.lockingChainIssue).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableXChainBridge fromJson(Json json) {
        Builder builder = ImmutableXChainBridge.builder();
        if (json.issuingChainDoor != null) {
            builder.issuingChainDoor(json.issuingChainDoor);
        }
        if (json.issuingChainIssue != null) {
            builder.issuingChainIssue(json.issuingChainIssue);
        }
        if (json.lockingChainDoor != null) {
            builder.lockingChainDoor(json.lockingChainDoor);
        }
        if (json.lockingChainIssue != null) {
            builder.lockingChainIssue(json.lockingChainIssue);
        }
        return builder.build();
    }

    public static ImmutableXChainBridge copyOf(XChainBridge instance) {
        if (instance instanceof ImmutableXChainBridge) {
            return (ImmutableXChainBridge)instance;
        }
        return ImmutableXChainBridge.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="XChainBridge", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ISSUING_CHAIN_DOOR = 1L;
        private static final long INIT_BIT_ISSUING_CHAIN_ISSUE = 2L;
        private static final long INIT_BIT_LOCKING_CHAIN_DOOR = 4L;
        private static final long INIT_BIT_LOCKING_CHAIN_ISSUE = 8L;
        private long initBits = 15L;
        @Nullable
        private Address issuingChainDoor;
        @Nullable
        private Issue issuingChainIssue;
        @Nullable
        private Address lockingChainDoor;
        @Nullable
        private Issue lockingChainIssue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XChainBridge instance) {
            Objects.requireNonNull(instance, "instance");
            this.issuingChainDoor(instance.issuingChainDoor());
            this.issuingChainIssue(instance.issuingChainIssue());
            this.lockingChainDoor(instance.lockingChainDoor());
            this.lockingChainIssue(instance.lockingChainIssue());
            return this;
        }

        @JsonProperty(value="IssuingChainDoor")
        @CanIgnoreReturnValue
        public final Builder issuingChainDoor(Address issuingChainDoor) {
            this.issuingChainDoor = Objects.requireNonNull(issuingChainDoor, "issuingChainDoor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="IssuingChainIssue")
        @CanIgnoreReturnValue
        public final Builder issuingChainIssue(Issue issuingChainIssue) {
            this.issuingChainIssue = Objects.requireNonNull(issuingChainIssue, "issuingChainIssue");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="LockingChainDoor")
        @CanIgnoreReturnValue
        public final Builder lockingChainDoor(Address lockingChainDoor) {
            this.lockingChainDoor = Objects.requireNonNull(lockingChainDoor, "lockingChainDoor");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="LockingChainIssue")
        @CanIgnoreReturnValue
        public final Builder lockingChainIssue(Issue lockingChainIssue) {
            this.lockingChainIssue = Objects.requireNonNull(lockingChainIssue, "lockingChainIssue");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableXChainBridge build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableXChainBridge(this.issuingChainDoor, this.issuingChainIssue, this.lockingChainDoor, this.lockingChainIssue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("issuingChainDoor");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("issuingChainIssue");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lockingChainDoor");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lockingChainIssue");
            }
            return "Cannot build XChainBridge, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="XChainBridge", generator="Immutables")
    static final class Json
    implements XChainBridge {
        @Nullable
        Address issuingChainDoor;
        @Nullable
        Issue issuingChainIssue;
        @Nullable
        Address lockingChainDoor;
        @Nullable
        Issue lockingChainIssue;

        Json() {
        }

        @JsonProperty(value="IssuingChainDoor")
        public void setIssuingChainDoor(Address issuingChainDoor) {
            this.issuingChainDoor = issuingChainDoor;
        }

        @JsonProperty(value="IssuingChainIssue")
        public void setIssuingChainIssue(Issue issuingChainIssue) {
            this.issuingChainIssue = issuingChainIssue;
        }

        @JsonProperty(value="LockingChainDoor")
        public void setLockingChainDoor(Address lockingChainDoor) {
            this.lockingChainDoor = lockingChainDoor;
        }

        @JsonProperty(value="LockingChainIssue")
        public void setLockingChainIssue(Issue lockingChainIssue) {
            this.lockingChainIssue = lockingChainIssue;
        }

        @Override
        public Address issuingChainDoor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Issue issuingChainIssue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address lockingChainDoor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Issue lockingChainIssue() {
            throw new UnsupportedOperationException();
        }
    }
}

