/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;
import org.xrpl.xrpl4j.model.transactions.TransactionMetadata;
import org.xrpl.xrpl4j.model.transactions.metadata.AffectedNode;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionMetadata", generator="Immutables")
@Immutable
public final class ImmutableTransactionMetadata
implements TransactionMetadata {
    private final UnsignedInteger transactionIndex;
    private final String transactionResult;
    @Nullable
    private final CurrencyAmount deliveredAmount;
    @Nullable
    private final NfTokenId nfTokenId;
    private final ImmutableList<NfTokenId> nfTokenIds;
    @Nullable
    private final Hash256 offerId;
    private final ImmutableList<AffectedNode> affectedNodes;

    private ImmutableTransactionMetadata(UnsignedInteger transactionIndex, String transactionResult, @Nullable CurrencyAmount deliveredAmount, @Nullable NfTokenId nfTokenId, ImmutableList<NfTokenId> nfTokenIds, @Nullable Hash256 offerId, ImmutableList<AffectedNode> affectedNodes) {
        this.transactionIndex = transactionIndex;
        this.transactionResult = transactionResult;
        this.deliveredAmount = deliveredAmount;
        this.nfTokenId = nfTokenId;
        this.nfTokenIds = nfTokenIds;
        this.offerId = offerId;
        this.affectedNodes = affectedNodes;
    }

    @Override
    @JsonProperty(value="TransactionIndex")
    public UnsignedInteger transactionIndex() {
        return this.transactionIndex;
    }

    @Override
    @JsonProperty(value="TransactionResult")
    public String transactionResult() {
        return this.transactionResult;
    }

    @Override
    @JsonProperty(value="delivered_amount")
    public Optional<CurrencyAmount> deliveredAmount() {
        return Optional.ofNullable(this.deliveredAmount);
    }

    @Override
    @JsonProperty(value="nftoken_id")
    public Optional<NfTokenId> nfTokenId() {
        return Optional.ofNullable(this.nfTokenId);
    }

    @JsonProperty(value="nftoken_ids")
    public ImmutableList<NfTokenId> nfTokenIds() {
        return this.nfTokenIds;
    }

    @Override
    @JsonProperty(value="offer_id")
    public Optional<Hash256> offerId() {
        return Optional.ofNullable(this.offerId);
    }

    @JsonProperty(value="AffectedNodes")
    public ImmutableList<AffectedNode> affectedNodes() {
        return this.affectedNodes;
    }

    public final ImmutableTransactionMetadata withTransactionIndex(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "transactionIndex");
        if (this.transactionIndex.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTransactionMetadata(newValue, this.transactionResult, this.deliveredAmount, this.nfTokenId, this.nfTokenIds, this.offerId, this.affectedNodes);
    }

    public final ImmutableTransactionMetadata withTransactionResult(String value) {
        String newValue = Objects.requireNonNull(value, "transactionResult");
        if (this.transactionResult.equals(newValue)) {
            return this;
        }
        return new ImmutableTransactionMetadata(this.transactionIndex, newValue, this.deliveredAmount, this.nfTokenId, this.nfTokenIds, this.offerId, this.affectedNodes);
    }

    public final ImmutableTransactionMetadata withDeliveredAmount(CurrencyAmount value) {
        CurrencyAmount newValue = Objects.requireNonNull(value, "deliveredAmount");
        if (this.deliveredAmount == newValue) {
            return this;
        }
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, newValue, this.nfTokenId, this.nfTokenIds, this.offerId, this.affectedNodes);
    }

    public final ImmutableTransactionMetadata withDeliveredAmount(Optional<? extends CurrencyAmount> optional) {
        CurrencyAmount value = optional.orElse(null);
        if (this.deliveredAmount == value) {
            return this;
        }
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, value, this.nfTokenId, this.nfTokenIds, this.offerId, this.affectedNodes);
    }

    public final ImmutableTransactionMetadata withNfTokenId(NfTokenId value) {
        NfTokenId newValue = Objects.requireNonNull(value, "nfTokenId");
        if (this.nfTokenId == newValue) {
            return this;
        }
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, this.deliveredAmount, newValue, this.nfTokenIds, this.offerId, this.affectedNodes);
    }

    public final ImmutableTransactionMetadata withNfTokenId(Optional<? extends NfTokenId> optional) {
        NfTokenId value = optional.orElse(null);
        if (this.nfTokenId == value) {
            return this;
        }
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, this.deliveredAmount, value, this.nfTokenIds, this.offerId, this.affectedNodes);
    }

    public final ImmutableTransactionMetadata withNfTokenIds(NfTokenId ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, this.deliveredAmount, this.nfTokenId, (ImmutableList<NfTokenId>)newValue, this.offerId, this.affectedNodes);
    }

    public final ImmutableTransactionMetadata withNfTokenIds(Iterable<? extends NfTokenId> elements) {
        if (this.nfTokenIds == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, this.deliveredAmount, this.nfTokenId, (ImmutableList<NfTokenId>)newValue, this.offerId, this.affectedNodes);
    }

    public final ImmutableTransactionMetadata withOfferId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "offerId");
        if (this.offerId == newValue) {
            return this;
        }
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, this.deliveredAmount, this.nfTokenId, this.nfTokenIds, newValue, this.affectedNodes);
    }

    public final ImmutableTransactionMetadata withOfferId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.offerId == value) {
            return this;
        }
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, this.deliveredAmount, this.nfTokenId, this.nfTokenIds, value, this.affectedNodes);
    }

    public final ImmutableTransactionMetadata withAffectedNodes(AffectedNode ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, this.deliveredAmount, this.nfTokenId, this.nfTokenIds, this.offerId, (ImmutableList<AffectedNode>)newValue);
    }

    public final ImmutableTransactionMetadata withAffectedNodes(Iterable<? extends AffectedNode> elements) {
        if (this.affectedNodes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, this.deliveredAmount, this.nfTokenId, this.nfTokenIds, this.offerId, (ImmutableList<AffectedNode>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionMetadata && this.equalTo(0, (ImmutableTransactionMetadata)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransactionMetadata another) {
        return this.transactionIndex.equals((Object)another.transactionIndex) && this.transactionResult.equals(another.transactionResult) && Objects.equals(this.deliveredAmount, another.deliveredAmount) && Objects.equals(this.nfTokenId, another.nfTokenId) && this.nfTokenIds.equals(another.nfTokenIds) && Objects.equals(this.offerId, another.offerId) && this.affectedNodes.equals(another.affectedNodes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionIndex.hashCode();
        h += (h << 5) + this.transactionResult.hashCode();
        h += (h << 5) + Objects.hashCode(this.deliveredAmount);
        h += (h << 5) + Objects.hashCode(this.nfTokenId);
        h += (h << 5) + this.nfTokenIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.offerId);
        h += (h << 5) + this.affectedNodes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionMetadata").omitNullValues().add("transactionIndex", (Object)this.transactionIndex).add("transactionResult", (Object)this.transactionResult).add("deliveredAmount", (Object)this.deliveredAmount).add("nfTokenId", (Object)this.nfTokenId).add("nfTokenIds", this.nfTokenIds).add("offerId", (Object)this.offerId).add("affectedNodes", this.affectedNodes).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionMetadata fromJson(Json json) {
        Builder builder = ImmutableTransactionMetadata.builder();
        if (json.transactionIndex != null) {
            builder.transactionIndex(json.transactionIndex);
        }
        if (json.transactionResult != null) {
            builder.transactionResult(json.transactionResult);
        }
        if (json.deliveredAmount != null) {
            builder.deliveredAmount(json.deliveredAmount);
        }
        if (json.nfTokenId != null) {
            builder.nfTokenId(json.nfTokenId);
        }
        if (json.nfTokenIds != null) {
            builder.addAllNfTokenIds(json.nfTokenIds);
        }
        if (json.offerId != null) {
            builder.offerId(json.offerId);
        }
        if (json.affectedNodes != null) {
            builder.addAllAffectedNodes(json.affectedNodes);
        }
        return builder.build();
    }

    public static ImmutableTransactionMetadata copyOf(TransactionMetadata instance) {
        if (instance instanceof ImmutableTransactionMetadata) {
            return (ImmutableTransactionMetadata)instance;
        }
        return ImmutableTransactionMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionMetadata", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_INDEX = 1L;
        private static final long INIT_BIT_TRANSACTION_RESULT = 2L;
        private long initBits = 3L;
        @Nullable
        private UnsignedInteger transactionIndex;
        @Nullable
        private String transactionResult;
        @Nullable
        private CurrencyAmount deliveredAmount;
        @Nullable
        private NfTokenId nfTokenId;
        private ImmutableList.Builder<NfTokenId> nfTokenIds = ImmutableList.builder();
        @Nullable
        private Hash256 offerId;
        private ImmutableList.Builder<AffectedNode> affectedNodes = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TransactionMetadata instance) {
            Optional<NfTokenId> nfTokenIdOptional;
            Objects.requireNonNull(instance, "instance");
            this.transactionIndex(instance.transactionIndex());
            this.transactionResult(instance.transactionResult());
            Optional<CurrencyAmount> deliveredAmountOptional = instance.deliveredAmount();
            if (deliveredAmountOptional.isPresent()) {
                this.deliveredAmount(deliveredAmountOptional);
            }
            if ((nfTokenIdOptional = instance.nfTokenId()).isPresent()) {
                this.nfTokenId(nfTokenIdOptional);
            }
            this.addAllNfTokenIds(instance.nfTokenIds());
            Optional<Hash256> offerIdOptional = instance.offerId();
            if (offerIdOptional.isPresent()) {
                this.offerId(offerIdOptional);
            }
            this.addAllAffectedNodes(instance.affectedNodes());
            return this;
        }

        @JsonProperty(value="TransactionIndex")
        @CanIgnoreReturnValue
        public final Builder transactionIndex(UnsignedInteger transactionIndex) {
            this.transactionIndex = Objects.requireNonNull(transactionIndex, "transactionIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="TransactionResult")
        @CanIgnoreReturnValue
        public final Builder transactionResult(String transactionResult) {
            this.transactionResult = Objects.requireNonNull(transactionResult, "transactionResult");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deliveredAmount(CurrencyAmount deliveredAmount) {
            this.deliveredAmount = Objects.requireNonNull(deliveredAmount, "deliveredAmount");
            return this;
        }

        @JsonProperty(value="delivered_amount")
        @CanIgnoreReturnValue
        public final Builder deliveredAmount(Optional<? extends CurrencyAmount> deliveredAmount) {
            this.deliveredAmount = deliveredAmount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = Objects.requireNonNull(nfTokenId, "nfTokenId");
            return this;
        }

        @JsonProperty(value="nftoken_id")
        @CanIgnoreReturnValue
        public final Builder nfTokenId(Optional<? extends NfTokenId> nfTokenId) {
            this.nfTokenId = nfTokenId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNfTokenIds(NfTokenId element) {
            this.nfTokenIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNfTokenIds(NfTokenId ... elements) {
            this.nfTokenIds.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="nftoken_ids")
        @CanIgnoreReturnValue
        public final Builder nfTokenIds(Iterable<? extends NfTokenId> elements) {
            this.nfTokenIds = ImmutableList.builder();
            return this.addAllNfTokenIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNfTokenIds(Iterable<? extends NfTokenId> elements) {
            this.nfTokenIds.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder offerId(Hash256 offerId) {
            this.offerId = Objects.requireNonNull(offerId, "offerId");
            return this;
        }

        @JsonProperty(value="offer_id")
        @CanIgnoreReturnValue
        public final Builder offerId(Optional<? extends Hash256> offerId) {
            this.offerId = offerId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAffectedNodes(AffectedNode element) {
            this.affectedNodes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAffectedNodes(AffectedNode ... elements) {
            this.affectedNodes.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="AffectedNodes")
        @CanIgnoreReturnValue
        public final Builder affectedNodes(Iterable<? extends AffectedNode> elements) {
            this.affectedNodes = ImmutableList.builder();
            return this.addAllAffectedNodes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAffectedNodes(Iterable<? extends AffectedNode> elements) {
            this.affectedNodes.addAll(elements);
            return this;
        }

        public ImmutableTransactionMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, this.deliveredAmount, this.nfTokenId, this.nfTokenIds.build(), this.offerId, this.affectedNodes.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionIndex");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("transactionResult");
            }
            return "Cannot build TransactionMetadata, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionMetadata", generator="Immutables")
    static final class Json
    implements TransactionMetadata {
        @Nullable
        UnsignedInteger transactionIndex;
        @Nullable
        String transactionResult;
        @Nullable
        Optional<CurrencyAmount> deliveredAmount = Optional.empty();
        @Nullable
        Optional<NfTokenId> nfTokenId = Optional.empty();
        @Nullable
        List<NfTokenId> nfTokenIds = ImmutableList.of();
        @Nullable
        Optional<Hash256> offerId = Optional.empty();
        @Nullable
        List<AffectedNode> affectedNodes = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="TransactionIndex")
        public void setTransactionIndex(UnsignedInteger transactionIndex) {
            this.transactionIndex = transactionIndex;
        }

        @JsonProperty(value="TransactionResult")
        public void setTransactionResult(String transactionResult) {
            this.transactionResult = transactionResult;
        }

        @JsonProperty(value="delivered_amount")
        public void setDeliveredAmount(Optional<CurrencyAmount> deliveredAmount) {
            this.deliveredAmount = deliveredAmount;
        }

        @JsonProperty(value="nftoken_id")
        public void setNfTokenId(Optional<NfTokenId> nfTokenId) {
            this.nfTokenId = nfTokenId;
        }

        @JsonProperty(value="nftoken_ids")
        public void setNfTokenIds(List<NfTokenId> nfTokenIds) {
            this.nfTokenIds = nfTokenIds;
        }

        @JsonProperty(value="offer_id")
        public void setOfferId(Optional<Hash256> offerId) {
            this.offerId = offerId;
        }

        @JsonProperty(value="AffectedNodes")
        public void setAffectedNodes(List<AffectedNode> affectedNodes) {
            this.affectedNodes = affectedNodes;
        }

        @Override
        public UnsignedInteger transactionIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String transactionResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CurrencyAmount> deliveredAmount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NfTokenId> nfTokenId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<NfTokenId> nfTokenIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> offerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AffectedNode> affectedNodes() {
            throw new UnsupportedOperationException();
        }
    }
}

