/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.crypto.signing.Signature;
import org.xrpl.xrpl4j.model.flags.TransactionFlags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.MemoWrapper;
import org.xrpl.xrpl4j.model.transactions.NetworkId;
import org.xrpl.xrpl4j.model.transactions.SignerWrapper;
import org.xrpl.xrpl4j.model.transactions.TicketCreate;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TicketCreate", generator="Immutables")
@Immutable
public final class ImmutableTicketCreate
implements TicketCreate {
    private final Address account;
    private final XrpCurrencyAmount fee;
    private final UnsignedInteger sequence;
    @Nullable
    private final UnsignedInteger ticketSequence;
    @Nullable
    private final Hash256 accountTransactionId;
    @Nullable
    private final UnsignedInteger lastLedgerSequence;
    private final ImmutableList<MemoWrapper> memos;
    private final ImmutableList<SignerWrapper> signers;
    @Nullable
    private final UnsignedInteger sourceTag;
    private final PublicKey signingPublicKey;
    @Nullable
    private final Signature transactionSignature;
    @Nullable
    private final NetworkId networkId;
    private final UnsignedInteger ticketCount;
    private final TransactionFlags flags;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTicketCreate(Builder builder) {
        this.account = builder.account;
        this.fee = builder.fee;
        this.ticketSequence = builder.ticketSequence;
        this.accountTransactionId = builder.accountTransactionId;
        this.lastLedgerSequence = builder.lastLedgerSequence;
        this.memos = builder.memos.build();
        this.signers = builder.signers.build();
        this.sourceTag = builder.sourceTag;
        this.transactionSignature = builder.transactionSignature;
        this.networkId = builder.networkId;
        this.ticketCount = builder.ticketCount;
        if (builder.sequence != null) {
            this.initShim.sequence(builder.sequence);
        }
        if (builder.signingPublicKey != null) {
            this.initShim.signingPublicKey(builder.signingPublicKey);
        }
        if (builder.flags != null) {
            this.initShim.flags(builder.flags);
        }
        this.sequence = this.initShim.sequence();
        this.signingPublicKey = this.initShim.signingPublicKey();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableTicketCreate(Address account, XrpCurrencyAmount fee, UnsignedInteger sequence, @Nullable UnsignedInteger ticketSequence, @Nullable Hash256 accountTransactionId, @Nullable UnsignedInteger lastLedgerSequence, ImmutableList<MemoWrapper> memos, ImmutableList<SignerWrapper> signers, @Nullable UnsignedInteger sourceTag, PublicKey signingPublicKey, @Nullable Signature transactionSignature, @Nullable NetworkId networkId, UnsignedInteger ticketCount, TransactionFlags flags) {
        this.account = account;
        this.fee = fee;
        this.sequence = sequence;
        this.ticketSequence = ticketSequence;
        this.accountTransactionId = accountTransactionId;
        this.lastLedgerSequence = lastLedgerSequence;
        this.memos = memos;
        this.signers = signers;
        this.sourceTag = sourceTag;
        this.signingPublicKey = signingPublicKey;
        this.transactionSignature = transactionSignature;
        this.networkId = networkId;
        this.ticketCount = ticketCount;
        this.flags = flags;
        this.initShim = null;
    }

    private UnsignedInteger sequenceInitialize() {
        return TicketCreate.super.sequence();
    }

    private PublicKey signingPublicKeyInitialize() {
        return TicketCreate.super.signingPublicKey();
    }

    private TransactionFlags flagsInitialize() {
        return TicketCreate.super.flags();
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="Fee")
    public XrpCurrencyAmount fee() {
        return this.fee;
    }

    @Override
    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sequence() : this.sequence;
    }

    @Override
    @JsonProperty(value="TicketSequence")
    public Optional<UnsignedInteger> ticketSequence() {
        return Optional.ofNullable(this.ticketSequence);
    }

    @Override
    @JsonProperty(value="AccountTxnID")
    public Optional<Hash256> accountTransactionId() {
        return Optional.ofNullable(this.accountTransactionId);
    }

    @Override
    @JsonProperty(value="LastLedgerSequence")
    public Optional<UnsignedInteger> lastLedgerSequence() {
        return Optional.ofNullable(this.lastLedgerSequence);
    }

    @JsonProperty(value="Memos")
    public ImmutableList<MemoWrapper> memos() {
        return this.memos;
    }

    @JsonProperty(value="Signers")
    public ImmutableList<SignerWrapper> signers() {
        return this.signers;
    }

    @Override
    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag() {
        return Optional.ofNullable(this.sourceTag);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="SigningPubKey")
    public PublicKey signingPublicKey() {
        InitShim shim = this.initShim;
        return shim != null ? shim.signingPublicKey() : this.signingPublicKey;
    }

    @Override
    @JsonProperty(value="TxnSignature")
    public Optional<Signature> transactionSignature() {
        return Optional.ofNullable(this.transactionSignature);
    }

    @Override
    @JsonProperty(value="NetworkID")
    public Optional<NetworkId> networkId() {
        return Optional.ofNullable(this.networkId);
    }

    @Override
    @JsonProperty(value="TicketCount")
    public UnsignedInteger ticketCount() {
        return this.ticketCount;
    }

    @Override
    @JsonProperty(value="Flags")
    public TransactionFlags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    public final ImmutableTicketCreate withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableTicketCreate(newValue, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withFee(XrpCurrencyAmount value) {
        if (this.fee == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "fee");
        return new ImmutableTicketCreate(this.account, newValue, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (this.sequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, newValue, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withTicketSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "ticketSequence");
        if (Objects.equals(this.ticketSequence, newValue)) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, newValue, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withTicketSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.ticketSequence, value)) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, value, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withAccountTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "accountTransactionId");
        if (this.accountTransactionId == newValue) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, newValue, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withAccountTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.accountTransactionId == value) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, value, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withLastLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "lastLedgerSequence");
        if (Objects.equals(this.lastLedgerSequence, newValue)) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, newValue, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withLastLedgerSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.lastLedgerSequence, value)) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, value, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withMemos(MemoWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, (ImmutableList<MemoWrapper>)newValue, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withMemos(Iterable<? extends MemoWrapper> elements) {
        if (this.memos == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, (ImmutableList<MemoWrapper>)newValue, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withSigners(SignerWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, (ImmutableList<SignerWrapper>)newValue, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withSigners(Iterable<? extends SignerWrapper> elements) {
        if (this.signers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, (ImmutableList<SignerWrapper>)newValue, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withSourceTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sourceTag");
        if (Objects.equals(this.sourceTag, newValue)) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, newValue, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withSourceTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sourceTag, value)) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, value, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withSigningPublicKey(PublicKey value) {
        if (this.signingPublicKey == value) {
            return this;
        }
        PublicKey newValue = Objects.requireNonNull(value, "signingPublicKey");
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, newValue, this.transactionSignature, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withTransactionSignature(Signature value) {
        Signature newValue = Objects.requireNonNull(value, "transactionSignature");
        if (this.transactionSignature == newValue) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, newValue, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withTransactionSignature(Optional<? extends Signature> optional) {
        Signature value = optional.orElse(null);
        if (this.transactionSignature == value) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, value, this.networkId, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withNetworkId(NetworkId value) {
        NetworkId newValue = Objects.requireNonNull(value, "networkId");
        if (this.networkId == newValue) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, newValue, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withNetworkId(Optional<? extends NetworkId> optional) {
        NetworkId value = optional.orElse(null);
        if (this.networkId == value) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, value, this.ticketCount, this.flags);
    }

    public final ImmutableTicketCreate withTicketCount(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "ticketCount");
        if (this.ticketCount.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, newValue, this.flags);
    }

    public final ImmutableTicketCreate withFlags(TransactionFlags value) {
        if (this.flags == value) {
            return this;
        }
        TransactionFlags newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableTicketCreate(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.ticketCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTicketCreate && this.equalTo(0, (ImmutableTicketCreate)another);
    }

    private boolean equalTo(int synthetic, ImmutableTicketCreate another) {
        return this.account.equals(another.account) && this.fee.equals(another.fee) && this.sequence.equals((Object)another.sequence) && Objects.equals(this.ticketSequence, another.ticketSequence) && Objects.equals(this.accountTransactionId, another.accountTransactionId) && Objects.equals(this.lastLedgerSequence, another.lastLedgerSequence) && this.memos.equals(another.memos) && this.signers.equals(another.signers) && Objects.equals(this.sourceTag, another.sourceTag) && this.signingPublicKey.equals(another.signingPublicKey) && Objects.equals(this.transactionSignature, another.transactionSignature) && Objects.equals(this.networkId, another.networkId) && this.ticketCount.equals((Object)another.ticketCount) && this.flags.equals(another.flags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.fee.hashCode();
        h += (h << 5) + this.sequence.hashCode();
        h += (h << 5) + Objects.hashCode(this.ticketSequence);
        h += (h << 5) + Objects.hashCode(this.accountTransactionId);
        h += (h << 5) + Objects.hashCode(this.lastLedgerSequence);
        h += (h << 5) + this.memos.hashCode();
        h += (h << 5) + this.signers.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceTag);
        h += (h << 5) + this.signingPublicKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.transactionSignature);
        h += (h << 5) + Objects.hashCode(this.networkId);
        h += (h << 5) + this.ticketCount.hashCode();
        h += (h << 5) + this.flags.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TicketCreate").omitNullValues().add("account", (Object)this.account).add("fee", (Object)this.fee).add("sequence", (Object)this.sequence).add("ticketSequence", (Object)this.ticketSequence).add("accountTransactionId", (Object)this.accountTransactionId).add("lastLedgerSequence", (Object)this.lastLedgerSequence).add("memos", this.memos).add("signers", this.signers).add("sourceTag", (Object)this.sourceTag).add("signingPublicKey", (Object)this.signingPublicKey).add("transactionSignature", (Object)this.transactionSignature).add("networkId", (Object)this.networkId).add("ticketCount", (Object)this.ticketCount).add("flags", (Object)this.flags).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTicketCreate fromJson(Json json) {
        Builder builder = ImmutableTicketCreate.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.fee != null) {
            builder.fee(json.fee);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.ticketSequence != null) {
            builder.ticketSequence(json.ticketSequence);
        }
        if (json.accountTransactionId != null) {
            builder.accountTransactionId(json.accountTransactionId);
        }
        if (json.lastLedgerSequence != null) {
            builder.lastLedgerSequence(json.lastLedgerSequence);
        }
        if (json.memos != null) {
            builder.addAllMemos(json.memos);
        }
        if (json.signers != null) {
            builder.addAllSigners(json.signers);
        }
        if (json.sourceTag != null) {
            builder.sourceTag(json.sourceTag);
        }
        if (json.signingPublicKey != null) {
            builder.signingPublicKey(json.signingPublicKey);
        }
        if (json.transactionSignature != null) {
            builder.transactionSignature(json.transactionSignature);
        }
        if (json.networkId != null) {
            builder.networkId(json.networkId);
        }
        if (json.ticketCount != null) {
            builder.ticketCount(json.ticketCount);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        return builder.build();
    }

    public static ImmutableTicketCreate copyOf(TicketCreate instance) {
        if (instance instanceof ImmutableTicketCreate) {
            return (ImmutableTicketCreate)instance;
        }
        return ImmutableTicketCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TicketCreate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_FEE = 2L;
        private static final long INIT_BIT_TICKET_COUNT = 4L;
        private long initBits = 7L;
        @Nullable
        private Address account;
        @Nullable
        private XrpCurrencyAmount fee;
        @Nullable
        private UnsignedInteger sequence;
        @Nullable
        private UnsignedInteger ticketSequence;
        @Nullable
        private Hash256 accountTransactionId;
        @Nullable
        private UnsignedInteger lastLedgerSequence;
        private ImmutableList.Builder<MemoWrapper> memos = ImmutableList.builder();
        private ImmutableList.Builder<SignerWrapper> signers = ImmutableList.builder();
        @Nullable
        private UnsignedInteger sourceTag;
        @Nullable
        private PublicKey signingPublicKey;
        @Nullable
        private Signature transactionSignature;
        @Nullable
        private NetworkId networkId;
        @Nullable
        private UnsignedInteger ticketCount;
        @Nullable
        private TransactionFlags flags;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Transaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TicketCreate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<UnsignedInteger> sourceTagOptional;
            Optional<UnsignedInteger> lastLedgerSequenceOptional;
            Optional<NetworkId> networkIdOptional;
            Optional<Hash256> accountTransactionIdOptional;
            Optional<Signature> transactionSignatureOptional;
            Optional<UnsignedInteger> ticketSequenceOptional;
            Transaction instance;
            long bits = 0L;
            if (object instanceof Transaction) {
                instance = (Transaction)object;
                if ((bits & 1L) == 0L) {
                    ticketSequenceOptional = instance.ticketSequence();
                    if (ticketSequenceOptional.isPresent()) {
                        this.ticketSequence(ticketSequenceOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.sequence(instance.sequence());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllSigners(instance.signers());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    transactionSignatureOptional = instance.transactionSignature();
                    if (transactionSignatureOptional.isPresent()) {
                        this.transactionSignature(transactionSignatureOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 2L) == 0L) {
                    accountTransactionIdOptional = instance.accountTransactionId();
                    if (accountTransactionIdOptional.isPresent()) {
                        this.accountTransactionId(accountTransactionIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.addAllMemos(instance.memos());
                    bits |= 0x80L;
                }
                if ((bits & 4L) == 0L) {
                    this.fee(instance.fee());
                    bits |= 4L;
                }
                if ((bits & 0x100L) == 0L) {
                    networkIdOptional = instance.networkId();
                    if (networkIdOptional.isPresent()) {
                        this.networkId(networkIdOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 8L) == 0L) {
                    lastLedgerSequenceOptional = instance.lastLedgerSequence();
                    if (lastLedgerSequenceOptional.isPresent()) {
                        this.lastLedgerSequence(lastLedgerSequenceOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x200L) == 0L) {
                    sourceTagOptional = instance.sourceTag();
                    if (sourceTagOptional.isPresent()) {
                        this.sourceTag(sourceTagOptional);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.signingPublicKey(instance.signingPublicKey());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.account(instance.account());
                    bits |= 0x800L;
                }
            }
            if (object instanceof TicketCreate) {
                instance = (TicketCreate)object;
                if ((bits & 1L) == 0L) {
                    ticketSequenceOptional = instance.ticketSequence();
                    if (ticketSequenceOptional.isPresent()) {
                        this.ticketSequence(ticketSequenceOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    accountTransactionIdOptional = instance.accountTransactionId();
                    if (accountTransactionIdOptional.isPresent()) {
                        this.accountTransactionId(accountTransactionIdOptional);
                    }
                    bits |= 2L;
                }
                this.ticketCount(instance.ticketCount());
                if ((bits & 4L) == 0L) {
                    this.fee(instance.fee());
                    bits |= 4L;
                }
                this.flags(instance.flags());
                if ((bits & 8L) == 0L) {
                    lastLedgerSequenceOptional = instance.lastLedgerSequence();
                    if (lastLedgerSequenceOptional.isPresent()) {
                        this.lastLedgerSequence(lastLedgerSequenceOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.sequence(instance.sequence());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllSigners(instance.signers());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    transactionSignatureOptional = instance.transactionSignature();
                    if (transactionSignatureOptional.isPresent()) {
                        this.transactionSignature(transactionSignatureOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.addAllMemos(instance.memos());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    networkIdOptional = instance.networkId();
                    if (networkIdOptional.isPresent()) {
                        this.networkId(networkIdOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    sourceTagOptional = instance.sourceTag();
                    if (sourceTagOptional.isPresent()) {
                        this.sourceTag(sourceTagOptional);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.signingPublicKey(instance.signingPublicKey());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.account(instance.account());
                    bits |= 0x800L;
                }
            }
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Fee")
        @CanIgnoreReturnValue
        public final Builder fee(XrpCurrencyAmount fee) {
            this.fee = Objects.requireNonNull(fee, "fee");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Sequence")
        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ticketSequence(UnsignedInteger ticketSequence) {
            this.ticketSequence = Objects.requireNonNull(ticketSequence, "ticketSequence");
            return this;
        }

        @JsonProperty(value="TicketSequence")
        @CanIgnoreReturnValue
        public final Builder ticketSequence(Optional<? extends UnsignedInteger> ticketSequence) {
            this.ticketSequence = ticketSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Hash256 accountTransactionId) {
            this.accountTransactionId = Objects.requireNonNull(accountTransactionId, "accountTransactionId");
            return this;
        }

        @JsonProperty(value="AccountTxnID")
        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Optional<? extends Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastLedgerSequence(UnsignedInteger lastLedgerSequence) {
            this.lastLedgerSequence = Objects.requireNonNull(lastLedgerSequence, "lastLedgerSequence");
            return this;
        }

        @JsonProperty(value="LastLedgerSequence")
        @CanIgnoreReturnValue
        public final Builder lastLedgerSequence(Optional<? extends UnsignedInteger> lastLedgerSequence) {
            this.lastLedgerSequence = lastLedgerSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMemos(MemoWrapper element) {
            this.memos.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMemos(MemoWrapper ... elements) {
            this.memos.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Memos")
        @CanIgnoreReturnValue
        public final Builder memos(Iterable<? extends MemoWrapper> elements) {
            this.memos = ImmutableList.builder();
            return this.addAllMemos(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMemos(Iterable<? extends MemoWrapper> elements) {
            this.memos.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSigners(SignerWrapper element) {
            this.signers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSigners(SignerWrapper ... elements) {
            this.signers.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Signers")
        @CanIgnoreReturnValue
        public final Builder signers(Iterable<? extends SignerWrapper> elements) {
            this.signers = ImmutableList.builder();
            return this.addAllSigners(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSigners(Iterable<? extends SignerWrapper> elements) {
            this.signers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceTag(UnsignedInteger sourceTag) {
            this.sourceTag = Objects.requireNonNull(sourceTag, "sourceTag");
            return this;
        }

        @JsonProperty(value="SourceTag")
        @CanIgnoreReturnValue
        public final Builder sourceTag(Optional<? extends UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag.orElse(null);
            return this;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="SigningPubKey")
        @CanIgnoreReturnValue
        public final Builder signingPublicKey(PublicKey signingPublicKey) {
            this.signingPublicKey = Objects.requireNonNull(signingPublicKey, "signingPublicKey");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionSignature(Signature transactionSignature) {
            this.transactionSignature = Objects.requireNonNull(transactionSignature, "transactionSignature");
            return this;
        }

        @JsonProperty(value="TxnSignature")
        @CanIgnoreReturnValue
        public final Builder transactionSignature(Optional<? extends Signature> transactionSignature) {
            this.transactionSignature = transactionSignature.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder networkId(NetworkId networkId) {
            this.networkId = Objects.requireNonNull(networkId, "networkId");
            return this;
        }

        @JsonProperty(value="NetworkID")
        @CanIgnoreReturnValue
        public final Builder networkId(Optional<? extends NetworkId> networkId) {
            this.networkId = networkId.orElse(null);
            return this;
        }

        @JsonProperty(value="TicketCount")
        @CanIgnoreReturnValue
        public final Builder ticketCount(UnsignedInteger ticketCount) {
            this.ticketCount = Objects.requireNonNull(ticketCount, "ticketCount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(TransactionFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            return this;
        }

        public ImmutableTicketCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTicketCreate(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fee");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ticketCount");
            }
            return "Cannot build TicketCreate, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="TicketCreate", generator="Immutables")
    private final class InitShim {
        private byte sequenceBuildStage = 0;
        private UnsignedInteger sequence;
        private byte signingPublicKeyBuildStage = 0;
        private PublicKey signingPublicKey;
        private byte flagsBuildStage = 0;
        private TransactionFlags flags;

        private InitShim() {
        }

        UnsignedInteger sequence() {
            if (this.sequenceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sequenceBuildStage == 0) {
                this.sequenceBuildStage = (byte)-1;
                this.sequence = Objects.requireNonNull(ImmutableTicketCreate.this.sequenceInitialize(), "sequence");
                this.sequenceBuildStage = 1;
            }
            return this.sequence;
        }

        void sequence(UnsignedInteger sequence) {
            this.sequence = sequence;
            this.sequenceBuildStage = 1;
        }

        PublicKey signingPublicKey() {
            if (this.signingPublicKeyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.signingPublicKeyBuildStage == 0) {
                this.signingPublicKeyBuildStage = (byte)-1;
                this.signingPublicKey = Objects.requireNonNull(ImmutableTicketCreate.this.signingPublicKeyInitialize(), "signingPublicKey");
                this.signingPublicKeyBuildStage = 1;
            }
            return this.signingPublicKey;
        }

        void signingPublicKey(PublicKey signingPublicKey) {
            this.signingPublicKey = signingPublicKey;
            this.signingPublicKeyBuildStage = 1;
        }

        TransactionFlags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutableTicketCreate.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(TransactionFlags flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sequenceBuildStage == -1) {
                attributes.add("sequence");
            }
            if (this.signingPublicKeyBuildStage == -1) {
                attributes.add("signingPublicKey");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build TicketCreate, attribute initializers form cycle " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TicketCreate", generator="Immutables")
    static final class Json
    implements TicketCreate {
        @Nullable
        Address account;
        @Nullable
        XrpCurrencyAmount fee;
        @Nullable
        UnsignedInteger sequence;
        @Nullable
        Optional<UnsignedInteger> ticketSequence = Optional.empty();
        @Nullable
        Optional<Hash256> accountTransactionId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> lastLedgerSequence = Optional.empty();
        @Nullable
        List<MemoWrapper> memos = ImmutableList.of();
        @Nullable
        List<SignerWrapper> signers = ImmutableList.of();
        @Nullable
        Optional<UnsignedInteger> sourceTag = Optional.empty();
        @Nullable
        PublicKey signingPublicKey;
        @Nullable
        Optional<Signature> transactionSignature = Optional.empty();
        @Nullable
        Optional<NetworkId> networkId = Optional.empty();
        @Nullable
        UnsignedInteger ticketCount;
        @Nullable
        TransactionFlags flags;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="Fee")
        public void setFee(XrpCurrencyAmount fee) {
            this.fee = fee;
        }

        @JsonProperty(value="Sequence")
        public void setSequence(UnsignedInteger sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="TicketSequence")
        public void setTicketSequence(Optional<UnsignedInteger> ticketSequence) {
            this.ticketSequence = ticketSequence;
        }

        @JsonProperty(value="AccountTxnID")
        public void setAccountTransactionId(Optional<Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId;
        }

        @JsonProperty(value="LastLedgerSequence")
        public void setLastLedgerSequence(Optional<UnsignedInteger> lastLedgerSequence) {
            this.lastLedgerSequence = lastLedgerSequence;
        }

        @JsonProperty(value="Memos")
        public void setMemos(List<MemoWrapper> memos) {
            this.memos = memos;
        }

        @JsonProperty(value="Signers")
        public void setSigners(List<SignerWrapper> signers) {
            this.signers = signers;
        }

        @JsonProperty(value="SourceTag")
        public void setSourceTag(Optional<UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="SigningPubKey")
        public void setSigningPublicKey(PublicKey signingPublicKey) {
            this.signingPublicKey = signingPublicKey;
        }

        @JsonProperty(value="TxnSignature")
        public void setTransactionSignature(Optional<Signature> transactionSignature) {
            this.transactionSignature = transactionSignature;
        }

        @JsonProperty(value="NetworkID")
        public void setNetworkId(Optional<NetworkId> networkId) {
            this.networkId = networkId;
        }

        @JsonProperty(value="TicketCount")
        public void setTicketCount(UnsignedInteger ticketCount) {
            this.ticketCount = ticketCount;
        }

        @JsonProperty(value="Flags")
        public void setFlags(TransactionFlags flags) {
            this.flags = flags;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount fee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> ticketSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> accountTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> lastLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MemoWrapper> memos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SignerWrapper> signers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sourceTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PublicKey signingPublicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Signature> transactionSignature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NetworkId> networkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger ticketCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TransactionFlags flags() {
            throw new UnsupportedOperationException();
        }
    }
}

