/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.PathStep;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PathStep", generator="Immutables")
@Immutable
public final class ImmutablePathStep
implements PathStep {
    @Nullable
    private final Address account;
    @Nullable
    private final String currency;
    @Nullable
    private final Address issuer;

    private ImmutablePathStep(@Nullable Address account, @Nullable String currency, @Nullable Address issuer) {
        this.account = account;
        this.currency = currency;
        this.issuer = issuer;
    }

    @Override
    @JsonProperty(value="account")
    public Optional<Address> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="currency")
    public Optional<String> currency() {
        return Optional.ofNullable(this.currency);
    }

    @Override
    @JsonProperty(value="issuer")
    public Optional<Address> issuer() {
        return Optional.ofNullable(this.issuer);
    }

    public final ImmutablePathStep withAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutablePathStep(newValue, this.currency, this.issuer);
    }

    public final ImmutablePathStep withAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutablePathStep(value, this.currency, this.issuer);
    }

    public final ImmutablePathStep withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (Objects.equals(this.currency, newValue)) {
            return this;
        }
        return new ImmutablePathStep(this.account, newValue, this.issuer);
    }

    public final ImmutablePathStep withCurrency(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.currency, value)) {
            return this;
        }
        return new ImmutablePathStep(this.account, value, this.issuer);
    }

    public final ImmutablePathStep withIssuer(Address value) {
        Address newValue = Objects.requireNonNull(value, "issuer");
        if (this.issuer == newValue) {
            return this;
        }
        return new ImmutablePathStep(this.account, this.currency, newValue);
    }

    public final ImmutablePathStep withIssuer(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.issuer == value) {
            return this;
        }
        return new ImmutablePathStep(this.account, this.currency, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePathStep && this.equalTo(0, (ImmutablePathStep)another);
    }

    private boolean equalTo(int synthetic, ImmutablePathStep another) {
        return Objects.equals(this.account, another.account) && Objects.equals(this.currency, another.currency) && Objects.equals(this.issuer, another.issuer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.currency);
        h += (h << 5) + Objects.hashCode(this.issuer);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PathStep").omitNullValues().add("account", (Object)this.account).add("currency", (Object)this.currency).add("issuer", (Object)this.issuer).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePathStep fromJson(Json json) {
        Builder builder = ImmutablePathStep.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.currency != null) {
            builder.currency(json.currency);
        }
        if (json.issuer != null) {
            builder.issuer(json.issuer);
        }
        return builder.build();
    }

    public static ImmutablePathStep copyOf(PathStep instance) {
        if (instance instanceof ImmutablePathStep) {
            return (ImmutablePathStep)instance;
        }
        return ImmutablePathStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PathStep", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address account;
        @Nullable
        private String currency;
        @Nullable
        private Address issuer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PathStep instance) {
            Optional<Address> issuerOptional;
            Optional<String> currencyOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> accountOptional = instance.account();
            if (accountOptional.isPresent()) {
                this.account(accountOptional);
            }
            if ((currencyOptional = instance.currency()).isPresent()) {
                this.currency(currencyOptional);
            }
            if ((issuerOptional = instance.issuer()).isPresent()) {
                this.issuer(issuerOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends Address> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            return this;
        }

        @JsonProperty(value="currency")
        @CanIgnoreReturnValue
        public final Builder currency(Optional<String> currency) {
            this.currency = currency.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuer(Address issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            return this;
        }

        @JsonProperty(value="issuer")
        @CanIgnoreReturnValue
        public final Builder issuer(Optional<? extends Address> issuer) {
            this.issuer = issuer.orElse(null);
            return this;
        }

        public ImmutablePathStep build() {
            return new ImmutablePathStep(this.account, this.currency, this.issuer);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PathStep", generator="Immutables")
    static final class Json
    implements PathStep {
        @Nullable
        Optional<Address> account = Optional.empty();
        @Nullable
        Optional<String> currency = Optional.empty();
        @Nullable
        Optional<Address> issuer = Optional.empty();

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Optional<Address> account) {
            this.account = account;
        }

        @JsonProperty(value="currency")
        public void setCurrency(Optional<String> currency) {
            this.currency = currency;
        }

        @JsonProperty(value="issuer")
        public void setIssuer(Optional<Address> issuer) {
            this.issuer = issuer;
        }

        @Override
        public Optional<Address> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> currency() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> issuer() {
            throw new UnsupportedOperationException();
        }
    }
}

