/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.crypto.signing.Signature;
import org.xrpl.xrpl4j.model.flags.AccountSetTransactionFlags;
import org.xrpl.xrpl4j.model.transactions.AccountSet;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.MemoWrapper;
import org.xrpl.xrpl4j.model.transactions.NetworkId;
import org.xrpl.xrpl4j.model.transactions.SignerWrapper;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountSet", generator="Immutables")
@Immutable
public final class ImmutableAccountSet
implements AccountSet {
    private final Address account;
    private final XrpCurrencyAmount fee;
    private final UnsignedInteger sequence;
    @Nullable
    private final UnsignedInteger ticketSequence;
    @Nullable
    private final Hash256 accountTransactionId;
    @Nullable
    private final UnsignedInteger lastLedgerSequence;
    private final ImmutableList<MemoWrapper> memos;
    private final ImmutableList<SignerWrapper> signers;
    @Nullable
    private final UnsignedInteger sourceTag;
    private final PublicKey signingPublicKey;
    @Nullable
    private final Signature transactionSignature;
    @Nullable
    private final NetworkId networkId;
    private final AccountSetTransactionFlags flags;
    @Nullable
    private final AccountSet.AccountSetFlag clearFlag;
    @Nullable
    private final UnsignedInteger clearFlagRawValue;
    @Nullable
    private final AccountSet.AccountSetFlag setFlag;
    @Nullable
    private final UnsignedInteger setFlagRawValue;
    @Nullable
    private final String domain;
    @Nullable
    private final String emailHash;
    @Nullable
    private final String messageKey;
    @Nullable
    private final UnsignedInteger transferRate;
    @Nullable
    private final UnsignedInteger tickSize;
    @Nullable
    private final Address mintAccount;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAccountSet(Builder builder) {
        this.account = builder.account;
        this.fee = builder.fee;
        this.ticketSequence = builder.ticketSequence;
        this.accountTransactionId = builder.accountTransactionId;
        this.lastLedgerSequence = builder.lastLedgerSequence;
        this.memos = builder.memos.build();
        this.signers = builder.signers.build();
        this.sourceTag = builder.sourceTag;
        this.transactionSignature = builder.transactionSignature;
        this.networkId = builder.networkId;
        this.clearFlag = builder.clearFlag;
        this.clearFlagRawValue = builder.clearFlagRawValue;
        this.setFlag = builder.setFlag;
        this.setFlagRawValue = builder.setFlagRawValue;
        this.domain = builder.domain;
        this.emailHash = builder.emailHash;
        this.messageKey = builder.messageKey;
        this.transferRate = builder.transferRate;
        this.tickSize = builder.tickSize;
        this.mintAccount = builder.mintAccount;
        if (builder.sequence != null) {
            this.initShim.sequence(builder.sequence);
        }
        if (builder.signingPublicKey != null) {
            this.initShim.signingPublicKey(builder.signingPublicKey);
        }
        if (builder.flags != null) {
            this.initShim.flags(builder.flags);
        }
        this.sequence = this.initShim.sequence();
        this.signingPublicKey = this.initShim.signingPublicKey();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableAccountSet(Address account, XrpCurrencyAmount fee, UnsignedInteger sequence, @Nullable UnsignedInteger ticketSequence, @Nullable Hash256 accountTransactionId, @Nullable UnsignedInteger lastLedgerSequence, ImmutableList<MemoWrapper> memos, ImmutableList<SignerWrapper> signers, @Nullable UnsignedInteger sourceTag, PublicKey signingPublicKey, @Nullable Signature transactionSignature, @Nullable NetworkId networkId, AccountSetTransactionFlags flags, @Nullable AccountSet.AccountSetFlag clearFlag, @Nullable UnsignedInteger clearFlagRawValue, @Nullable AccountSet.AccountSetFlag setFlag, @Nullable UnsignedInteger setFlagRawValue, @Nullable String domain, @Nullable String emailHash, @Nullable String messageKey, @Nullable UnsignedInteger transferRate, @Nullable UnsignedInteger tickSize, @Nullable Address mintAccount) {
        this.account = account;
        this.fee = fee;
        this.sequence = sequence;
        this.ticketSequence = ticketSequence;
        this.accountTransactionId = accountTransactionId;
        this.lastLedgerSequence = lastLedgerSequence;
        this.memos = memos;
        this.signers = signers;
        this.sourceTag = sourceTag;
        this.signingPublicKey = signingPublicKey;
        this.transactionSignature = transactionSignature;
        this.networkId = networkId;
        this.flags = flags;
        this.clearFlag = clearFlag;
        this.clearFlagRawValue = clearFlagRawValue;
        this.setFlag = setFlag;
        this.setFlagRawValue = setFlagRawValue;
        this.domain = domain;
        this.emailHash = emailHash;
        this.messageKey = messageKey;
        this.transferRate = transferRate;
        this.tickSize = tickSize;
        this.mintAccount = mintAccount;
        this.initShim = null;
    }

    private UnsignedInteger sequenceInitialize() {
        return AccountSet.super.sequence();
    }

    private PublicKey signingPublicKeyInitialize() {
        return AccountSet.super.signingPublicKey();
    }

    private AccountSetTransactionFlags flagsInitialize() {
        return AccountSet.super.flags();
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="Fee")
    public XrpCurrencyAmount fee() {
        return this.fee;
    }

    @Override
    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sequence() : this.sequence;
    }

    @Override
    @JsonProperty(value="TicketSequence")
    public Optional<UnsignedInteger> ticketSequence() {
        return Optional.ofNullable(this.ticketSequence);
    }

    @Override
    @JsonProperty(value="AccountTxnID")
    public Optional<Hash256> accountTransactionId() {
        return Optional.ofNullable(this.accountTransactionId);
    }

    @Override
    @JsonProperty(value="LastLedgerSequence")
    public Optional<UnsignedInteger> lastLedgerSequence() {
        return Optional.ofNullable(this.lastLedgerSequence);
    }

    @JsonProperty(value="Memos")
    public ImmutableList<MemoWrapper> memos() {
        return this.memos;
    }

    @JsonProperty(value="Signers")
    public ImmutableList<SignerWrapper> signers() {
        return this.signers;
    }

    @Override
    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag() {
        return Optional.ofNullable(this.sourceTag);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="SigningPubKey")
    public PublicKey signingPublicKey() {
        InitShim shim = this.initShim;
        return shim != null ? shim.signingPublicKey() : this.signingPublicKey;
    }

    @Override
    @JsonProperty(value="TxnSignature")
    public Optional<Signature> transactionSignature() {
        return Optional.ofNullable(this.transactionSignature);
    }

    @Override
    @JsonProperty(value="NetworkID")
    public Optional<NetworkId> networkId() {
        return Optional.ofNullable(this.networkId);
    }

    @Override
    @JsonProperty(value="Flags")
    public AccountSetTransactionFlags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @JsonProperty(value="clearFlag")
    @JsonIgnore
    public Optional<AccountSet.AccountSetFlag> clearFlag() {
        return Optional.ofNullable(this.clearFlag);
    }

    @Override
    @JsonProperty(value="ClearFlag")
    public Optional<UnsignedInteger> clearFlagRawValue() {
        return Optional.ofNullable(this.clearFlagRawValue);
    }

    @Override
    @JsonProperty(value="setFlag")
    @JsonIgnore
    public Optional<AccountSet.AccountSetFlag> setFlag() {
        return Optional.ofNullable(this.setFlag);
    }

    @Override
    @JsonProperty(value="SetFlag")
    public Optional<UnsignedInteger> setFlagRawValue() {
        return Optional.ofNullable(this.setFlagRawValue);
    }

    @Override
    @JsonProperty(value="Domain")
    public Optional<String> domain() {
        return Optional.ofNullable(this.domain);
    }

    @Override
    @JsonProperty(value="EmailHash")
    public Optional<String> emailHash() {
        return Optional.ofNullable(this.emailHash);
    }

    @Override
    @JsonProperty(value="MessageKey")
    public Optional<String> messageKey() {
        return Optional.ofNullable(this.messageKey);
    }

    @Override
    @JsonProperty(value="TransferRate")
    public Optional<UnsignedInteger> transferRate() {
        return Optional.ofNullable(this.transferRate);
    }

    @Override
    @JsonProperty(value="TickSize")
    public Optional<UnsignedInteger> tickSize() {
        return Optional.ofNullable(this.tickSize);
    }

    @Override
    @JsonProperty(value="NFTokenMinter")
    public Optional<Address> mintAccount() {
        return Optional.ofNullable(this.mintAccount);
    }

    public final ImmutableAccountSet withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return ImmutableAccountSet.validate(new ImmutableAccountSet(newValue, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withFee(XrpCurrencyAmount value) {
        if (this.fee == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "fee");
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, newValue, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (this.sequence.equals((Object)newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, newValue, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withTicketSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "ticketSequence");
        if (Objects.equals(this.ticketSequence, newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, newValue, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withTicketSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.ticketSequence, value)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, value, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withAccountTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "accountTransactionId");
        if (this.accountTransactionId == newValue) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, newValue, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withAccountTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.accountTransactionId == value) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, value, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withLastLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "lastLedgerSequence");
        if (Objects.equals(this.lastLedgerSequence, newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, newValue, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withLastLedgerSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.lastLedgerSequence, value)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, value, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withMemos(MemoWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, (ImmutableList<MemoWrapper>)newValue, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withMemos(Iterable<? extends MemoWrapper> elements) {
        if (this.memos == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, (ImmutableList<MemoWrapper>)newValue, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withSigners(SignerWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, (ImmutableList<SignerWrapper>)newValue, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withSigners(Iterable<? extends SignerWrapper> elements) {
        if (this.signers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, (ImmutableList<SignerWrapper>)newValue, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withSourceTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sourceTag");
        if (Objects.equals(this.sourceTag, newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, newValue, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withSourceTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sourceTag, value)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, value, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withSigningPublicKey(PublicKey value) {
        if (this.signingPublicKey == value) {
            return this;
        }
        PublicKey newValue = Objects.requireNonNull(value, "signingPublicKey");
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, newValue, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withTransactionSignature(Signature value) {
        Signature newValue = Objects.requireNonNull(value, "transactionSignature");
        if (this.transactionSignature == newValue) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, newValue, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withTransactionSignature(Optional<? extends Signature> optional) {
        Signature value = optional.orElse(null);
        if (this.transactionSignature == value) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, value, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withNetworkId(NetworkId value) {
        NetworkId newValue = Objects.requireNonNull(value, "networkId");
        if (this.networkId == newValue) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, newValue, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withNetworkId(Optional<? extends NetworkId> optional) {
        NetworkId value = optional.orElse(null);
        if (this.networkId == value) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, value, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withFlags(AccountSetTransactionFlags value) {
        if (this.flags == value) {
            return this;
        }
        AccountSetTransactionFlags newValue = Objects.requireNonNull(value, "flags");
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, newValue, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withClearFlag(AccountSet.AccountSetFlag value) {
        AccountSet.AccountSetFlag newValue = Objects.requireNonNull(value, "clearFlag");
        if (this.clearFlag == newValue) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, newValue, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withClearFlag(Optional<? extends AccountSet.AccountSetFlag> optional) {
        AccountSet.AccountSetFlag value = optional.orElse(null);
        if (this.clearFlag == value) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, value, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withClearFlagRawValue(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "clearFlagRawValue");
        if (Objects.equals(this.clearFlagRawValue, newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, newValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withClearFlagRawValue(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.clearFlagRawValue, value)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, value, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withSetFlag(AccountSet.AccountSetFlag value) {
        AccountSet.AccountSetFlag newValue = Objects.requireNonNull(value, "setFlag");
        if (this.setFlag == newValue) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, newValue, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withSetFlag(Optional<? extends AccountSet.AccountSetFlag> optional) {
        AccountSet.AccountSetFlag value = optional.orElse(null);
        if (this.setFlag == value) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, value, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withSetFlagRawValue(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "setFlagRawValue");
        if (Objects.equals(this.setFlagRawValue, newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, newValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withSetFlagRawValue(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.setFlagRawValue, value)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, value, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withDomain(String value) {
        String newValue = Objects.requireNonNull(value, "domain");
        if (Objects.equals(this.domain, newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, newValue, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withDomain(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.domain, value)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, value, this.emailHash, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withEmailHash(String value) {
        String newValue = Objects.requireNonNull(value, "emailHash");
        if (Objects.equals(this.emailHash, newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, newValue, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withEmailHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.emailHash, value)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, value, this.messageKey, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withMessageKey(String value) {
        String newValue = Objects.requireNonNull(value, "messageKey");
        if (Objects.equals(this.messageKey, newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, newValue, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withMessageKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.messageKey, value)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, value, this.transferRate, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withTransferRate(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "transferRate");
        if (Objects.equals(this.transferRate, newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, newValue, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withTransferRate(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.transferRate, value)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, value, this.tickSize, this.mintAccount));
    }

    public final ImmutableAccountSet withTickSize(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "tickSize");
        if (Objects.equals(this.tickSize, newValue)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, newValue, this.mintAccount));
    }

    public final ImmutableAccountSet withTickSize(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.tickSize, value)) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, value, this.mintAccount));
    }

    public final ImmutableAccountSet withMintAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "mintAccount");
        if (this.mintAccount == newValue) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, newValue));
    }

    public final ImmutableAccountSet withMintAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.mintAccount == value) {
            return this;
        }
        return ImmutableAccountSet.validate(new ImmutableAccountSet(this.account, this.fee, this.sequence, this.ticketSequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.networkId, this.flags, this.clearFlag, this.clearFlagRawValue, this.setFlag, this.setFlagRawValue, this.domain, this.emailHash, this.messageKey, this.transferRate, this.tickSize, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountSet && this.equalTo(0, (ImmutableAccountSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccountSet another) {
        return this.account.equals(another.account) && this.fee.equals(another.fee) && this.sequence.equals((Object)another.sequence) && Objects.equals(this.ticketSequence, another.ticketSequence) && Objects.equals(this.accountTransactionId, another.accountTransactionId) && Objects.equals(this.lastLedgerSequence, another.lastLedgerSequence) && this.memos.equals(another.memos) && this.signers.equals(another.signers) && Objects.equals(this.sourceTag, another.sourceTag) && this.signingPublicKey.equals(another.signingPublicKey) && Objects.equals(this.transactionSignature, another.transactionSignature) && Objects.equals(this.networkId, another.networkId) && this.flags.equals(another.flags) && Objects.equals((Object)this.clearFlag, (Object)another.clearFlag) && Objects.equals(this.clearFlagRawValue, another.clearFlagRawValue) && Objects.equals((Object)this.setFlag, (Object)another.setFlag) && Objects.equals(this.setFlagRawValue, another.setFlagRawValue) && Objects.equals(this.domain, another.domain) && Objects.equals(this.emailHash, another.emailHash) && Objects.equals(this.messageKey, another.messageKey) && Objects.equals(this.transferRate, another.transferRate) && Objects.equals(this.tickSize, another.tickSize) && Objects.equals(this.mintAccount, another.mintAccount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.fee.hashCode();
        h += (h << 5) + this.sequence.hashCode();
        h += (h << 5) + Objects.hashCode(this.ticketSequence);
        h += (h << 5) + Objects.hashCode(this.accountTransactionId);
        h += (h << 5) + Objects.hashCode(this.lastLedgerSequence);
        h += (h << 5) + this.memos.hashCode();
        h += (h << 5) + this.signers.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceTag);
        h += (h << 5) + this.signingPublicKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.transactionSignature);
        h += (h << 5) + Objects.hashCode(this.networkId);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.clearFlag);
        h += (h << 5) + Objects.hashCode(this.clearFlagRawValue);
        h += (h << 5) + Objects.hashCode((Object)this.setFlag);
        h += (h << 5) + Objects.hashCode(this.setFlagRawValue);
        h += (h << 5) + Objects.hashCode(this.domain);
        h += (h << 5) + Objects.hashCode(this.emailHash);
        h += (h << 5) + Objects.hashCode(this.messageKey);
        h += (h << 5) + Objects.hashCode(this.transferRate);
        h += (h << 5) + Objects.hashCode(this.tickSize);
        h += (h << 5) + Objects.hashCode(this.mintAccount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountSet").omitNullValues().add("account", (Object)this.account).add("fee", (Object)this.fee).add("sequence", (Object)this.sequence).add("ticketSequence", (Object)this.ticketSequence).add("accountTransactionId", (Object)this.accountTransactionId).add("lastLedgerSequence", (Object)this.lastLedgerSequence).add("memos", this.memos).add("signers", this.signers).add("sourceTag", (Object)this.sourceTag).add("signingPublicKey", (Object)this.signingPublicKey).add("transactionSignature", (Object)this.transactionSignature).add("networkId", (Object)this.networkId).add("flags", (Object)this.flags).add("clearFlag", (Object)this.clearFlag).add("clearFlagRawValue", (Object)this.clearFlagRawValue).add("setFlag", (Object)this.setFlag).add("setFlagRawValue", (Object)this.setFlagRawValue).add("domain", (Object)this.domain).add("emailHash", (Object)this.emailHash).add("messageKey", (Object)this.messageKey).add("transferRate", (Object)this.transferRate).add("tickSize", (Object)this.tickSize).add("mintAccount", (Object)this.mintAccount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountSet fromJson(Json json) {
        Builder builder = ImmutableAccountSet.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.fee != null) {
            builder.fee(json.fee);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.ticketSequence != null) {
            builder.ticketSequence(json.ticketSequence);
        }
        if (json.accountTransactionId != null) {
            builder.accountTransactionId(json.accountTransactionId);
        }
        if (json.lastLedgerSequence != null) {
            builder.lastLedgerSequence(json.lastLedgerSequence);
        }
        if (json.memos != null) {
            builder.addAllMemos(json.memos);
        }
        if (json.signers != null) {
            builder.addAllSigners(json.signers);
        }
        if (json.sourceTag != null) {
            builder.sourceTag(json.sourceTag);
        }
        if (json.signingPublicKey != null) {
            builder.signingPublicKey(json.signingPublicKey);
        }
        if (json.transactionSignature != null) {
            builder.transactionSignature(json.transactionSignature);
        }
        if (json.networkId != null) {
            builder.networkId(json.networkId);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.clearFlag != null) {
            builder.clearFlag(json.clearFlag);
        }
        if (json.clearFlagRawValue != null) {
            builder.clearFlagRawValue(json.clearFlagRawValue);
        }
        if (json.setFlag != null) {
            builder.setFlag(json.setFlag);
        }
        if (json.setFlagRawValue != null) {
            builder.setFlagRawValue(json.setFlagRawValue);
        }
        if (json.domain != null) {
            builder.domain(json.domain);
        }
        if (json.emailHash != null) {
            builder.emailHash(json.emailHash);
        }
        if (json.messageKey != null) {
            builder.messageKey(json.messageKey);
        }
        if (json.transferRate != null) {
            builder.transferRate(json.transferRate);
        }
        if (json.tickSize != null) {
            builder.tickSize(json.tickSize);
        }
        if (json.mintAccount != null) {
            builder.mintAccount(json.mintAccount);
        }
        return builder.build();
    }

    private static ImmutableAccountSet validate(ImmutableAccountSet instance) {
        instance.checkTickSize();
        instance.checkTransferRate();
        instance.checkEmailHashLength();
        instance = (ImmutableAccountSet)instance.normalizeSetFlag();
        instance = (ImmutableAccountSet)instance.normalizeClearFlag();
        return instance;
    }

    public static ImmutableAccountSet copyOf(AccountSet instance) {
        if (instance instanceof ImmutableAccountSet) {
            return (ImmutableAccountSet)instance;
        }
        return ImmutableAccountSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountSet", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_FEE = 2L;
        private long initBits = 3L;
        @Nullable
        private Address account;
        @Nullable
        private XrpCurrencyAmount fee;
        @Nullable
        private UnsignedInteger sequence;
        @Nullable
        private UnsignedInteger ticketSequence;
        @Nullable
        private Hash256 accountTransactionId;
        @Nullable
        private UnsignedInteger lastLedgerSequence;
        private ImmutableList.Builder<MemoWrapper> memos = ImmutableList.builder();
        private ImmutableList.Builder<SignerWrapper> signers = ImmutableList.builder();
        @Nullable
        private UnsignedInteger sourceTag;
        @Nullable
        private PublicKey signingPublicKey;
        @Nullable
        private Signature transactionSignature;
        @Nullable
        private NetworkId networkId;
        @Nullable
        private AccountSetTransactionFlags flags;
        @Nullable
        private AccountSet.AccountSetFlag clearFlag;
        @Nullable
        private UnsignedInteger clearFlagRawValue;
        @Nullable
        private AccountSet.AccountSetFlag setFlag;
        @Nullable
        private UnsignedInteger setFlagRawValue;
        @Nullable
        private String domain;
        @Nullable
        private String emailHash;
        @Nullable
        private String messageKey;
        @Nullable
        private UnsignedInteger transferRate;
        @Nullable
        private UnsignedInteger tickSize;
        @Nullable
        private Address mintAccount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Transaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<UnsignedInteger> ticketSequenceOptional;
            Transaction instance;
            long bits = 0L;
            if (object instanceof Transaction) {
                instance = (Transaction)object;
                if ((bits & 1L) == 0L) {
                    ticketSequenceOptional = instance.ticketSequence();
                    if (ticketSequenceOptional.isPresent()) {
                        this.ticketSequence(ticketSequenceOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.sequence(instance.sequence());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllSigners(instance.signers());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    Optional<Signature> transactionSignatureOptional = instance.transactionSignature();
                    if (transactionSignatureOptional.isPresent()) {
                        this.transactionSignature(transactionSignatureOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<Hash256> accountTransactionIdOptional = instance.accountTransactionId();
                    if (accountTransactionIdOptional.isPresent()) {
                        this.accountTransactionId(accountTransactionIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.addAllMemos(instance.memos());
                    bits |= 0x80L;
                }
                if ((bits & 4L) == 0L) {
                    this.fee(instance.fee());
                    bits |= 4L;
                }
                if ((bits & 0x100L) == 0L) {
                    Optional<NetworkId> networkIdOptional = instance.networkId();
                    if (networkIdOptional.isPresent()) {
                        this.networkId(networkIdOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 8L) == 0L) {
                    Optional<UnsignedInteger> lastLedgerSequenceOptional = instance.lastLedgerSequence();
                    if (lastLedgerSequenceOptional.isPresent()) {
                        this.lastLedgerSequence(lastLedgerSequenceOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x200L) == 0L) {
                    Optional<UnsignedInteger> sourceTagOptional = instance.sourceTag();
                    if (sourceTagOptional.isPresent()) {
                        this.sourceTag(sourceTagOptional);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.signingPublicKey(instance.signingPublicKey());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.account(instance.account());
                    bits |= 0x800L;
                }
            }
            if (object instanceof AccountSet) {
                Optional<String> emailHashOptional;
                Optional<String> domainOptional;
                Optional<Address> mintAccountOptional;
                Optional<UnsignedInteger> transferRateOptional;
                Optional<UnsignedInteger> tickSizeOptional;
                Optional<UnsignedInteger> clearFlagRawValueOptional;
                Optional<UnsignedInteger> setFlagRawValueOptional;
                Optional<AccountSet.AccountSetFlag> setFlagOptional;
                Optional<String> messageKeyOptional;
                Optional<AccountSet.AccountSetFlag> clearFlagOptional;
                instance = (AccountSet)object;
                if ((bits & 1L) == 0L) {
                    ticketSequenceOptional = instance.ticketSequence();
                    if (ticketSequenceOptional.isPresent()) {
                        this.ticketSequence(ticketSequenceOptional);
                    }
                    bits |= 1L;
                }
                if ((clearFlagOptional = instance.clearFlag()).isPresent()) {
                    this.clearFlag(clearFlagOptional);
                }
                if ((messageKeyOptional = instance.messageKey()).isPresent()) {
                    this.messageKey(messageKeyOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<Hash256> accountTransactionIdOptional = instance.accountTransactionId();
                    if (accountTransactionIdOptional.isPresent()) {
                        this.accountTransactionId(accountTransactionIdOptional);
                    }
                    bits |= 2L;
                }
                if ((setFlagOptional = instance.setFlag()).isPresent()) {
                    this.setFlag(setFlagOptional);
                }
                if ((setFlagRawValueOptional = instance.setFlagRawValue()).isPresent()) {
                    this.setFlagRawValue(setFlagRawValueOptional);
                }
                if ((bits & 4L) == 0L) {
                    this.fee(instance.fee());
                    bits |= 4L;
                }
                this.flags(instance.flags());
                if ((bits & 8L) == 0L) {
                    Optional<UnsignedInteger> lastLedgerSequenceOptional = instance.lastLedgerSequence();
                    if (lastLedgerSequenceOptional.isPresent()) {
                        this.lastLedgerSequence(lastLedgerSequenceOptional);
                    }
                    bits |= 8L;
                }
                if ((clearFlagRawValueOptional = instance.clearFlagRawValue()).isPresent()) {
                    this.clearFlagRawValue(clearFlagRawValueOptional);
                }
                if ((tickSizeOptional = instance.tickSize()).isPresent()) {
                    this.tickSize(tickSizeOptional);
                }
                if ((transferRateOptional = instance.transferRate()).isPresent()) {
                    this.transferRate(transferRateOptional);
                }
                if ((mintAccountOptional = instance.mintAccount()).isPresent()) {
                    this.mintAccount(mintAccountOptional);
                }
                if ((bits & 0x10L) == 0L) {
                    this.sequence(instance.sequence());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllSigners(instance.signers());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    Optional<Signature> transactionSignatureOptional = instance.transactionSignature();
                    if (transactionSignatureOptional.isPresent()) {
                        this.transactionSignature(transactionSignatureOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.addAllMemos(instance.memos());
                    bits |= 0x80L;
                }
                if ((domainOptional = instance.domain()).isPresent()) {
                    this.domain(domainOptional);
                }
                if ((emailHashOptional = instance.emailHash()).isPresent()) {
                    this.emailHash(emailHashOptional);
                }
                if ((bits & 0x100L) == 0L) {
                    Optional<NetworkId> networkIdOptional = instance.networkId();
                    if (networkIdOptional.isPresent()) {
                        this.networkId(networkIdOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    Optional<UnsignedInteger> sourceTagOptional = instance.sourceTag();
                    if (sourceTagOptional.isPresent()) {
                        this.sourceTag(sourceTagOptional);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.signingPublicKey(instance.signingPublicKey());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.account(instance.account());
                    bits |= 0x800L;
                }
            }
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Fee")
        @CanIgnoreReturnValue
        public final Builder fee(XrpCurrencyAmount fee) {
            this.fee = Objects.requireNonNull(fee, "fee");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Sequence")
        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ticketSequence(UnsignedInteger ticketSequence) {
            this.ticketSequence = Objects.requireNonNull(ticketSequence, "ticketSequence");
            return this;
        }

        @JsonProperty(value="TicketSequence")
        @CanIgnoreReturnValue
        public final Builder ticketSequence(Optional<? extends UnsignedInteger> ticketSequence) {
            this.ticketSequence = ticketSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Hash256 accountTransactionId) {
            this.accountTransactionId = Objects.requireNonNull(accountTransactionId, "accountTransactionId");
            return this;
        }

        @JsonProperty(value="AccountTxnID")
        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Optional<? extends Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastLedgerSequence(UnsignedInteger lastLedgerSequence) {
            this.lastLedgerSequence = Objects.requireNonNull(lastLedgerSequence, "lastLedgerSequence");
            return this;
        }

        @JsonProperty(value="LastLedgerSequence")
        @CanIgnoreReturnValue
        public final Builder lastLedgerSequence(Optional<? extends UnsignedInteger> lastLedgerSequence) {
            this.lastLedgerSequence = lastLedgerSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMemos(MemoWrapper element) {
            this.memos.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMemos(MemoWrapper ... elements) {
            this.memos.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Memos")
        @CanIgnoreReturnValue
        public final Builder memos(Iterable<? extends MemoWrapper> elements) {
            this.memos = ImmutableList.builder();
            return this.addAllMemos(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMemos(Iterable<? extends MemoWrapper> elements) {
            this.memos.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSigners(SignerWrapper element) {
            this.signers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSigners(SignerWrapper ... elements) {
            this.signers.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Signers")
        @CanIgnoreReturnValue
        public final Builder signers(Iterable<? extends SignerWrapper> elements) {
            this.signers = ImmutableList.builder();
            return this.addAllSigners(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSigners(Iterable<? extends SignerWrapper> elements) {
            this.signers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceTag(UnsignedInteger sourceTag) {
            this.sourceTag = Objects.requireNonNull(sourceTag, "sourceTag");
            return this;
        }

        @JsonProperty(value="SourceTag")
        @CanIgnoreReturnValue
        public final Builder sourceTag(Optional<? extends UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag.orElse(null);
            return this;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="SigningPubKey")
        @CanIgnoreReturnValue
        public final Builder signingPublicKey(PublicKey signingPublicKey) {
            this.signingPublicKey = Objects.requireNonNull(signingPublicKey, "signingPublicKey");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionSignature(Signature transactionSignature) {
            this.transactionSignature = Objects.requireNonNull(transactionSignature, "transactionSignature");
            return this;
        }

        @JsonProperty(value="TxnSignature")
        @CanIgnoreReturnValue
        public final Builder transactionSignature(Optional<? extends Signature> transactionSignature) {
            this.transactionSignature = transactionSignature.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder networkId(NetworkId networkId) {
            this.networkId = Objects.requireNonNull(networkId, "networkId");
            return this;
        }

        @JsonProperty(value="NetworkID")
        @CanIgnoreReturnValue
        public final Builder networkId(Optional<? extends NetworkId> networkId) {
            this.networkId = networkId.orElse(null);
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(AccountSetTransactionFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clearFlag(AccountSet.AccountSetFlag clearFlag) {
            this.clearFlag = Objects.requireNonNull(clearFlag, "clearFlag");
            return this;
        }

        @JsonProperty(value="clearFlag")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder clearFlag(Optional<? extends AccountSet.AccountSetFlag> clearFlag) {
            this.clearFlag = clearFlag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clearFlagRawValue(UnsignedInteger clearFlagRawValue) {
            this.clearFlagRawValue = Objects.requireNonNull(clearFlagRawValue, "clearFlagRawValue");
            return this;
        }

        @JsonProperty(value="ClearFlag")
        @CanIgnoreReturnValue
        public final Builder clearFlagRawValue(Optional<? extends UnsignedInteger> clearFlagRawValue) {
            this.clearFlagRawValue = clearFlagRawValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setFlag(AccountSet.AccountSetFlag setFlag) {
            this.setFlag = Objects.requireNonNull(setFlag, "setFlag");
            return this;
        }

        @JsonProperty(value="setFlag")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder setFlag(Optional<? extends AccountSet.AccountSetFlag> setFlag) {
            this.setFlag = setFlag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setFlagRawValue(UnsignedInteger setFlagRawValue) {
            this.setFlagRawValue = Objects.requireNonNull(setFlagRawValue, "setFlagRawValue");
            return this;
        }

        @JsonProperty(value="SetFlag")
        @CanIgnoreReturnValue
        public final Builder setFlagRawValue(Optional<? extends UnsignedInteger> setFlagRawValue) {
            this.setFlagRawValue = setFlagRawValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            return this;
        }

        @JsonProperty(value="Domain")
        @CanIgnoreReturnValue
        public final Builder domain(Optional<String> domain) {
            this.domain = domain.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder emailHash(String emailHash) {
            this.emailHash = Objects.requireNonNull(emailHash, "emailHash");
            return this;
        }

        @JsonProperty(value="EmailHash")
        @CanIgnoreReturnValue
        public final Builder emailHash(Optional<String> emailHash) {
            this.emailHash = emailHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messageKey(String messageKey) {
            this.messageKey = Objects.requireNonNull(messageKey, "messageKey");
            return this;
        }

        @JsonProperty(value="MessageKey")
        @CanIgnoreReturnValue
        public final Builder messageKey(Optional<String> messageKey) {
            this.messageKey = messageKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transferRate(UnsignedInteger transferRate) {
            this.transferRate = Objects.requireNonNull(transferRate, "transferRate");
            return this;
        }

        @JsonProperty(value="TransferRate")
        @CanIgnoreReturnValue
        public final Builder transferRate(Optional<? extends UnsignedInteger> transferRate) {
            this.transferRate = transferRate.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tickSize(UnsignedInteger tickSize) {
            this.tickSize = Objects.requireNonNull(tickSize, "tickSize");
            return this;
        }

        @JsonProperty(value="TickSize")
        @CanIgnoreReturnValue
        public final Builder tickSize(Optional<? extends UnsignedInteger> tickSize) {
            this.tickSize = tickSize.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mintAccount(Address mintAccount) {
            this.mintAccount = Objects.requireNonNull(mintAccount, "mintAccount");
            return this;
        }

        @JsonProperty(value="NFTokenMinter")
        @CanIgnoreReturnValue
        public final Builder mintAccount(Optional<? extends Address> mintAccount) {
            this.mintAccount = mintAccount.orElse(null);
            return this;
        }

        public ImmutableAccountSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableAccountSet.validate(new ImmutableAccountSet(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fee");
            }
            return "Cannot build AccountSet, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="AccountSet", generator="Immutables")
    private final class InitShim {
        private byte sequenceBuildStage = 0;
        private UnsignedInteger sequence;
        private byte signingPublicKeyBuildStage = 0;
        private PublicKey signingPublicKey;
        private byte flagsBuildStage = 0;
        private AccountSetTransactionFlags flags;

        private InitShim() {
        }

        UnsignedInteger sequence() {
            if (this.sequenceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sequenceBuildStage == 0) {
                this.sequenceBuildStage = (byte)-1;
                this.sequence = Objects.requireNonNull(ImmutableAccountSet.this.sequenceInitialize(), "sequence");
                this.sequenceBuildStage = 1;
            }
            return this.sequence;
        }

        void sequence(UnsignedInteger sequence) {
            this.sequence = sequence;
            this.sequenceBuildStage = 1;
        }

        PublicKey signingPublicKey() {
            if (this.signingPublicKeyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.signingPublicKeyBuildStage == 0) {
                this.signingPublicKeyBuildStage = (byte)-1;
                this.signingPublicKey = Objects.requireNonNull(ImmutableAccountSet.this.signingPublicKeyInitialize(), "signingPublicKey");
                this.signingPublicKeyBuildStage = 1;
            }
            return this.signingPublicKey;
        }

        void signingPublicKey(PublicKey signingPublicKey) {
            this.signingPublicKey = signingPublicKey;
            this.signingPublicKeyBuildStage = 1;
        }

        AccountSetTransactionFlags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutableAccountSet.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(AccountSetTransactionFlags flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sequenceBuildStage == -1) {
                attributes.add("sequence");
            }
            if (this.signingPublicKeyBuildStage == -1) {
                attributes.add("signingPublicKey");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build AccountSet, attribute initializers form cycle " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountSet", generator="Immutables")
    static final class Json
    implements AccountSet {
        @Nullable
        Address account;
        @Nullable
        XrpCurrencyAmount fee;
        @Nullable
        UnsignedInteger sequence;
        @Nullable
        Optional<UnsignedInteger> ticketSequence = Optional.empty();
        @Nullable
        Optional<Hash256> accountTransactionId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> lastLedgerSequence = Optional.empty();
        @Nullable
        List<MemoWrapper> memos = ImmutableList.of();
        @Nullable
        List<SignerWrapper> signers = ImmutableList.of();
        @Nullable
        Optional<UnsignedInteger> sourceTag = Optional.empty();
        @Nullable
        PublicKey signingPublicKey;
        @Nullable
        Optional<Signature> transactionSignature = Optional.empty();
        @Nullable
        Optional<NetworkId> networkId = Optional.empty();
        @Nullable
        AccountSetTransactionFlags flags;
        @Nullable
        Optional<AccountSet.AccountSetFlag> clearFlag = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> clearFlagRawValue = Optional.empty();
        @Nullable
        Optional<AccountSet.AccountSetFlag> setFlag = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> setFlagRawValue = Optional.empty();
        @Nullable
        Optional<String> domain = Optional.empty();
        @Nullable
        Optional<String> emailHash = Optional.empty();
        @Nullable
        Optional<String> messageKey = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> transferRate = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> tickSize = Optional.empty();
        @Nullable
        Optional<Address> mintAccount = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="Fee")
        public void setFee(XrpCurrencyAmount fee) {
            this.fee = fee;
        }

        @JsonProperty(value="Sequence")
        public void setSequence(UnsignedInteger sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="TicketSequence")
        public void setTicketSequence(Optional<UnsignedInteger> ticketSequence) {
            this.ticketSequence = ticketSequence;
        }

        @JsonProperty(value="AccountTxnID")
        public void setAccountTransactionId(Optional<Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId;
        }

        @JsonProperty(value="LastLedgerSequence")
        public void setLastLedgerSequence(Optional<UnsignedInteger> lastLedgerSequence) {
            this.lastLedgerSequence = lastLedgerSequence;
        }

        @JsonProperty(value="Memos")
        public void setMemos(List<MemoWrapper> memos) {
            this.memos = memos;
        }

        @JsonProperty(value="Signers")
        public void setSigners(List<SignerWrapper> signers) {
            this.signers = signers;
        }

        @JsonProperty(value="SourceTag")
        public void setSourceTag(Optional<UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="SigningPubKey")
        public void setSigningPublicKey(PublicKey signingPublicKey) {
            this.signingPublicKey = signingPublicKey;
        }

        @JsonProperty(value="TxnSignature")
        public void setTransactionSignature(Optional<Signature> transactionSignature) {
            this.transactionSignature = transactionSignature;
        }

        @JsonProperty(value="NetworkID")
        public void setNetworkId(Optional<NetworkId> networkId) {
            this.networkId = networkId;
        }

        @JsonProperty(value="Flags")
        public void setFlags(AccountSetTransactionFlags flags) {
            this.flags = flags;
        }

        @JsonProperty(value="clearFlag")
        @JsonIgnore
        public void setClearFlag(Optional<AccountSet.AccountSetFlag> clearFlag) {
            this.clearFlag = clearFlag;
        }

        @JsonProperty(value="ClearFlag")
        public void setClearFlagRawValue(Optional<UnsignedInteger> clearFlagRawValue) {
            this.clearFlagRawValue = clearFlagRawValue;
        }

        @JsonProperty(value="setFlag")
        @JsonIgnore
        public void setSetFlag(Optional<AccountSet.AccountSetFlag> setFlag) {
            this.setFlag = setFlag;
        }

        @JsonProperty(value="SetFlag")
        public void setSetFlagRawValue(Optional<UnsignedInteger> setFlagRawValue) {
            this.setFlagRawValue = setFlagRawValue;
        }

        @JsonProperty(value="Domain")
        public void setDomain(Optional<String> domain) {
            this.domain = domain;
        }

        @JsonProperty(value="EmailHash")
        public void setEmailHash(Optional<String> emailHash) {
            this.emailHash = emailHash;
        }

        @JsonProperty(value="MessageKey")
        public void setMessageKey(Optional<String> messageKey) {
            this.messageKey = messageKey;
        }

        @JsonProperty(value="TransferRate")
        public void setTransferRate(Optional<UnsignedInteger> transferRate) {
            this.transferRate = transferRate;
        }

        @JsonProperty(value="TickSize")
        public void setTickSize(Optional<UnsignedInteger> tickSize) {
            this.tickSize = tickSize;
        }

        @JsonProperty(value="NFTokenMinter")
        public void setMintAccount(Optional<Address> mintAccount) {
            this.mintAccount = mintAccount;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount fee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> ticketSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> accountTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> lastLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MemoWrapper> memos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SignerWrapper> signers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sourceTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PublicKey signingPublicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Signature> transactionSignature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NetworkId> networkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AccountSetTransactionFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<AccountSet.AccountSetFlag> clearFlag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> clearFlagRawValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<AccountSet.AccountSetFlag> setFlag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> setFlagRawValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> domain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> emailHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> messageKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> transferRate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> tickSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> mintAccount() {
            throw new UnsupportedOperationException();
        }
    }
}

