/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionReader;
import com.ripple.cryptoconditions.CryptoConditionWriter;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.der.DerEncodingException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xrpl.xrpl4j.model.flags.TransactionFlags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.ImmutableEscrowFinish;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@JsonSerialize(as=ImmutableEscrowFinish.class)
@JsonDeserialize(as=ImmutableEscrowFinish.class)
@Value.Immutable
public interface EscrowFinish
extends Transaction {
    public static final Logger logger = LoggerFactory.getLogger(EscrowFinish.class);

    public static ImmutableEscrowFinish.Builder builder() {
        return ImmutableEscrowFinish.builder();
    }

    public static XrpCurrencyAmount computeFee(XrpCurrencyAmount currentLedgerFeeDrops, Fulfillment fulfillment) {
        Objects.requireNonNull(currentLedgerFeeDrops);
        Objects.requireNonNull(fulfillment);
        UnsignedLong newFee = currentLedgerFeeDrops.value().plus(UnsignedLong.valueOf((long)320L)).plus(UnsignedLong.valueOf((long)(10L * (fulfillment.getDerivedCondition().getCost() / 16L))));
        return XrpCurrencyAmount.of(newFee);
    }

    @JsonProperty(value="Flags")
    @Value.Default
    default public TransactionFlags flags() {
        return TransactionFlags.EMPTY;
    }

    @JsonProperty(value="Owner")
    public Address owner();

    @JsonProperty(value="OfferSequence")
    public UnsignedInteger offerSequence();

    @JsonIgnore
    public Optional<Condition> condition();

    @JsonProperty(value="Condition")
    public Optional<String> conditionRawValue();

    @JsonIgnore
    public Optional<Fulfillment<?>> fulfillment();

    @JsonProperty(value="Fulfillment")
    public Optional<String> fulfillmentRawValue();

    /*
     * Loose catch block
     */
    @Value.Check
    default public EscrowFinish normalizeCondition() {
        block7: {
            if (!this.condition().isPresent() && !this.conditionRawValue().isPresent()) {
                return this;
            }
            if (this.condition().isPresent() && this.conditionRawValue().isPresent()) {
                Preconditions.checkState((boolean)Arrays.equals(CryptoConditionWriter.writeCondition((Condition)this.condition().get()), BaseEncoding.base16().decode((CharSequence)this.conditionRawValue().get())), (Object)"condition and conditionRawValue should be equivalent if both are present.");
                return this;
            }
            if (!this.condition().isPresent() || this.conditionRawValue().isPresent()) break block7;
            return EscrowFinish.builder().from(this).conditionRawValue(BaseEncoding.base16().encode(CryptoConditionWriter.writeCondition((Condition)this.condition().get()))).build();
            {
                catch (DerEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            Condition condition = CryptoConditionReader.readCondition((byte[])BaseEncoding.base16().decode((CharSequence)this.conditionRawValue().get().toUpperCase(Locale.US)));
            return EscrowFinish.builder().from(this).condition(condition).build();
        }
        catch (DerEncodingException | IllegalArgumentException e) {
            logger.warn("EscrowFinish Condition was malformed. conditionRawValue() will contain the condition value, but condition() will be empty: {}", (Object)e.getMessage(), (Object)e);
            return this;
        }
    }

    /*
     * Loose catch block
     */
    @Value.Check
    default public EscrowFinish normalizeFulfillment() {
        block7: {
            if (!this.fulfillment().isPresent() && !this.fulfillmentRawValue().isPresent()) {
                return this;
            }
            if (this.fulfillment().isPresent() && this.fulfillmentRawValue().isPresent()) {
                Preconditions.checkState((boolean)Arrays.equals(CryptoConditionWriter.writeFulfillment(this.fulfillment().get()), BaseEncoding.base16().decode((CharSequence)this.fulfillmentRawValue().get())), (Object)"fulfillment and fulfillmentRawValue should be equivalent if both are present.");
                return this;
            }
            if (!this.fulfillment().isPresent() || this.fulfillmentRawValue().isPresent()) break block7;
            return EscrowFinish.builder().from(this).fulfillmentRawValue(BaseEncoding.base16().encode(CryptoConditionWriter.writeFulfillment(this.fulfillment().get()))).build();
            {
                catch (DerEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            Fulfillment fulfillment = CryptoConditionReader.readFulfillment((byte[])BaseEncoding.base16().decode((CharSequence)this.fulfillmentRawValue().get().toUpperCase(Locale.US)));
            return EscrowFinish.builder().from(this).fulfillment(fulfillment).build();
        }
        catch (DerEncodingException | IllegalArgumentException e) {
            logger.warn("EscrowFinish Fulfillment was malformed. fulfillmentRawValue() will contain the fulfillment value, but fulfillment() will be empty: {}", (Object)e.getMessage(), (Object)e);
            return this;
        }
    }
}

