/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import com.google.common.primitives.UnsignedInteger;
import java.util.List;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.ImmutableXChainOwnedClaimIdObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.XChainClaimAttestation;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;
import org.xrpl.xrpl4j.model.transactions.XChainClaimId;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@JsonSerialize(as=ImmutableXChainOwnedClaimIdObject.class)
@JsonDeserialize(as=ImmutableXChainOwnedClaimIdObject.class)
@Beta
@Value.Immutable
public interface XChainOwnedClaimIdObject
extends LedgerObject {
    public static ImmutableXChainOwnedClaimIdObject.Builder builder() {
        return ImmutableXChainOwnedClaimIdObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.XCHAIN_OWNED_CLAIM_ID;
    }

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags flags() {
        return Flags.UNSET;
    }

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="XChainBridge")
    public XChainBridge xChainBridge();

    @JsonProperty(value="XChainClaimID")
    public XChainClaimId xChainClaimId();

    @JsonProperty(value="OtherChainSource")
    public Address otherChainSource();

    @JsonProperty(value="XChainClaimAttestations")
    public List<XChainClaimAttestation> xChainClaimAttestations();

    @JsonProperty(value="SignatureReward")
    public XrpCurrencyAmount signatureReward();

    @JsonProperty(value="OwnerNode")
    public String ownerNode();

    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence();

    public Hash256 index();
}

