/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.util.List;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.SignerListFlags;
import org.xrpl.xrpl4j.model.ledger.ImmutableSignerListObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.SignerEntryWrapper;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableSignerListObject.class)
@JsonDeserialize(as=ImmutableSignerListObject.class)
@Value.Immutable
public interface SignerListObject
extends LedgerObject {
    public static ImmutableSignerListObject.Builder builder() {
        return ImmutableSignerListObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.SIGNER_LIST;
    }

    @JsonProperty(value="Flags")
    public SignerListFlags flags();

    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence();

    @JsonProperty(value="OwnerNode")
    public String ownerNode();

    @JsonProperty(value="SignerListID")
    public UnsignedInteger signerListId();

    @JsonProperty(value="SignerQuorum")
    public UnsignedInteger signerQuorum();

    @JsonProperty(value="SignerEntries")
    public List<SignerEntryWrapper> signerEntries();

    public Hash256 index();
}

