/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.RippleStateFlags;
import org.xrpl.xrpl4j.model.ledger.ImmutableRippleStateObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;

@JsonSerialize(as=ImmutableRippleStateObject.class)
@JsonDeserialize(as=ImmutableRippleStateObject.class)
@Value.Immutable
public interface RippleStateObject
extends LedgerObject {
    public static ImmutableRippleStateObject.Builder builder() {
        return ImmutableRippleStateObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.RIPPLE_STATE;
    }

    @JsonProperty(value="Flags")
    public RippleStateFlags flags();

    @JsonProperty(value="Balance")
    public IssuedCurrencyAmount balance();

    @JsonProperty(value="LowLimit")
    public IssuedCurrencyAmount lowLimit();

    @JsonProperty(value="HighLimit")
    public IssuedCurrencyAmount highLimit();

    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence();

    @JsonProperty(value="LowNode")
    public Optional<String> lowNode();

    @JsonProperty(value="HighNode")
    public Optional<String> highNode();

    @JsonProperty(value="LowQualityIn")
    public Optional<UnsignedInteger> lowQualityIn();

    @JsonProperty(value="LowQualityOut")
    public Optional<UnsignedInteger> lowQualityOut();

    @JsonProperty(value="HighQualityIn")
    public Optional<UnsignedInteger> highQualityIn();

    @JsonProperty(value="HighQualityOut")
    public Optional<UnsignedInteger> highQualityOut();

    public Hash256 index();
}

